// python wrapper for vtkOpenVDBReader
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkOpenVDBReader.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkOpenVDBReader(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkOpenVDBReader_ClassNew(); }


static PyObject *
PyvtkOpenVDBReader_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkOpenVDBReader::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkOpenVDBReader::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkOpenVDBReader *tempr = vtkOpenVDBReader::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkOpenVDBReader *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkOpenVDBReader::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkOpenVDBReader::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkOpenVDBReader::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_CanReadFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CanReadFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->CanReadFile(temp0) :
      op->vtkOpenVDBReader::CanReadFile(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_GetFileExtensions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileExtensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetFileExtensions() :
      op->vtkOpenVDBReader::GetFileExtensions());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->vtkOpenVDBReader::SetFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileName() :
      op->vtkOpenVDBReader::GetFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_GetDescriptiveName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDescriptiveName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetDescriptiveName() :
      op->vtkOpenVDBReader::GetDescriptiveName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_SetDownsamplingFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDownsamplingFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDownsamplingFactor(temp0);
    }
    else
    {
      op->vtkOpenVDBReader::SetDownsamplingFactor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_GetDownsamplingFactorMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDownsamplingFactorMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetDownsamplingFactorMinValue() :
      op->vtkOpenVDBReader::GetDownsamplingFactorMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_GetDownsamplingFactorMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDownsamplingFactorMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetDownsamplingFactorMaxValue() :
      op->vtkOpenVDBReader::GetDownsamplingFactorMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_GetDownsamplingFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDownsamplingFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetDownsamplingFactor() :
      op->vtkOpenVDBReader::GetDownsamplingFactor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_SetMergeImageVolumes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMergeImageVolumes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMergeImageVolumes(temp0);
    }
    else
    {
      op->vtkOpenVDBReader::SetMergeImageVolumes(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_GetMergeImageVolumes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMergeImageVolumes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetMergeImageVolumes() :
      op->vtkOpenVDBReader::GetMergeImageVolumes());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_MergeImageVolumesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MergeImageVolumesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->MergeImageVolumesOn();
    }
    else
    {
      op->vtkOpenVDBReader::MergeImageVolumesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_MergeImageVolumesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MergeImageVolumesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->MergeImageVolumesOff();
    }
    else
    {
      op->vtkOpenVDBReader::MergeImageVolumesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_GetMergePointSets(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMergePointSets");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetMergePointSets() :
      op->vtkOpenVDBReader::GetMergePointSets());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_SetMergePointSets(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMergePointSets");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMergePointSets(temp0);
    }
    else
    {
      op->vtkOpenVDBReader::SetMergePointSets(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_MergePointSetsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MergePointSetsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->MergePointSetsOn();
    }
    else
    {
      op->vtkOpenVDBReader::MergePointSetsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_MergePointSetsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MergePointSetsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->MergePointSetsOff();
    }
    else
    {
      op->vtkOpenVDBReader::MergePointSetsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_GetGridSelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGridSelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetGridSelection() :
      op->vtkOpenVDBReader::GetGridSelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_GetNumberOfGridsSelectionArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGridsSelectionArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfGridsSelectionArrays() :
      op->vtkOpenVDBReader::GetNumberOfGridsSelectionArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_GetGridsSelectionArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGridsSelectionArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetGridsSelectionArrayName(temp0) :
      op->vtkOpenVDBReader::GetGridsSelectionArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_GetGridsSelectionArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGridsSelectionArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetGridsSelectionArrayStatus(temp0) :
      op->vtkOpenVDBReader::GetGridsSelectionArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_SetGridsSelectionArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGridsSelectionArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetGridsSelectionArrayStatus(temp0, temp1);
    }
    else
    {
      op->vtkOpenVDBReader::SetGridsSelectionArrayStatus(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_GetGridArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGridArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetGridArrayName(temp0) :
      op->vtkOpenVDBReader::GetGridArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_GetGridArrayType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGridArrayType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetGridArrayType(temp0) :
      op->vtkOpenVDBReader::GetGridArrayType(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOpenVDBReader_NumberOfGrids(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NumberOfGrids");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOpenVDBReader *op = static_cast<vtkOpenVDBReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->NumberOfGrids() :
      op->vtkOpenVDBReader::NumberOfGrids());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkOpenVDBReader_Methods[] = {
  {"IsTypeOf", PyvtkOpenVDBReader_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkOpenVDBReader_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkOpenVDBReader_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkOpenVDBReader\nC++: static vtkOpenVDBReader *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkOpenVDBReader_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkOpenVDBReader\nC++: vtkOpenVDBReader *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkOpenVDBReader_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkOpenVDBReader_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"CanReadFile", PyvtkOpenVDBReader_CanReadFile, METH_VARARGS,
   "CanReadFile(self, __a:str) -> bool\nC++: bool CanReadFile(const char *)\n\nReturns whether a file can be read by the reader or not.\nThe parameter is the path to the file.\n"},
  {"GetFileExtensions", PyvtkOpenVDBReader_GetFileExtensions, METH_VARARGS,
   "GetFileExtensions(self) -> str\nC++: const char *GetFileExtensions()\n\nGet the file extensions for this format. Returns a string with a\nspace separated list of extensions in the format .extension\n"},
  {"SetFileName", PyvtkOpenVDBReader_SetFileName, METH_VARARGS,
   "SetFileName(self, _arg:str) -> None\nC++: virtual void SetFileName(const char *_arg)\n\nSet/get the file name to be opened by the reader.\n"},
  {"GetFileName", PyvtkOpenVDBReader_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: virtual char *GetFileName()\n\n"},
  {"GetDescriptiveName", PyvtkOpenVDBReader_GetDescriptiveName, METH_VARARGS,
   "GetDescriptiveName(self) -> str\nC++: const char *GetDescriptiveName()\n\nReturn a descriptive name for the file format that might be\nuseful in a GUI.\n"},
  {"SetDownsamplingFactor", PyvtkOpenVDBReader_SetDownsamplingFactor, METH_VARARGS,
   "SetDownsamplingFactor(self, _arg:float) -> None\nC++: virtual void SetDownsamplingFactor(float _arg)\n\nGet/Set the downsampling factor used to convert VDB data to image\ndata. Should be between 0.05 (very downsampled) and 1.0 (not\ndownsampled). It is only considered for image volume grids.\nDefault value is 1.0.\n"},
  {"GetDownsamplingFactorMinValue", PyvtkOpenVDBReader_GetDownsamplingFactorMinValue, METH_VARARGS,
   "GetDownsamplingFactorMinValue(self) -> float\nC++: virtual float GetDownsamplingFactorMinValue()\n\n"},
  {"GetDownsamplingFactorMaxValue", PyvtkOpenVDBReader_GetDownsamplingFactorMaxValue, METH_VARARGS,
   "GetDownsamplingFactorMaxValue(self) -> float\nC++: virtual float GetDownsamplingFactorMaxValue()\n\n"},
  {"GetDownsamplingFactor", PyvtkOpenVDBReader_GetDownsamplingFactor, METH_VARARGS,
   "GetDownsamplingFactor(self) -> float\nC++: virtual float GetDownsamplingFactor()\n\n"},
  {"SetMergeImageVolumes", PyvtkOpenVDBReader_SetMergeImageVolumes, METH_VARARGS,
   "SetMergeImageVolumes(self, _arg:bool) -> None\nC++: virtual void SetMergeImageVolumes(bool _arg)\n\nWhen enabled, the reader will merge all the requested image grids\ninto a single vtkImageData. This vtkImageData will have several\narrays, one for each requested image volume grid. When disabled,\nthere will be one vtkImageData per requested image grid, each\ncontaining one data array. It is disabled by default.\n"},
  {"GetMergeImageVolumes", PyvtkOpenVDBReader_GetMergeImageVolumes, METH_VARARGS,
   "GetMergeImageVolumes(self) -> bool\nC++: virtual bool GetMergeImageVolumes()\n\n"},
  {"MergeImageVolumesOn", PyvtkOpenVDBReader_MergeImageVolumesOn, METH_VARARGS,
   "MergeImageVolumesOn(self) -> None\nC++: virtual void MergeImageVolumesOn()\n\n"},
  {"MergeImageVolumesOff", PyvtkOpenVDBReader_MergeImageVolumesOff, METH_VARARGS,
   "MergeImageVolumesOff(self) -> None\nC++: virtual void MergeImageVolumesOff()\n\n"},
  {"GetMergePointSets", PyvtkOpenVDBReader_GetMergePointSets, METH_VARARGS,
   "GetMergePointSets(self) -> bool\nC++: virtual bool GetMergePointSets()\n\nWhen enabled, the reader will all the requested points cloud\ngrids into a single vtkPolyData. This vtkPolyData will contain\nthe points of every merged grid. When disabled, there will be one\nvtkPolyData per requested points cloud grid. It is disabled by\ndefault.\n"},
  {"SetMergePointSets", PyvtkOpenVDBReader_SetMergePointSets, METH_VARARGS,
   "SetMergePointSets(self, _arg:bool) -> None\nC++: virtual void SetMergePointSets(bool _arg)\n\n"},
  {"MergePointSetsOn", PyvtkOpenVDBReader_MergePointSetsOn, METH_VARARGS,
   "MergePointSetsOn(self) -> None\nC++: virtual void MergePointSetsOn()\n\n"},
  {"MergePointSetsOff", PyvtkOpenVDBReader_MergePointSetsOff, METH_VARARGS,
   "MergePointSetsOff(self) -> None\nC++: virtual void MergePointSetsOff()\n\n"},
  {"GetGridSelection", PyvtkOpenVDBReader_GetGridSelection, METH_VARARGS,
   "GetGridSelection(self) -> vtkDataArraySelection\nC++: virtual vtkDataArraySelection *GetGridSelection()\n\nStandard interface to a vtkDataArraySelection object, allowing\nthe user to choose the grids they want. They can get the number\nof available grids, get the descriptive name of a grid, and\nget/set the status (selected or not) of a grid.\n"},
  {"GetNumberOfGridsSelectionArrays", PyvtkOpenVDBReader_GetNumberOfGridsSelectionArrays, METH_VARARGS,
   "GetNumberOfGridsSelectionArrays(self) -> int\nC++: int GetNumberOfGridsSelectionArrays()\n\n"},
  {"GetGridsSelectionArrayName", PyvtkOpenVDBReader_GetGridsSelectionArrayName, METH_VARARGS,
   "GetGridsSelectionArrayName(self, index:int) -> str\nC++: const char *GetGridsSelectionArrayName(int index)\n\n"},
  {"GetGridsSelectionArrayStatus", PyvtkOpenVDBReader_GetGridsSelectionArrayStatus, METH_VARARGS,
   "GetGridsSelectionArrayStatus(self, name:str) -> int\nC++: int GetGridsSelectionArrayStatus(const char *name)\n\n"},
  {"SetGridsSelectionArrayStatus", PyvtkOpenVDBReader_SetGridsSelectionArrayStatus, METH_VARARGS,
   "SetGridsSelectionArrayStatus(self, name:str, status:int) -> None\nC++: void SetGridsSelectionArrayStatus(const char *name,\n    int status)\n\n"},
  {"GetGridArrayName", PyvtkOpenVDBReader_GetGridArrayName, METH_VARARGS,
   "GetGridArrayName(self, index:int) -> str\nC++: const char *GetGridArrayName(int index)\n\nGet the name of the grid with the given index in the input.\n"},
  {"GetGridArrayType", PyvtkOpenVDBReader_GetGridArrayType, METH_VARARGS,
   "GetGridArrayType(self, index:int) -> int\nC++: int GetGridArrayType(int index)\n\nGet the VTK object type corresponding to a given grid index. This\nis VTK_POLY_DATA for a point cloud, VTK_IMAGE_DATA for an image\nvolume, VTK_DATA_OBJECT when unsupported and -1 when out of\nrange.\n"},
  {"NumberOfGrids", PyvtkOpenVDBReader_NumberOfGrids, METH_VARARGS,
   "NumberOfGrids(self) -> int\nC++: int NumberOfGrids()\n\nGet the total number of grids available in the file\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkOpenVDBReader_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOpenVDBReader_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOpenVDBReader_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOpenVDBReader_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileName/SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("downsampling_factor"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOpenVDBReader_GetDownsamplingFactor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOpenVDBReader_SetDownsamplingFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOpenVDBReader_SetDownsamplingFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDownsamplingFactor/SetDownsamplingFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("merge_image_volumes"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOpenVDBReader_GetMergeImageVolumes(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOpenVDBReader_SetMergeImageVolumes(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOpenVDBReader_SetMergeImageVolumes(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMergeImageVolumes/SetMergeImageVolumes\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("merge_point_sets"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOpenVDBReader_GetMergePointSets(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOpenVDBReader_SetMergePointSets(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOpenVDBReader_SetMergePointSets(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMergePointSets/SetMergePointSets\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("file_extensions"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOpenVDBReader_GetFileExtensions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFileExtensions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("descriptive_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOpenVDBReader_GetDescriptiveName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDescriptiveName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("grid_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOpenVDBReader_GetGridSelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetGridSelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_grids_selection_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOpenVDBReader_GetNumberOfGridsSelectionArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfGridsSelectionArrays\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkOpenVDBReader_Doc =
  "vtkOpenVDBReader - OpenVDB reader\n\n"
  "Superclass: vtkPartitionedDataSetCollectionAlgorithm\n\n"
  "Reader for OpenVDB files. An OpenVDB file is a collection of grids.\n"
  "There are two types of grids: image volumes, and point clouds. The\n"
  "reader returns a vtkPartitionedDataSetCollection which reflects the\n"
  "grids of the file. An image volume will give a vtkImageData block,\n"
  "and a point cloud will give a vtkPolyData (with only vertices). It is\n"
  "also possible to merge all image volumes into a single vtkImageData,\n"
  "and independently merge all point clouds into a single vtkPolyData\n"
  "(cf vtkOpenVDBReader::SetMergeImageVolumes and\n"
  "vtkOpenVDBReader::SetMergePointSets).\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkOpenVDBReader_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOOpenVDB.vtkOpenVDBReader", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkOpenVDBReader_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkOpenVDBReader_StaticNew()
{
  return vtkOpenVDBReader::New();
}

PyObject *PyvtkOpenVDBReader_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkOpenVDBReader_Type, PyvtkOpenVDBReader_Methods,
    "vtkOpenVDBReader",
 &PyvtkOpenVDBReader_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkPartitionedDataSetCollectionAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkOpenVDBReader_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkOpenVDBReader(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkOpenVDBReader_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkOpenVDBReader", o) != 0)
  {
    Py_DECREF(o);
  }

}

