// python wrapper for vtkXdmf3DataSet
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkXdmf3DataSet.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkXdmf3DataSet(PyObject *dict); }

static PyObject *
PyvtkXdmf3DataSet_GetNumberOfPointsPerCell(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfPointsPerCell");

  int temp0;
  bool temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    unsigned int tempr = vtkXdmf3DataSet::GetNumberOfPointsPerCell(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(1, temp1);
    }
    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3DataSet_GetXdmfCellType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetXdmfCellType");

  int temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkXdmf3DataSet::GetXdmfCellType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkXdmf3DataSet_Methods[] = {
  {"GetNumberOfPointsPerCell", PyvtkXdmf3DataSet_GetNumberOfPointsPerCell, METH_VARARGS,
   "GetNumberOfPointsPerCell(vtk_cell_type:int, fail:bool) -> int\nC++: static unsigned int GetNumberOfPointsPerCell(\n    int vtk_cell_type, bool &fail)\n\nHelpers for Unstructured Grid translation\n"},
  {"GetXdmfCellType", PyvtkXdmf3DataSet_GetXdmfCellType, METH_VARARGS,
   "GetXdmfCellType(vtkType:int) -> int\nC++: static int GetXdmfCellType(int vtkType)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkXdmf3DataSet_GetSets[] = {
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static PyObject *
PyvtkXdmf3DataSet_vtkXdmf3DataSet_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkXdmf3DataSet");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkXdmf3DataSet *op = new vtkXdmf3DataSet();

    result = PyVTKSpecialObject_New("vtkXdmf3DataSet", op);
  }

  return result;
}

static PyObject *
PyvtkXdmf3DataSet_vtkXdmf3DataSet_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkXdmf3DataSet");

  vtkXdmf3DataSet *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkXdmf3DataSet"))
  {
    vtkXdmf3DataSet *op = new vtkXdmf3DataSet(*temp0);

    result = PyVTKSpecialObject_New("vtkXdmf3DataSet", op);
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyMethodDef PyvtkXdmf3DataSet_vtkXdmf3DataSet_Methods[] = {
  {"vtkXdmf3DataSet", PyvtkXdmf3DataSet_vtkXdmf3DataSet_s2, METH_VARARGS,
   "@W vtkXdmf3DataSet"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkXdmf3DataSet_vtkXdmf3DataSet(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkXdmf3DataSet_vtkXdmf3DataSet_s1(self, args);
    case 1:
      return PyvtkXdmf3DataSet_vtkXdmf3DataSet_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "vtkXdmf3DataSet");
  return nullptr;
}


static const char *PyvtkXdmf3DataSet_Doc =

  "vtkXdmf3DataSet() -> vtkXdmf3DataSet\nC++: vtkXdmf3DataSet()\nvtkXdmf3DataSet(__a:vtkXdmf3DataSet) -> vtkXdmf3DataSet\nC++: vtkXdmf3DataSet(const &vtkXdmf3DataSet)\n""\n"
  "vtkXdmf3DataSet - dataset level translation between xdmf3 and vtk\n\n"
  "This class holds static methods that translate the five atomic data\n"
  "types between vtk and xdmf3.\n\n"
  "This file is a helper for the vtkXdmf3Reader and vtkXdmf3Writer and\n"
  "not intended to be part of VTK public API\n\n";

static PyObject *
PyvtkXdmf3DataSet_New(PyTypeObject *, PyObject *args, PyObject *kwds)
{
  if (kwds && PyDict_Size(kwds))
  {
    PyErr_SetString(PyExc_TypeError,
                    "this function takes no keyword arguments");
    return nullptr;
  }

  return PyvtkXdmf3DataSet_vtkXdmf3DataSet(nullptr, args);
}

static void PyvtkXdmf3DataSet_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkXdmf3DataSet *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static Py_hash_t PyvtkXdmf3DataSet_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkXdmf3DataSet_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOXdmf3.vtkXdmf3DataSet", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkXdmf3DataSet_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkXdmf3DataSet_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkXdmf3DataSet_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkXdmf3DataSet_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static void *PyvtkXdmf3DataSet_CCopy(const void *obj)
{
  if (obj)
  {
    return new vtkXdmf3DataSet(*static_cast<const vtkXdmf3DataSet*>(obj));
  }
  return nullptr;
}

#ifndef DECLARED_PyvtkXdmf3DataSet_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkXdmf3DataSet_TypeNew(); }
#define DECLARED_PyvtkXdmf3DataSet_TypeNew
#endif

PyObject *PyvtkXdmf3DataSet_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkXdmf3DataSet_Type,
    PyvtkXdmf3DataSet_Methods,
    PyvtkXdmf3DataSet_GetSets,
    PyvtkXdmf3DataSet_vtkXdmf3DataSet_Methods,
    &PyvtkXdmf3DataSet_CCopy);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkXdmf3DataSet(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkXdmf3DataSet_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkXdmf3DataSet", o) != 0)
  {
    Py_DECREF(o);
  }

}

