// python wrapper for vtkXdmf3Reader
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkXdmf3Reader.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkXdmf3Reader(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkXdmf3Reader_ClassNew(); }


static PyObject *
PyvtkXdmf3Reader_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkXdmf3Reader::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkXdmf3Reader::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkXdmf3Reader *tempr = vtkXdmf3Reader::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkXdmf3Reader *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkXdmf3Reader::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkXdmf3Reader::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkXdmf3Reader::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->vtkXdmf3Reader::SetFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_AddFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->AddFileName(temp0);
    }
    else
    {
      op->vtkXdmf3Reader::AddFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_RemoveAllFileNames(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllFileNames");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllFileNames();
    }
    else
    {
      op->vtkXdmf3Reader::RemoveAllFileNames();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_SetFileSeriesAsTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileSeriesAsTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileSeriesAsTime(temp0);
    }
    else
    {
      op->vtkXdmf3Reader::SetFileSeriesAsTime(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetFileSeriesAsTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileSeriesAsTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetFileSeriesAsTime() :
      op->vtkXdmf3Reader::GetFileSeriesAsTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_CanReadFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CanReadFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->CanReadFile(temp0) :
      op->vtkXdmf3Reader::CanReadFile(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetNumberOfPointArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfPointArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfPointArrays() :
      op->vtkXdmf3Reader::GetNumberOfPointArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetPointArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetPointArrayName(temp0) :
      op->vtkXdmf3Reader::GetPointArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetPointArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPointArrayStatus(temp0) :
      op->vtkXdmf3Reader::GetPointArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_SetPointArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetPointArrayStatus(temp0, temp1);
    }
    else
    {
      op->vtkXdmf3Reader::SetPointArrayStatus(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetNumberOfCellArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfCellArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfCellArrays() :
      op->vtkXdmf3Reader::GetNumberOfCellArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetCellArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCellArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetCellArrayName(temp0) :
      op->vtkXdmf3Reader::GetCellArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_SetCellArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCellArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetCellArrayStatus(temp0, temp1);
    }
    else
    {
      op->vtkXdmf3Reader::SetCellArrayStatus(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetCellArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCellArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetCellArrayStatus(temp0) :
      op->vtkXdmf3Reader::GetCellArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetNumberOfFieldArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfFieldArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfFieldArrays() :
      op->vtkXdmf3Reader::GetNumberOfFieldArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetFieldArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetFieldArrayName(temp0) :
      op->vtkXdmf3Reader::GetFieldArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_SetFieldArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFieldArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetFieldArrayStatus(temp0, temp1);
    }
    else
    {
      op->vtkXdmf3Reader::SetFieldArrayStatus(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetFieldArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetFieldArrayStatus(temp0) :
      op->vtkXdmf3Reader::GetFieldArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetNumberOfGrids(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGrids");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfGrids() :
      op->vtkXdmf3Reader::GetNumberOfGrids());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetGridName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGridName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetGridName(temp0) :
      op->vtkXdmf3Reader::GetGridName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_SetGridStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGridStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetGridStatus(temp0, temp1);
    }
    else
    {
      op->vtkXdmf3Reader::SetGridStatus(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetGridStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGridStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetGridStatus(temp0) :
      op->vtkXdmf3Reader::GetGridStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetNumberOfSets(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfSets");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfSets() :
      op->vtkXdmf3Reader::GetNumberOfSets());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetSetName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSetName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetSetName(temp0) :
      op->vtkXdmf3Reader::GetSetName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_SetSetStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSetStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetSetStatus(temp0, temp1);
    }
    else
    {
      op->vtkXdmf3Reader::SetSetStatus(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetSetStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSetStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSetStatus(temp0) :
      op->vtkXdmf3Reader::GetSetStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetNumberOfSetArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfSetArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfSetArrays() :
      op->vtkXdmf3Reader::GetNumberOfSetArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetSetArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSetArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetSetArrayName(temp0) :
      op->vtkXdmf3Reader::GetSetArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetSetArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSetArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSetArrayStatus(temp0) :
      op->vtkXdmf3Reader::GetSetArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetSIL(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSIL");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkGraph *tempr = (ap.IsBound() ?
      op->GetSIL() :
      op->vtkXdmf3Reader::GetSIL());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3Reader_GetSILUpdateStamp(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSILUpdateStamp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXdmf3Reader *op = static_cast<vtkXdmf3Reader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSILUpdateStamp() :
      op->vtkXdmf3Reader::GetSILUpdateStamp());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkXdmf3Reader_Methods[] = {
  {"IsTypeOf", PyvtkXdmf3Reader_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkXdmf3Reader_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkXdmf3Reader_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkXdmf3Reader\nC++: static vtkXdmf3Reader *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkXdmf3Reader_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkXdmf3Reader\nC++: vtkXdmf3Reader *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkXdmf3Reader_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkXdmf3Reader_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetFileName", PyvtkXdmf3Reader_SetFileName, METH_VARARGS,
   "SetFileName(self, filename:str) -> None\nC++: void SetFileName(const char *filename)\n\nSet tells the reader the name of a single top level xml file to\nread.\n"},
  {"AddFileName", PyvtkXdmf3Reader_AddFileName, METH_VARARGS,
   "AddFileName(self, filename:str) -> None\nC++: virtual void AddFileName(const char *filename)\n\nAdd and remove give the reader a list of top level xml files to\nread. Whether the set is treated as a spatial or temporal\ncollection depends on FileSeriestAsTime.\n"},
  {"RemoveAllFileNames", PyvtkXdmf3Reader_RemoveAllFileNames, METH_VARARGS,
   "RemoveAllFileNames(self) -> None\nC++: virtual void RemoveAllFileNames()\n\n"},
  {"SetFileSeriesAsTime", PyvtkXdmf3Reader_SetFileSeriesAsTime, METH_VARARGS,
   "SetFileSeriesAsTime(self, _arg:bool) -> None\nC++: virtual void SetFileSeriesAsTime(bool _arg)\n\nWhen true (the default) the reader treats a series of files as a\ntemporal collection. When false it treats it as a spatial\npartition and uses an optimized top level partitioning strategy.\n"},
  {"GetFileSeriesAsTime", PyvtkXdmf3Reader_GetFileSeriesAsTime, METH_VARARGS,
   "GetFileSeriesAsTime(self) -> bool\nC++: virtual bool GetFileSeriesAsTime()\n\n"},
  {"CanReadFile", PyvtkXdmf3Reader_CanReadFile, METH_VARARGS,
   "CanReadFile(self, filename:str) -> int\nC++: virtual int CanReadFile(const char *filename)\n\nDetermine if the file can be read with this reader.\n"},
  {"GetNumberOfPointArrays", PyvtkXdmf3Reader_GetNumberOfPointArrays, METH_VARARGS,
   "GetNumberOfPointArrays(self) -> int\nC++: int GetNumberOfPointArrays()\n\nGet information about point-based arrays. As is typical with\nreaders this in only valid after the filename is set and\nUpdateInformation() has been called.\n"},
  {"GetPointArrayName", PyvtkXdmf3Reader_GetPointArrayName, METH_VARARGS,
   "GetPointArrayName(self, index:int) -> str\nC++: const char *GetPointArrayName(int index)\n\nReturns the name of point array at the give index. Returns\nnullptr if index is invalid.\n"},
  {"GetPointArrayStatus", PyvtkXdmf3Reader_GetPointArrayStatus, METH_VARARGS,
   "GetPointArrayStatus(self, name:str) -> int\nC++: int GetPointArrayStatus(const char *name)\n\nGet/Set the point array status.\n"},
  {"SetPointArrayStatus", PyvtkXdmf3Reader_SetPointArrayStatus, METH_VARARGS,
   "SetPointArrayStatus(self, name:str, status:int) -> None\nC++: void SetPointArrayStatus(const char *name, int status)\n\n"},
  {"GetNumberOfCellArrays", PyvtkXdmf3Reader_GetNumberOfCellArrays, METH_VARARGS,
   "GetNumberOfCellArrays(self) -> int\nC++: int GetNumberOfCellArrays()\n\nGet information about cell-based arrays.  As is typical with\nreaders this in only valid after the filename is set and\nUpdateInformation() has been called.\n"},
  {"GetCellArrayName", PyvtkXdmf3Reader_GetCellArrayName, METH_VARARGS,
   "GetCellArrayName(self, index:int) -> str\nC++: const char *GetCellArrayName(int index)\n\n"},
  {"SetCellArrayStatus", PyvtkXdmf3Reader_SetCellArrayStatus, METH_VARARGS,
   "SetCellArrayStatus(self, name:str, status:int) -> None\nC++: void SetCellArrayStatus(const char *name, int status)\n\n"},
  {"GetCellArrayStatus", PyvtkXdmf3Reader_GetCellArrayStatus, METH_VARARGS,
   "GetCellArrayStatus(self, name:str) -> int\nC++: int GetCellArrayStatus(const char *name)\n\n"},
  {"GetNumberOfFieldArrays", PyvtkXdmf3Reader_GetNumberOfFieldArrays, METH_VARARGS,
   "GetNumberOfFieldArrays(self) -> int\nC++: int GetNumberOfFieldArrays()\n\nGet information about unaligned arrays.  As is typical with\nreaders this in only valid after the filename is set and\nUpdateInformation() has been called.\n"},
  {"GetFieldArrayName", PyvtkXdmf3Reader_GetFieldArrayName, METH_VARARGS,
   "GetFieldArrayName(self, index:int) -> str\nC++: const char *GetFieldArrayName(int index)\n\n"},
  {"SetFieldArrayStatus", PyvtkXdmf3Reader_SetFieldArrayStatus, METH_VARARGS,
   "SetFieldArrayStatus(self, name:str, status:int) -> None\nC++: void SetFieldArrayStatus(const char *name, int status)\n\n"},
  {"GetFieldArrayStatus", PyvtkXdmf3Reader_GetFieldArrayStatus, METH_VARARGS,
   "GetFieldArrayStatus(self, name:str) -> int\nC++: int GetFieldArrayStatus(const char *name)\n\n"},
  {"GetNumberOfGrids", PyvtkXdmf3Reader_GetNumberOfGrids, METH_VARARGS,
   "GetNumberOfGrids(self) -> int\nC++: int GetNumberOfGrids()\n\nGet/Set information about grids. As is typical with readers this\nis valid only after the filename as been set and\nUpdateInformation() has been called.\n"},
  {"GetGridName", PyvtkXdmf3Reader_GetGridName, METH_VARARGS,
   "GetGridName(self, index:int) -> str\nC++: const char *GetGridName(int index)\n\n"},
  {"SetGridStatus", PyvtkXdmf3Reader_SetGridStatus, METH_VARARGS,
   "SetGridStatus(self, gridname:str, status:int) -> None\nC++: void SetGridStatus(const char *gridname, int status)\n\n"},
  {"GetGridStatus", PyvtkXdmf3Reader_GetGridStatus, METH_VARARGS,
   "GetGridStatus(self, gridname:str) -> int\nC++: int GetGridStatus(const char *gridname)\n\n"},
  {"GetNumberOfSets", PyvtkXdmf3Reader_GetNumberOfSets, METH_VARARGS,
   "GetNumberOfSets(self) -> int\nC++: int GetNumberOfSets()\n\nGet/Set information about sets. As is typical with readers this\nis valid only after the filename as been set and\nUpdateInformation() has been called. Note that sets with non-zero\nGhost value are not treated as sets that the user can select\nusing this API.\n"},
  {"GetSetName", PyvtkXdmf3Reader_GetSetName, METH_VARARGS,
   "GetSetName(self, index:int) -> str\nC++: const char *GetSetName(int index)\n\n"},
  {"SetSetStatus", PyvtkXdmf3Reader_SetSetStatus, METH_VARARGS,
   "SetSetStatus(self, gridname:str, status:int) -> None\nC++: void SetSetStatus(const char *gridname, int status)\n\n"},
  {"GetSetStatus", PyvtkXdmf3Reader_GetSetStatus, METH_VARARGS,
   "GetSetStatus(self, gridname:str) -> int\nC++: int GetSetStatus(const char *gridname)\n\n"},
  {"GetNumberOfSetArrays", PyvtkXdmf3Reader_GetNumberOfSetArrays, METH_VARARGS,
   "GetNumberOfSetArrays(self) -> int\nC++: int GetNumberOfSetArrays()\n\nThese methods are provided to make it easier to use the Sets in\nParaView.\n"},
  {"GetSetArrayName", PyvtkXdmf3Reader_GetSetArrayName, METH_VARARGS,
   "GetSetArrayName(self, index:int) -> str\nC++: const char *GetSetArrayName(int index)\n\n"},
  {"GetSetArrayStatus", PyvtkXdmf3Reader_GetSetArrayStatus, METH_VARARGS,
   "GetSetArrayStatus(self, name:str) -> int\nC++: int GetSetArrayStatus(const char *name)\n\n"},
  {"GetSIL", PyvtkXdmf3Reader_GetSIL, METH_VARARGS,
   "GetSIL(self) -> vtkGraph\nC++: virtual vtkGraph *GetSIL()\n\nSIL describes organization of/relationships between\nclassifications eg. blocks/materials/hierarchies.\n"},
  {"GetSILUpdateStamp", PyvtkXdmf3Reader_GetSILUpdateStamp, METH_VARARGS,
   "GetSILUpdateStamp(self) -> int\nC++: int GetSILUpdateStamp()\n\nEvery time the SIL is updated a this will return a different\nvalue.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkXdmf3Reader_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("file_name"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkXdmf3Reader_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkXdmf3Reader_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("file_series_as_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkXdmf3Reader_GetFileSeriesAsTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkXdmf3Reader_SetFileSeriesAsTime(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkXdmf3Reader_SetFileSeriesAsTime(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileSeriesAsTime/SetFileSeriesAsTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("sil"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkXdmf3Reader_GetSIL(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSIL\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("sil_update_stamp"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkXdmf3Reader_GetSILUpdateStamp(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSILUpdateStamp\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_point_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkXdmf3Reader_GetNumberOfPointArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfPointArrays\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_cell_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkXdmf3Reader_GetNumberOfCellArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfCellArrays\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_field_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkXdmf3Reader_GetNumberOfFieldArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfFieldArrays\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_grids"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkXdmf3Reader_GetNumberOfGrids(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfGrids\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_sets"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkXdmf3Reader_GetNumberOfSets(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfSets\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_set_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkXdmf3Reader_GetNumberOfSetArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfSetArrays\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkXdmf3Reader_Doc =
  "vtkXdmf3Reader - Reads eXtensible Data Model and Formatfiles\n\n"
  "Superclass: vtkDataObjectAlgorithm\n\n"
  "vtkXdmf3Reader reads XDMF data files so that they can be visualized\n"
  "using VTK. The output data produced by this reader depends on the\n"
  "number of grids in the data file. If the data file has a single\n"
  "domain with a single grid, then the output type is a vtkDataSet\n"
  "subclass of the appropriate type, otherwise it's a\n"
  "vtkMultiBlockDataSet.\n\n"
  "@warning\n"
  "Uses the XDMF API (http://www.xdmf.org)\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkXdmf3Reader_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOXdmf3.vtkXdmf3Reader", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkXdmf3Reader_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkXdmf3Reader_StaticNew()
{
  return vtkXdmf3Reader::New();
}

PyObject *PyvtkXdmf3Reader_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkXdmf3Reader_Type, PyvtkXdmf3Reader_Methods,
    "vtkXdmf3Reader",
 &PyvtkXdmf3Reader_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkDataObjectAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkXdmf3Reader_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkXdmf3Reader(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkXdmf3Reader_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkXdmf3Reader", o) != 0)
  {
    Py_DECREF(o);
  }

}

