// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

#ifndef vtkRenderingFreeTypeFontConfigObjectFactory_h
#define vtkRenderingFreeTypeFontConfigObjectFactory_h

#include "vtkRenderingFreeTypeFontConfigModule.h" // For export macro
#include "vtkObjectFactory.h"

VTK_ABI_NAMESPACE_BEGIN

class VTKRENDERINGFREETYPEFONTCONFIG_EXPORT vtkRenderingFreeTypeFontConfigObjectFactory : public vtkObjectFactory
{
public:
  static vtkRenderingFreeTypeFontConfigObjectFactory * New();
  vtkTypeMacro(vtkRenderingFreeTypeFontConfigObjectFactory, vtkObjectFactory);

  const char * GetDescription() VTK_FUTURE_CONST override { return "vtkRenderingFreeTypeFontConfig factory overrides."; }

  const char * GetVTKSourceVersion() VTK_FUTURE_CONST override;

  void PrintSelf(ostream &os, vtkIndent indent) override;

protected:
  vtkRenderingFreeTypeFontConfigObjectFactory();

private:
  vtkRenderingFreeTypeFontConfigObjectFactory(const vtkRenderingFreeTypeFontConfigObjectFactory&) = delete;
  void operator=(const vtkRenderingFreeTypeFontConfigObjectFactory&) = delete;
};

VTK_ABI_NAMESPACE_END

#endif // vtkRenderingFreeTypeFontConfigObjectFactory_h
