// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkFluidMapperDepthFilterBiGaussFS.h"

const char *vtkFluidMapperDepthFilterBiGaussFS =
"//VTK::System::Dec\n"
"\n"
"// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen\n"
"// SPDX-License-Identifier: BSD-3-Clause\n"
"\n"
"uniform sampler2D fluidZTexture;\n"
"uniform int       viewportWidth;\n"
"uniform int       viewportHeight;\n"
"uniform float     particleRadius;\n"
"uniform int       filterRadius = 5;\n"
"uniform float     sigmaDepth   = 10.0f;\n"
"uniform float     farZValue;\n"
"\n"
"in vec2 texCoord;\n"
"\n"
"// the output of this shader\n"
"//VTK::Output::Dec\n"
"\n"
"//-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+\n"
"#define MAX_ADAPTIVE_RADIUS 32\n"
"#define PI_OVER_8           0.392699082f\n"
"\n"
"float compute_weight2D(vec2 r, float two_sigma2)\n"
"{\n"
"  return exp(-dot(r, r) / two_sigma2);\n"
"}\n"
"\n"
"float compute_weight1D(float r, float two_sigma2)\n"
"{\n"
"  return exp(-r * r / two_sigma2);\n"
"}\n"
"\n"
"//-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+\n"
"void main()\n"
"{\n"
"  vec2 blurRadius  = vec2(1.0 / float(viewportWidth), 1.0 / float(viewportHeight));\n"
"  float pixelDepth = texture(fluidZTexture, texCoord).r;\n"
"  float finalDepth;\n"
"\n"
"  if(pixelDepth >= 0.0f || pixelDepth <= farZValue)\n"
"  {\n"
"    finalDepth = pixelDepth;\n"
"  }\n"
"  else\n"
"  {\n"
"    float ratio      = viewportHeight / 2.0 / tan(PI_OVER_8);\n"
"    float K          = -filterRadius * ratio * particleRadius * 0.1f;\n"
"    int   filterSize = min(MAX_ADAPTIVE_RADIUS, int(ceil(K / pixelDepth)));\n"
"    float sigma      = filterSize / 3.0f;\n"
"    float two_sigma2 = 2.0f * sigma * sigma;\n"
"\n"
"    float threshold       = particleRadius * sigmaDepth;\n"
"    float sigmaDepth      = threshold / 3.0f;\n"
"    float two_sigmaDepth2 = 2.0f * sigmaDepth * sigmaDepth;\n"
"\n"
"    vec4 f_tex = texCoord.xyxy;\n"
"    vec2 r     = vec2(0, 0);\n"
"    vec4 sum4  = vec4(pixelDepth, 0, 0, 0);\n"
"    vec4 wsum4 = vec4(1, 0, 0, 0);\n"
"    vec4 sampleDepth;\n"
"    vec4 w4_r;\n"
"    vec4 w4_depth;\n"
"    vec4 rDepth;\n"
"\n"
"    for(int x = 1; x <= filterSize; ++x)\n"
"    {\n"
"      r.x     += blurRadius.x;\n"
"      f_tex.x += blurRadius.x;\n"
"      f_tex.z -= blurRadius.x;\n"
"      vec4 f_tex1 = f_tex.xyxy;\n"
"      vec4 f_tex2 = f_tex.zwzw;\n"
"\n"
"      for(int y = 1; y <= filterSize; ++y)\n"
"      {\n"
"        r.y += blurRadius.y;\n"
"\n"
"        f_tex1.y += blurRadius.y;\n"
"        f_tex1.w -= blurRadius.y;\n"
"        f_tex2.y += blurRadius.y;\n"
"        f_tex2.w -= blurRadius.y;\n"
"\n"
"        sampleDepth.x = texture(fluidZTexture, f_tex1.xy).r;\n"
"        sampleDepth.y = texture(fluidZTexture, f_tex1.zw).r;\n"
"        sampleDepth.z = texture(fluidZTexture, f_tex2.xy).r;\n"
"        sampleDepth.w = texture(fluidZTexture, f_tex2.zw).r;\n"
"\n"
"        rDepth     = sampleDepth - vec4(pixelDepth);\n"
"        w4_r       = vec4(compute_weight2D(blurRadius * r, two_sigma2));\n"
"        w4_depth.x = compute_weight1D(rDepth.x, two_sigmaDepth2);\n"
"        w4_depth.y = compute_weight1D(rDepth.y, two_sigmaDepth2);\n"
"        w4_depth.z = compute_weight1D(rDepth.z, two_sigmaDepth2);\n"
"        w4_depth.w = compute_weight1D(rDepth.w, two_sigmaDepth2);\n"
"\n"
"        sum4  += sampleDepth * w4_r * w4_depth;\n"
"        wsum4 += w4_r * w4_depth;\n"
"      }\n"
"    }\n"
"\n"
"    vec2 filterVal;\n"
"    filterVal.x = dot(sum4, vec4(1, 1, 1, 1));\n"
"    filterVal.y = dot(wsum4, vec4(1, 1, 1, 1));\n"
"\n"
"    finalDepth = filterVal.x / filterVal.y;\n"
"  }\n"
"\n"
"  gl_FragData[0] = vec4(finalDepth, 0, 0, 1.0);\n"
"}\n"
"";
