// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkFluidMapperFS.h"

const char *vtkFluidMapperFS =
"//VTK::System::Dec\n"
"\n"
"// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen\n"
"// SPDX-License-Identifier: BSD-3-Clause\n"
"\n"
"// uniform int PrimitiveIDOffset;\n"
"\n"
"//VTK::CustomUniforms::Dec\n"
"\n"
"// VC position of this fragment\n"
"in vec4 vertexVCVSOutput;\n"
"\n"
"// vertex color\n"
"uniform int hasVertexColor;\n"
"in vec3 colorVCGSOutput;\n"
"\n"
"// Camera prop\n"
"uniform mat4 VCDCMatrix;\n"
"uniform mat4 MCVCMatrix;\n"
"uniform int  cameraParallel;\n"
"\n"
"uniform int outputEyeZ = 1;\n"
"\n"
"// optional color passed in from the vertex shader, vertexColor\n"
"//VTK::Color::Dec\n"
"\n"
"// optional surface normal declaration\n"
"uniform float particleRadius;\n"
"in vec3 centerVCVSOutput;\n"
"\n"
"// Texture maps\n"
"uniform sampler2D opaqueZTexture;\n"
"\n"
"// picking support\n"
"//VTK::Picking::Dec\n"
"\n"
"// Depth Peeling Support\n"
"//VTK::DepthPeeling::Dec\n"
"\n"
"// clipping plane vars\n"
"//VTK::Clip::Dec\n"
"\n"
"// the output of this shader\n"
"//VTK::Output::Dec\n"
"\n"
"void main()\n"
"{\n"
"  // VC position of this fragment. This should not branch/return/discard.\n"
"  vec4  vertexVC   = vertexVCVSOutput;\n"
"  float originalVZ = vertexVC.z;\n"
"\n"
"  // Place any calls that require uniform flow (e.g. dFdx) here.\n"
"  //VTK::UniformFlow::Impl\n"
"\n"
"  // Set gl_FragDepth here (gl_FragCoord.z by default)\n"
"  // compute the eye position and unit direction\n"
"  vec3 EyePos;\n"
"  vec3 EyeDir;\n"
"  if(cameraParallel != 0)\n"
"  {\n"
"    EyePos = vec3(vertexVC.x, vertexVC.y, vertexVC.z + particleRadius);\n"
"    EyeDir = vec3(0.0, 0.0, -1.0);\n"
"  }\n"
"  else\n"
"  {\n"
"    EyeDir = vertexVC.xyz;\n"
"    EyePos = vec3(0.0, 0.0, 0.0);\n"
"    float lengthED = length(EyeDir);\n"
"    EyeDir = normalize(EyeDir);\n"
"      // we adjust the EyePos to be closer if it is too far away\n"
"      // to prevent floating point precision noise\n"
"      if(lengthED > particleRadius)\n"
"      {\n"
"        EyePos = vertexVC.xyz - EyeDir * particleRadius;\n"
"      }\n"
"    }\n"
"\n"
"    // translate to Sphere center\n"
"    EyePos = EyePos - centerVCVSOutput;\n"
"    // scale to particleRadius 1.0\n"
"    EyePos = EyePos / particleRadius;\n"
"    // find the intersection\n"
"    float b = 2.0 * dot(EyePos, EyeDir);\n"
"    float c = dot(EyePos, EyePos) - 1.0;\n"
"    float d = b * b - 4.0 * c;\n"
"    vec3  normalVCVSOutput = vec3(0.0, 0.0, 1.0);\n"
"    if(d < 0.0)\n"
"    {\n"
"      discard;\n"
"    }\n"
"    float t = (-b - sqrt(d)) * 0.5;\n"
"\n"
"    // compute the normal, for unit sphere this is just\n"
"    // the intersection point\n"
"    normalVCVSOutput = normalize(EyePos + t * EyeDir);\n"
"    // compute the intersection point in VC\n"
"    vertexVC.xyz = normalVCVSOutput * particleRadius + centerVCVSOutput;\n"
"    // compute the pixel's depth\n"
"    // \" normalVCVSOutput = vec3(0,0,1);\n"
"    vec4 pos = VCDCMatrix * vertexVC;\n"
"    gl_FragDepth = (pos.z / pos.w + 1.0) / 2.0;\n"
"\n"
"    //VTK::Clip::Impl\n"
"\n"
"    //VTK::Color::Impl\n"
"\n"
"    float odepth = texelFetch(opaqueZTexture, ivec2(int(gl_FragCoord.x + 0.5), int(gl_FragCoord.y + 0.5)), 0).r;\n"
"    if(gl_FragDepth >= odepth)\n"
"    {\n"
"      discard;\n"
"    }\n"
"\n"
"    // If output eye coordinate depth\n"
"    if(outputEyeZ != 0)\n"
"    {\n"
"      gl_FragData[0] = vec4(vertexVC.z, 0, 0, 1.0);\n"
"    }\n"
"    else\n"
"    // thickness and vertex color (if applicable)\n"
"    {\n"
"      gl_FragData[0] = vec4(vertexVC.z - originalVZ, 0, 0, 1.0);\n"
"      if(hasVertexColor == 1)\n"
"      {\n"
"        gl_FragData[1] = vec4(colorVCGSOutput, 1.0);\n"
"      }\n"
"    }\n"
"}\n"
"";
