// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkFluidMapperFinalFS.h"

const char *vtkFluidMapperFinalFS =
"//VTK::System::Dec\n"
"\n"
"// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen\n"
"// SPDX-License-Identifier: BSD-3-Clause\n"
"\n"
"in vec2 texCoord;\n"
"\n"
"uniform mat3 invNormalMatrix;\n"
"uniform mat4 DCVCMatrix;\n"
"uniform mat4 VCDCMatrix;\n"
"uniform mat4 MCVCMatrix;\n"
"\n"
"uniform sampler2D fluidZTexture;\n"
"uniform sampler2D fluidThicknessTexture;\n"
"uniform sampler2D fluidNormalTexture;\n"
"uniform sampler2D fluidColorTexture;\n"
"\n"
"uniform sampler2D opaqueRGBATexture;\n"
"\n"
"//VTK::UseIBL::Dec\n"
"#ifdef UseIBL\n"
"uniform samplerCube prefilterTex;\n"
"#endif\n"
"\n"
"uniform int displayModeOpaqueSurface = 0;\n"
"uniform int displayModeSurfaceNormal = 0;\n"
"uniform int hasVertexColor           = 0;\n"
"uniform float vertexColorPower = 0.1f;\n"
"uniform float vertexColorScale = 1.0f;\n"
"\n"
"uniform float refractionScale      = 1.0f;\n"
"uniform float attenuationScale    = 1.0f;\n"
"uniform float additionalReflection = 0.1f;\n"
"uniform float refractiveIndex      = 1.33f;\n"
"\n"
"uniform vec3 fluidOpaqueColor       = vec3(0.4, 0.4, 0.95);\n"
"uniform vec3 fluidAttenuationColor;\n"
"\n"
"uniform float farZValue;\n"
"\n"
"// Texture maps\n"
"//VTK::TMap::Dec\n"
"\n"
"// the output of this shader\n"
"//VTK::Output::Dec\n"
"\n"
"\n"
"// Include lighting uniforms\n"
"//VTK::Light::Dec\n"
"\n"
"uniform float  ambientValue;\n"
"\n"
"// These are fluid material, can be changed by user\n"
"const vec3  fluidSpecularColor = vec3(1, 1, 1);\n"
"const float fluidShininess     = 150.0f;\n"
"\n"
"// This should not be changed\n"
"const float fresnelPower = 5.0f;\n"
"\n"
"vec3 uvToEye(float vcDepth)\n"
"{\n"
"  // need to convert depth back to DC, to use\n"
"  vec4 tmp = vec4(0.0, 0.0, vcDepth, 1.0);\n"
"  tmp = VCDCMatrix*tmp;\n"
"  tmp.x = texCoord.x * 2.0 - 1.0;\n"
"  tmp.y = texCoord.y * 2.0 - 1.0;\n"
"  tmp.z = tmp.z/tmp.w;\n"
"  tmp.w = 1.0;\n"
"  vec4 viewPos = DCVCMatrix * tmp;\n"
"  return viewPos.xyz / viewPos.w;\n"
"}\n"
"\n"
"vec3 computeAttenuation(float thickness)\n"
"{\n"
"  return vec3(exp(-fluidAttenuationColor.r * thickness),\n"
"              exp(-fluidAttenuationColor.g * thickness),\n"
"              exp(-fluidAttenuationColor.b * thickness));\n"
"}\n"
"\n"
"void main()\n"
"{\n"
"  float fdepth = texture(fluidZTexture, texCoord).r;\n"
"  if (fdepth <= farZValue || fdepth >= 0) { discard; }\n"
"\n"
"  gl_FragDepth = fdepth;\n"
"  vec3  N      = texture(fluidNormalTexture, texCoord).xyz;\n"
"  if(displayModeSurfaceNormal == 1)\n"
"  {\n"
"    gl_FragData[0] = vec4(N, 1);\n"
"    return;\n"
"  }\n"
"\n"
"  vec3  position = uvToEye(fdepth);\n"
"  vec3  viewer   = normalize(-position.xyz);\n"
"\n"
"  vec3 accumulatedLightDiffuseColor = vec3(0.0,0.0,0.0);\n"
"  vec3 accumulatedLightSpecularColor = vec3(0.0,0.0,0.0);\n"
"\n"
"  //VTK::Light::Impl\n"
"\n"
"  if(displayModeOpaqueSurface == 1)\n"
"  {\n"
"    if(hasVertexColor == 0)\n"
"    {\n"
"      gl_FragData[0] = vec4(ambientValue*fluidOpaqueColor\n"
"          + fluidOpaqueColor * accumulatedLightDiffuseColor\n"
"          + fluidSpecularColor * accumulatedLightSpecularColor, 1.0);\n"
"    }\n"
"    else\n"
"    {\n"
"      vec3 tmp = texture(fluidColorTexture, texCoord).xyz;\n"
"      tmp.r = 1.0 - pow(tmp.r, vertexColorPower) * vertexColorScale;\n"
"      tmp.g = 1.0 - pow(tmp.g, vertexColorPower) * vertexColorScale;\n"
"      tmp.b = 1.0 - pow(tmp.b, vertexColorPower) * vertexColorScale;\n"
"      gl_FragData[0] = vec4(ambientValue*tmp + tmp * accumulatedLightDiffuseColor + fluidSpecularColor * accumulatedLightSpecularColor, 1.0);\n"
"    }\n"
"    return;\n"
"  }\n"
"\n"
"#ifdef UseIBL\n"
"  vec3 worldReflect = normalize(invNormalMatrix*reflect(-viewer, N));\n"
"  vec3  reflectionColor = texture(prefilterTex, worldReflect).rgb;\n"
"#else\n"
"  vec3  reflectionColor = vec3(1.0,1.0,1.0);\n"
"#endif\n"
"\n"
"  float eta = 1.0 / refractiveIndex;          // Ratio of indices of refraction\n"
"  float F   = ((1.0 - eta) * (1.0 - eta)) / ((1.0 + eta) * (1.0 + eta));\n"
"\n"
"  //Fresnel Reflection\n"
"  float fresnelRatio  = clamp(F + (1.0 - F) * pow((1.0 - dot(viewer, N)), fresnelPower), 0, 1);\n"
"  vec3  reflectionDir = reflect(-viewer, N);\n"
"\n"
"  float fthick = texture(fluidThicknessTexture, texCoord).r * attenuationScale;\n"
"  vec3 volumeColor;\n"
"  if(hasVertexColor == 0)\n"
"  {\n"
"    //Color Attenuation from Thickness (Beer's Law)\n"
"    volumeColor = computeAttenuation(fthick);\n"
"  }\n"
"  else\n"
"  {\n"
"    vec3 tmp = texture(fluidColorTexture, texCoord).xyz;\n"
"    tmp.r = 1.0 - pow(tmp.r, vertexColorPower) * vertexColorScale;\n"
"    tmp.g = 1.0 - pow(tmp.g, vertexColorPower) * vertexColorScale;\n"
"    tmp.b = 1.0 - pow(tmp.b, vertexColorPower) * vertexColorScale;\n"
"\n"
"    volumeColor = vec3(exp(-tmp.r * fthick),\n"
"                        exp(-tmp.g * fthick),\n"
"                        exp(-tmp.b * fthick));\n"
"  }\n"
"\n"
"  vec3 refractionDir   = refract(-viewer, N, eta);\n"
"  vec3 refractionColor = volumeColor * texture(opaqueRGBATexture, texCoord + refractionDir.xy * refractionScale).xyz;\n"
"\n"
"  fresnelRatio = mix(fresnelRatio, 1.0, additionalReflection);\n"
"  vec3 finalColor = mix(refractionColor, reflectionColor, fresnelRatio) + fluidSpecularColor * accumulatedLightSpecularColor;\n"
"  gl_FragData[0] = vec4(finalColor, 1);\n"
"}\n"
"";
