// java wrapper for vtkNamedColors object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkNamedColors.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkNamedColors_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkNamedColors",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkNamedColors_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkNamedColors* op = static_cast<vtkNamedColors*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkNamedColors_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkNamedColors* op = static_cast<vtkNamedColors*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkNamedColors_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkNamedColors* op = static_cast<vtkNamedColors*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkNamedColors_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkNamedColors* op = static_cast<vtkNamedColors*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkNamedColors_GetNumberOfColors_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkNamedColors* op = static_cast<vtkNamedColors*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfColors();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkNamedColors_ResetColors_15(JNIEnv* env, jobject obj)
{

  vtkNamedColors* op = static_cast<vtkNamedColors*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetColors();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkNamedColors_ColorExists_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkStdString temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkNamedColors* op = static_cast<vtkNamedColors*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ColorExists(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkNamedColors_GetColor_17(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jdoubleArray id1)
{
  vtkStdString temp0;
  double temp1[4];
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

  vtkNamedColors* op = static_cast<vtkNamedColors*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetColor(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkNamedColors_GetColorRGB_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jdoubleArray id1)
{
  vtkStdString temp0;
  double temp1[3];
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkNamedColors* op = static_cast<vtkNamedColors*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetColorRGB(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkNamedColors_SetColor_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jdoubleArray id1)
{
  vtkStdString temp0;
  double temp1[4];
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

  vtkNamedColors* op = static_cast<vtkNamedColors*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColor(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkNamedColors_RemoveColor_110(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkStdString temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkNamedColors* op = static_cast<vtkNamedColors*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveColor(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkNamedColors_GetColorNames_111(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkNamedColors* op = static_cast<vtkNamedColors*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorNames();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkNamedColors_GetColorNames_112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkStringArray * temp0;
  temp0 = static_cast<vtkStringArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkNamedColors* op = static_cast<vtkNamedColors*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetColorNames(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkNamedColors_GetSynonyms_113(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkNamedColors* op = static_cast<vtkNamedColors*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSynonyms();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkNamedColors_SetColor_114(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1)
{
  vtkStdString temp0;
  vtkStdString temp1;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = vtkJavaUTF8ToString(env, id1, len1);

  vtkNamedColors* op = static_cast<vtkNamedColors*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColor(temp0,temp1);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkNamedColors_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkNamedColors::New());
}
