// java wrapper for vtkAbstractArray object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkAbstractArray.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkAbstractArray_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkAbstractArray",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractArray_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractArray_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractArray_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractArray_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractArray_Allocate_14(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Allocate(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractArray_Initialize_15(JNIEnv* env, jobject obj)
{

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractArray_GetDataType_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataType();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractArray_GetDataTypeSize_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeSize();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractArray_GetDataTypeSize_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeSize(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractArray_GetElementComponentSize_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementComponentSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractArray_SetNumberOfComponents_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfComponents(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractArray_GetNumberOfComponentsMinValue_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponentsMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractArray_GetNumberOfComponentsMaxValue_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponentsMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractArray_GetNumberOfComponents_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponents();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractArray_SetComponentName_114(JNIEnv* env, jobject obj,jlong id0, jbyteArray id1, jint len1)
{
  long long   temp0;
  char * temp1;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetComponentName(temp0,temp1);
  delete[] temp1;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkAbstractArray_GetComponentName_115(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const char * temp20;
  temp0 = id0;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComponentName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAbstractArray_HasAComponentName_116(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasAComponentName();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractArray_CopyComponentNames_117(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractArray * temp0;
  int   temp20;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CopyComponentNames(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractArray_SetNumberOfTuples_118(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfTuples(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAbstractArray_SetNumberOfValues_119(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetNumberOfValues(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractArray_GetNumberOfTuples_120(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfTuples();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractArray_GetNumberOfValues_121(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfValues();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractArray_SetTuple_122(JNIEnv* env, jobject obj,jlong id0,jlong id1,jobject id2)
{
  long long   temp0;
  long long   temp1;
  vtkAbstractArray * temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTuple(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractArray_InsertTuple_123(JNIEnv* env, jobject obj,jlong id0,jlong id1,jobject id2)
{
  long long   temp0;
  long long   temp1;
  vtkAbstractArray * temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertTuple(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractArray_InsertTuples_124(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkIdList * temp0;
  vtkIdList * temp1;
  vtkAbstractArray * temp2;
  temp0 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertTuples(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractArray_InsertTuplesStartingAt_125(JNIEnv* env, jobject obj,jlong id0,jobject id1,jobject id2)
{
  long long   temp0;
  vtkIdList * temp1;
  vtkAbstractArray * temp2;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertTuplesStartingAt(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractArray_InsertTuples_126(JNIEnv* env, jobject obj,jlong id0,jlong id1,jlong id2,jobject id3)
{
  long long   temp0;
  long long   temp1;
  long long   temp2;
  vtkAbstractArray * temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id3));

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertTuples(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractArray_InsertNextTuple_127(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkAbstractArray * temp1;
  long long   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextTuple(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractArray_GetTuples_128(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkIdList * temp0;
  vtkAbstractArray * temp1;
  temp0 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetTuples(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractArray_GetTuples_129(JNIEnv* env, jobject obj,jlong id0,jlong id1,jobject id2)
{
  long long   temp0;
  long long   temp1;
  vtkAbstractArray * temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetTuples(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAbstractArray_HasStandardMemoryLayout_130(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasStandardMemoryLayout();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractArray_DeepCopy_131(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractArray * temp0;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractArray_InterpolateTuple_132(JNIEnv* env, jobject obj,jlong id0,jlong id1,jobject id2,jlong id3,jobject id4,jdouble id5)
{
  long long   temp0;
  long long   temp1;
  vtkAbstractArray * temp2;
  long long   temp3;
  vtkAbstractArray * temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = id3;
  temp4 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = id5;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateTuple(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractArray_Squeeze_133(JNIEnv* env, jobject obj)
{

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->Squeeze();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractArray_Resize_134(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  int   temp20;
  temp0 = id0;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Resize(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractArray_Reset_135(JNIEnv* env, jobject obj)
{

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->Reset();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractArray_GetSize_136(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSize();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractArray_GetMaxId_137(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxId();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractArray_GetActualMemorySize_138(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractArray_SetName_139(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkAbstractArray_GetName_140(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkAbstractArray_GetDataTypeAsString_141(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractArray_CreateArray_142(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkAbstractArray * temp20;
  temp0 = id0;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CreateArray(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractArray_IsNumeric_143(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsNumeric();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAbstractArray_IsIntegral_144(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsIntegral();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractArray_NewIterator_145(JNIEnv* env, jobject obj)
{
  vtkArrayIterator * temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewIterator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractArray_GetDataSize_146(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractArray_DataChanged_147(JNIEnv* env, jobject obj)
{

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->DataChanged();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractArray_ClearLookup_148(JNIEnv* env, jobject obj)
{

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearLookup();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractArray_GetProminentComponentValues_149(JNIEnv* env, jobject obj,jint id0,jobject id1,jdouble id2,jdouble id3)
{
  int   temp0;
  vtkVariantArray * temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;
  temp3 = id3;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetProminentComponentValues(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractArray_GetInformation_150(JNIEnv* env, jobject obj)
{
  vtkInformation * temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInformation();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAbstractArray_HasInformation_151(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasInformation();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractArray_CopyInformation_152(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformation * temp0;
  int   temp1;
  int   temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CopyInformation(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractArray_GUI_1HIDE_153(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GUI_HIDE();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractArray_PER_1COMPONENT_154(JNIEnv* env, jobject obj)
{
  vtkInformationInformationVectorKey * temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PER_COMPONENT();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractArray_PER_1FINITE_1COMPONENT_155(JNIEnv* env, jobject obj)
{
  vtkInformationInformationVectorKey * temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PER_FINITE_COMPONENT();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractArray_Modified_156(JNIEnv* env, jobject obj)
{

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->Modified();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractArray_DISCRETE_1VALUES_157(JNIEnv* env, jobject obj)
{
  vtkInformationVariantVectorKey * temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DISCRETE_VALUES();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractArray_DISCRETE_1VALUE_1SAMPLE_1PARAMETERS_158(JNIEnv* env, jobject obj)
{
  vtkInformationDoubleVectorKey * temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DISCRETE_VALUE_SAMPLE_PARAMETERS();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractArray_GetMaxDiscreteValues_159(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxDiscreteValues();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractArray_SetMaxDiscreteValues_160(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaxDiscreteValues(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractArray_GetArrayType_161(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayType();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkAbstractArray_GetArrayTypeAsString_162(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkAbstractArray* op = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayTypeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}
