// java wrapper for vtkArrayData object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkArrayData.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkArrayData_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkArrayData",dType)) { return me; }
  if ((res= vtkDataObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayData_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayData* op = static_cast<vtkArrayData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayData_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayData* op = static_cast<vtkArrayData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArrayData_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayData* op = static_cast<vtkArrayData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArrayData_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayData* op = static_cast<vtkArrayData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArrayData_GetData_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkArrayData * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkArrayData* op = static_cast<vtkArrayData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArrayData_GetData_15(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkArrayData * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkArrayData* op = static_cast<vtkArrayData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayData_AddArray_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkArray * temp0;
  temp0 = static_cast<vtkArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkArrayData* op = static_cast<vtkArrayData*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddArray(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayData_ClearArrays_17(JNIEnv* env, jobject obj)
{

  vtkArrayData* op = static_cast<vtkArrayData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearArrays();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArrayData_GetNumberOfArrays_18(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkArrayData* op = static_cast<vtkArrayData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfArrays();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArrayData_GetArray_19(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  vtkArray * temp20;
  temp0 = id0;

  vtkArrayData* op = static_cast<vtkArrayData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArray(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArrayData_GetArrayByName_110(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkArray * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayData* op = static_cast<vtkArrayData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayByName(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayData_GetDataObjectType_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkArrayData* op = static_cast<vtkArrayData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayData_ShallowCopy_112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkArrayData* op = static_cast<vtkArrayData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayData_DeepCopy_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkArrayData* op = static_cast<vtkArrayData*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkArrayData_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkArrayData::New());
}
