// java wrapper for vtkCell object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCell.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCell_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCell",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCell_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCell_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCell_Initialize_14(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkPoints * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCell_ShallowCopy_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCell * temp0;
  temp0 = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCell_DeepCopy_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCell * temp0;
  temp0 = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell_GetCellType_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell_GetCellDimension_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellDimension();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell_IsLinear_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsLinear();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell_RequiresInitialization_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RequiresInitialization();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCell_Initialize_111(JNIEnv* env, jobject obj)
{

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell_IsExplicitCell_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsExplicitCell();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell_RequiresExplicitFaceRepresentation_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RequiresExplicitFaceRepresentation();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCell_GetPoints_114(JNIEnv* env, jobject obj)
{
  vtkPoints * temp20;

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoints();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCell_GetNumberOfPoints_115(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPoints();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell_GetNumberOfEdges_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdges();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell_GetNumberOfFaces_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFaces();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCell_GetPointIds_118(JNIEnv* env, jobject obj)
{
  vtkIdList * temp20;

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointIds();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCell_GetPointId_119(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  long long   temp20;
  temp0 = id0;

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointId(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCell_GetEdge_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdge(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCell_GetFace_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFace(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell_CellBoundary_122(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jobject id2)
{
  int   temp0;
  double temp1[3];
  vtkIdList * temp2;
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CellBoundary(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCell_Contour_123(JNIEnv* env, jobject obj,jdouble id0,jobject id1,jobject id2,jobject id3,jobject id4,jobject id5,jobject id6,jobject id7,jobject id8,jlong id9,jobject id10)
{
  double   temp0;
  vtkDataArray * temp1;
  vtkIncrementalPointLocator * temp2;
  vtkCellArray * temp3;
  vtkCellArray * temp4;
  vtkCellArray * temp5;
  vtkPointData * temp6;
  vtkPointData * temp7;
  vtkCellData * temp8;
  long long   temp9;
  vtkCellData * temp10;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id6));
  temp7 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id7));
  temp8 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id8));
  temp9 = id9;
  temp10 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id10));

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->Contour(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9,temp10);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCell_Clip_124(JNIEnv* env, jobject obj,jdouble id0,jobject id1,jobject id2,jobject id3,jobject id4,jobject id5,jobject id6,jlong id7,jobject id8,jint id9)
{
  double   temp0;
  vtkDataArray * temp1;
  vtkIncrementalPointLocator * temp2;
  vtkCellArray * temp3;
  vtkPointData * temp4;
  vtkPointData * temp5;
  vtkCellData * temp6;
  long long   temp7;
  vtkCellData * temp8;
  int   temp9;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id6));
  temp7 = id7;
  temp8 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id8));
  temp9 = id9;

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->Clip(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell_Inflate_125(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  int   temp20;
  temp0 = id0;

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Inflate(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCell_ComputeBoundingSphere_126(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeBoundingSphere(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell_IntersectWithCell_127(JNIEnv* env, jobject obj,jobject id0,jdouble id1)
{
  vtkCell * temp0;
  double   temp1;
  int   temp20;
  temp0 = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IntersectWithCell(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell_Triangulate_128(JNIEnv* env, jobject obj,jint id0,jobject id1,jobject id2)
{
  int   temp0;
  vtkIdList * temp1;
  vtkPoints * temp2;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id2));

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Triangulate(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell_TriangulateIds_129(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkIdList * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TriangulateIds(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell_TriangulateLocalIds_130(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkIdList * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TriangulateLocalIds(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCell_GetBounds_131(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCell_GetBounds_132(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCell_GetLength2_133(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLength2();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell_GetParametricCenter_134(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParametricCenter(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCell_GetParametricDistance_135(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParametricDistance(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCell_IsPrimaryCell_136(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCell* op = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsPrimaryCell();
  return temp20;

}
