// java wrapper for vtkImageData object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageData.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataSet_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageData_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageData",dType)) { return me; }
  if ((res= vtkDataSet_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_ExtendedNew_10(JNIEnv* env, jobject obj)
{
  vtkImageData * temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ExtendedNew();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageData_IsTypeOf_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageData_IsA_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_GetNumberOfGenerationsFromBaseType_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_GetNumberOfGenerationsFromBase_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_CopyStructure_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyStructure(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_Initialize_16(JNIEnv* env, jobject obj)
{

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageData_GetDataObjectType_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_GetNumberOfCells_18(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_GetNumberOfPoints_19(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPoints();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_GetPoints_110(JNIEnv* env, jobject obj)
{
  vtkPoints * temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoints();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageData_GetPoint_111(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  double * temp20;
  temp0 = id0;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_GetPoint_112(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_GetCell_113(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_GetCell_114(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  vtkCell * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0,temp1,temp2);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_GetCell_115(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkGenericCell * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, id1));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCell(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_GetCellBounds_116(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[6];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellBounds(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_FindPoint_117(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindPoint(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageData_GetCellType_118(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  int   temp20;
  temp0 = id0;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_GetCellSize_119(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellSize(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_GetCellPoints_120(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellPoints(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_GetPointCells_121(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPointCells(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_ComputeBounds_122(JNIEnv* env, jobject obj)
{

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeBounds();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageData_GetMaxCellSize_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxCellSize();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageData_GetMaxSpatialDimension_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxSpatialDimension();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageData_GetMinSpatialDimension_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinSpatialDimension();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_GetCellNeighbors_126(JNIEnv* env, jobject obj,jlong id0,jobject id1,jobject id2)
{
  long long   temp0;
  vtkIdList * temp1;
  vtkIdList * temp2;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellNeighbors(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_GetCells_127(JNIEnv* env, jobject obj)
{
  vtkStructuredCellArray * temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCells();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_BlankPoint_128(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->BlankPoint(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_UnBlankPoint_129(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnBlankPoint(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_BlankPoint_130(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->BlankPoint(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_UnBlankPoint_131(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnBlankPoint(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_BlankCell_132(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->BlankCell(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_UnBlankCell_133(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnBlankCell(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_BlankCell_134(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->BlankCell(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_UnBlankCell_135(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnBlankCell(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jbyte  JNICALL Java_vtk_vtkImageData_IsPointVisible_136(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
   unsigned char   temp20;
  temp0 = id0;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsPointVisible(temp0);
  return temp20;

}

extern "C" JNIEXPORT jbyte  JNICALL Java_vtk_vtkImageData_IsCellVisible_137(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
   unsigned char   temp20;
  temp0 = id0;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsCellVisible(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkImageData_HasAnyBlankPoints_138(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasAnyBlankPoints();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkImageData_HasAnyBlankCells_139(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasAnyBlankCells();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageData_GetDataDescription_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataDescription();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_GetCellDims_141(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellDims(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_SetDimensions_142(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensions(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_SetDimensions_143(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensions(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageData_GetDimensions_144(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDimensions();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_GetDimensions_145(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetDimensions(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_GetDimensions_146(JNIEnv* env, jobject obj,jlongArray id0)
{
  long long temp0[3];
  env->GetLongArrayRegion(id0, 0, 3, reinterpret_cast<jlong*>(&temp0[0]));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetDimensions(temp0);
  env->SetLongArrayRegion(id0, 0, 3, reinterpret_cast<jlong*>(&temp0[0]));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageData_ComputeStructuredCoordinates_147(JNIEnv* env, jobject obj,jdoubleArray id0,jintArray id1,jdoubleArray id2)
{
  double temp0[3];
  int temp1[3];
  double temp2[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeStructuredCoordinates(temp0,temp1,temp2);
  env->SetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageData_ComputeStructuredCoordinates_148(JNIEnv* env, jobject obj,jdoubleArray id0,jintArray id1,jdoubleArray id2,jdouble id3)
{
  double temp0[3];
  int temp1[3];
  double temp2[3];
  double   temp3;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  temp3 = id3;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeStructuredCoordinates(temp0,temp1,temp2,temp3);
  env->SetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_GetVoxelGradient_149(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jobject id3,jobject id4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  vtkDataArray * temp3;
  vtkDataArray * temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id4));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetVoxelGradient(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_GetPointGradient_150(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jobject id3,jdoubleArray id4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  vtkDataArray * temp3;
  double temp4[3];
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id3));
  env->GetDoubleArrayRegion(id4, 0, 3, &temp4[0]);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPointGradient(temp0,temp1,temp2,temp3,temp4);
  env->SetDoubleArrayRegion(id4, 0, 3, &temp4[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageData_GetDataDimension_151(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataDimension();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_ComputePointId_152(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  long long   temp20;
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputePointId(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_ComputeCellId_153(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  long long   temp20;
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeCellId(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_SetExtent_154(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExtent(temp0);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_SetExtent_155(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExtent(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageData_GetExtent_156(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageData_GetScalarTypeMin_157(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  double   temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarTypeMin(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageData_GetScalarTypeMin_158(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarTypeMin();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageData_GetScalarTypeMax_159(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  double   temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarTypeMax(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageData_GetScalarTypeMax_160(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarTypeMax();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageData_GetScalarSize_161(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarSize(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageData_GetScalarSize_162(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarSize();
  return temp20;

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkImageData_GetIncrements_163(JNIEnv* env, jobject obj)
{
  long long * temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIncrements();
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<jlong*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_GetIncrements_164(JNIEnv* env, jobject obj,jlongArray id0)
{
  long long temp0[3];
  env->GetLongArrayRegion(id0, 0, 3, reinterpret_cast<jlong*>(&temp0[0]));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetIncrements(temp0);
  env->SetLongArrayRegion(id0, 0, 3, reinterpret_cast<jlong*>(&temp0[0]));

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkImageData_GetIncrements_165(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  long long * temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIncrements(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<jlong*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_GetIncrements_166(JNIEnv* env, jobject obj,jobject id0,jlongArray id1)
{
  vtkDataArray * temp0;
  long long temp1[3];
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetLongArrayRegion(id1, 0, 3, reinterpret_cast<jlong*>(&temp1[0]));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetIncrements(temp0,temp1);
  env->SetLongArrayRegion(id1, 0, 3, reinterpret_cast<jlong*>(&temp1[0]));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_GetScalarIndexForExtent_167(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  long long   temp20;
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarIndexForExtent(temp0);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_GetScalarIndex_168(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  long long   temp20;
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarIndex(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_GetScalarIndex_169(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarIndex(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkImageData_GetScalarComponentAsFloat_170(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  float   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarComponentAsFloat(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_SetScalarComponentFromFloat_171(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jfloat id4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  float   temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarComponentFromFloat(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageData_GetScalarComponentAsDouble_172(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  double   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarComponentAsDouble(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_SetScalarComponentFromDouble_173(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jdouble id4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  double   temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarComponentFromDouble(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_AllocateScalars_174(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->AllocateScalars(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_AllocateScalars_175(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->AllocateScalars(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_CopyAndCastFrom_176(JNIEnv* env, jobject obj,jobject id0,jintArray id1)
{
  vtkImageData * temp0;
  int temp1[6];
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyAndCastFrom(temp0,temp1);
  env->SetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_CopyAndCastFrom_177(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2,jint id3,jint id4,jint id5,jint id6)
{
  vtkImageData * temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  int   temp6;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyAndCastFrom(temp0,temp1,temp2,temp3,temp4,temp5,temp6);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_GetActualMemorySize_178(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageData_GetSpacing_179(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSpacing();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_SetSpacing_180(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSpacing(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_SetSpacing_181(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSpacing(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageData_GetOrigin_182(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_SetOrigin_183(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_SetOrigin_184(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrigin(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_GetDirectionMatrix_185(JNIEnv* env, jobject obj)
{
  vtkMatrix3x3 * temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDirectionMatrix();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_SetDirectionMatrix_186(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix3x3 * temp0;
  temp0 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDirectionMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_SetDirectionMatrix_187(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[9];
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDirectionMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_SetDirectionMatrix_188(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5,jdouble id6,jdouble id7,jdouble id8)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  double   temp6;
  double   temp7;
  double   temp8;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;
  temp8 = id8;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDirectionMatrix(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_GetIndexToPhysicalMatrix_189(JNIEnv* env, jobject obj)
{
  vtkMatrix4x4 * temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIndexToPhysicalMatrix();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_ApplyIndexToPhysicalMatrix_190(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyIndexToPhysicalMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_TransformContinuousIndexToPhysicalPoint_191(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdoubleArray id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double temp3[3];
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformContinuousIndexToPhysicalPoint(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_TransformContinuousIndexToPhysicalPoint_192(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformContinuousIndexToPhysicalPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_TransformIndexToPhysicalPoint_193(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jdoubleArray id3)
{
  int   temp0;
  int   temp1;
  int   temp2;
  double temp3[3];
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformIndexToPhysicalPoint(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_TransformIndexToPhysicalPoint_194(JNIEnv* env, jobject obj,jintArray id0,jdoubleArray id1)
{
  int temp0[3];
  double temp1[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformIndexToPhysicalPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_TransformContinuousIndexToPhysicalPoint_195(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdoubleArray id3,jdoubleArray id4,jdoubleArray id5,jdoubleArray id6)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double temp3[3];
  double temp4[3];
  double temp5[9];
  double temp6[3];
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->GetDoubleArrayRegion(id4, 0, 3, &temp4[0]);
  env->GetDoubleArrayRegion(id5, 0, 9, &temp5[0]);
  env->GetDoubleArrayRegion(id6, 0, 3, &temp6[0]);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformContinuousIndexToPhysicalPoint(temp0,temp1,temp2,temp3,temp4,temp5,temp6);
  env->SetDoubleArrayRegion(id6, 0, 3, &temp6[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_GetPhysicalToIndexMatrix_196(JNIEnv* env, jobject obj)
{
  vtkMatrix4x4 * temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPhysicalToIndexMatrix();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_ApplyPhysicalToIndexMatrix_197(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyPhysicalToIndexMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_TransformPhysicalPointToContinuousIndex_198(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdoubleArray id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double temp3[3];
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformPhysicalPointToContinuousIndex(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_TransformPhysicalPointToContinuousIndex_199(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformPhysicalPointToContinuousIndex(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_TransformPhysicalNormalToContinuousIndex_1100(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformPhysicalNormalToContinuousIndex(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_TransformPhysicalPlaneToContinuousIndex_1101(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[4];
  double temp1[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformPhysicalPlaneToContinuousIndex(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_ComputeIndexToPhysicalMatrix_1102(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3)
{
  double temp0[3];
  double temp1[3];
  double temp2[9];
  double temp3[16];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 9, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 16, &temp3[0]);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeIndexToPhysicalMatrix(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id3, 0, 16, &temp3[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_ComputePhysicalToIndexMatrix_1103(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3)
{
  double temp0[3];
  double temp1[3];
  double temp2[9];
  double temp3[16];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 9, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 16, &temp3[0]);

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputePhysicalToIndexMatrix(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id3, 0, 16, &temp3[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_SetScalarType_1104(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkInformation * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id1));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarType(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageData_GetScalarType_1105(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarType(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkImageData_HasScalarType_1106(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  bool   temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasScalarType(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageData_GetScalarType_1107(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarType();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageData_GetScalarTypeAsString_1108(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarTypeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_SetNumberOfScalarComponents_1109(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkInformation * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id1));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfScalarComponents(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageData_GetNumberOfScalarComponents_1110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfScalarComponents(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkImageData_HasNumberOfScalarComponents_1111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  bool   temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasNumberOfScalarComponents(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageData_GetNumberOfScalarComponents_1112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfScalarComponents();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_CopyInformationFromPipeline_1113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyInformationFromPipeline(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_CopyInformationToPipeline_1114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyInformationToPipeline(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_PrepareForNewData_1115(JNIEnv* env, jobject obj)
{

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->PrepareForNewData();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_ShallowCopy_1116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_DeepCopy_1117(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_GetTupleIndex_1118(JNIEnv* env, jobject obj,jobject id0,jintArray id1)
{
  vtkDataArray * temp0;
  int temp1[3];
  long long   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTupleIndex(temp0,temp1);
  env->SetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageData_GetArrayIncrements_1119(JNIEnv* env, jobject obj,jobject id0,jlongArray id1)
{
  vtkDataArray * temp0;
  long long temp1[3];
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetLongArrayRegion(id1, 0, 3, reinterpret_cast<jlong*>(&temp1[0]));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetArrayIncrements(temp0,temp1);
  env->SetLongArrayRegion(id1, 0, 3, reinterpret_cast<jlong*>(&temp1[0]));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageData_GetExtentType_1120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExtentType();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_GetData_1121(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkImageData * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_GetData_1122(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkImageData * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageData_FindPoint_1123(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageData* op = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindPoint(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageData_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageData::New());
}
