// java wrapper for vtkOctreePointLocator object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkOctreePointLocator.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAbstractPointLocator_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkOctreePointLocator_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkOctreePointLocator",dType)) { return me; }
  if ((res= vtkAbstractPointLocator_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOctreePointLocator_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOctreePointLocator_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOctreePointLocator_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOctreePointLocator_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOctreePointLocator_SetMaximumPointsPerRegion_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumPointsPerRegion(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOctreePointLocator_GetMaximumPointsPerRegion_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumPointsPerRegion();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOctreePointLocator_SetCreateCubicOctants_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCreateCubicOctants(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOctreePointLocator_GetCreateCubicOctants_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCreateCubicOctants();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkOctreePointLocator_GetFudgeFactor_18(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFudgeFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOctreePointLocator_SetFudgeFactor_19(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFudgeFactor(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOctreePointLocator_GetNumberOfLeafNodes_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLeafNodes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOctreePointLocator_GetRegionBounds_111(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[6];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetRegionBounds(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOctreePointLocator_GetRegionDataBounds_112(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[6];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetRegionDataBounds(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOctreePointLocator_GetRegionContainingPoint_113(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRegionContainingPoint(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOctreePointLocator_BuildLocator_114(JNIEnv* env, jobject obj)
{

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildLocator();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOctreePointLocator_ForceBuildLocator_115(JNIEnv* env, jobject obj)
{

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceBuildLocator();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOctreePointLocator_FindClosestPoint_116(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindClosestPoint(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOctreePointLocator_FindPointsWithinRadius_117(JNIEnv* env, jobject obj,jdouble id0,jdoubleArray id1,jobject id2)
{
  double   temp0;
  double temp1[3];
  vtkIdList * temp2;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FindPointsWithinRadius(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOctreePointLocator_FindClosestNPoints_118(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jobject id2)
{
  int   temp0;
  double temp1[3];
  vtkIdList * temp2;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FindClosestNPoints(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOctreePointLocator_GetPointsInRegion_119(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkIdTypeArray * temp20;
  temp0 = id0;

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointsInRegion(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOctreePointLocator_FreeSearchStructure_120(JNIEnv* env, jobject obj)
{

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FreeSearchStructure();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOctreePointLocator_GenerateRepresentation_121(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkPolyData * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id1));

  vtkOctreePointLocator* op = static_cast<vtkOctreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateRepresentation(temp0,temp1);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkOctreePointLocator_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkOctreePointLocator::New());
}
