// java wrapper for vtkPath object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPath.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPointSet_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPath_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPath",dType)) { return me; }
  if ((res= vtkPointSet_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPath_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPath_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPath_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPath_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPath_GetDataObjectType_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPath_InsertNextPoint_15(JNIEnv* env, jobject obj,jfloatArray id0,jint id1)
{
  float temp0[3];
  int   temp1;
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = id1;

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertNextPoint(temp0,temp1);
  env->SetFloatArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPath_InsertNextPoint_16(JNIEnv* env, jobject obj,jdoubleArray id0,jint id1)
{
  double temp0[3];
  int   temp1;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = id1;

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertNextPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPath_InsertNextPoint_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jint id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  int   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertNextPoint(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPath_SetCodes_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkIntArray * temp0;
  temp0 = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCodes(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPath_GetCodes_19(JNIEnv* env, jobject obj)
{
  vtkIntArray * temp20;

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCodes();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPath_GetNumberOfCells_110(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPath_GetCell_111(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPath_GetCell_112(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkGenericCell * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCell(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPath_GetCellType_113(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  int   temp20;
  temp0 = id0;

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPath_GetCellPoints_114(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellPoints(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPath_GetPointCells_115(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPointCells(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPath_GetMaxCellSize_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxCellSize();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPath_GetMaxSpatialDimension_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxSpatialDimension();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPath_GetMinSpatialDimension_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinSpatialDimension();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPath_Allocate_119(JNIEnv* env, jobject obj,jlong id0,jint id1)
{
  long long   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  op->Allocate(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPath_Reset_120(JNIEnv* env, jobject obj)
{

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  op->Reset();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPath_GetData_121(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkPath * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPath_GetData_122(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkPath * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPath_GetCell_123(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  vtkCell * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPath* op = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0,temp1,temp2);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPath_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPath::New());
}
