// java wrapper for vtkMatrix3x3 object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkMatrix3x3.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkMatrix3x3_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkMatrix3x3",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMatrix3x3_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMatrix3x3_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMatrix3x3_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMatrix3x3_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_DeepCopy_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix3x3 * temp0;
  temp0 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_DeepCopy_15(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1)
{
  double temp0[9];
  vtkMatrix3x3 * temp1;
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);
  temp1 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id1));

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 9, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_DeepCopy_16(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[9];
  double temp1[9];
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 9, &temp1[0]);

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 9, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_DeepCopy_17(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[9];
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_Zero_18(JNIEnv* env, jobject obj)
{

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->Zero();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_Zero_19(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[9];
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->Zero(temp0);
  env->SetDoubleArrayRegion(id0, 0, 9, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_Identity_110(JNIEnv* env, jobject obj)
{

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->Identity();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_Identity_111(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[9];
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->Identity(temp0);
  env->SetDoubleArrayRegion(id0, 0, 9, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_Invert_112(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkMatrix3x3 * temp0;
  vtkMatrix3x3 * temp1;
  temp0 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id1));

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->Invert(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_Invert_113(JNIEnv* env, jobject obj)
{

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->Invert();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_Invert_114(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[9];
  double temp1[9];
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 9, &temp1[0]);

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->Invert(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 9, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_Transpose_115(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkMatrix3x3 * temp0;
  vtkMatrix3x3 * temp1;
  temp0 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id1));

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->Transpose(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_Transpose_116(JNIEnv* env, jobject obj)
{

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->Transpose();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_Transpose_117(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[9];
  double temp1[9];
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 9, &temp1[0]);

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->Transpose(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 9, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_MultiplyPoint_118(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[3];
  float temp1[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->MultiplyPoint(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_MultiplyPoint_119(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->MultiplyPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_MultiplyPoint_120(JNIEnv* env, jobject obj,jdoubleArray id0,jfloatArray id1,jfloatArray id2)
{
  double temp0[9];
  float temp1[3];
  float temp2[3];
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetFloatArrayRegion(id2, 0, 3, &temp2[0]);

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->MultiplyPoint(temp0,temp1,temp2);
  env->SetFloatArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_MultiplyPoint_121(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[9];
  double temp1[3];
  double temp2[3];
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->MultiplyPoint(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_Multiply3x3_122(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkMatrix3x3 * temp0;
  vtkMatrix3x3 * temp1;
  vtkMatrix3x3 * temp2;
  temp0 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id2));

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->Multiply3x3(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_Multiply3x3_123(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[9];
  double temp1[9];
  double temp2[9];
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 9, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 9, &temp2[0]);

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->Multiply3x3(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id2, 0, 9, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_Adjoint_124(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkMatrix3x3 * temp0;
  vtkMatrix3x3 * temp1;
  temp0 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id1));

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->Adjoint(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_Adjoint_125(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[9];
  double temp1[9];
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 9, &temp1[0]);

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->Adjoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 9, &temp1[0]);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMatrix3x3_Determinant_126(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Determinant();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMatrix3x3_Determinant_127(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[9];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Determinant(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_SetElement_128(JNIEnv* env, jobject obj,jint id0,jint id1,jdouble id2)
{
  int   temp0;
  int   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetElement(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMatrix3x3_GetElement_129(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  double   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElement(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMatrix3x3_IsIdentity_130(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsIdentity();
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkMatrix3x3_GetData_131(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 9);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix3x3_SetData_132(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[9];
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);

  vtkMatrix3x3* op = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetData(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkMatrix3x3_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkMatrix3x3::New());
}
