// java wrapper for vtkDirectory object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDirectory.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDirectory_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDirectory",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDirectory_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDirectory* op = static_cast<vtkDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDirectory_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDirectory* op = static_cast<vtkDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDirectory_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDirectory* op = static_cast<vtkDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDirectory_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDirectory* op = static_cast<vtkDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDirectory_Open_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDirectory* op = static_cast<vtkDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Open(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDirectory_GetNumberOfFiles_15(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkDirectory* op = static_cast<vtkDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFiles();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDirectory_GetFile_16(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const char * temp20;
  temp0 = id0;

  vtkDirectory* op = static_cast<vtkDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFile(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDirectory_FileIsDirectory_17(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDirectory* op = static_cast<vtkDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FileIsDirectory(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDirectory_GetFiles_18(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkDirectory* op = static_cast<vtkDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFiles();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDirectory_GetCurrentWorkingDirectory_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
   unsigned int   temp1;
  const char * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkDirectory* op = static_cast<vtkDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCurrentWorkingDirectory(temp0,temp1);
  delete[] temp0;
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDirectory_MakeDirectory_110(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDirectory* op = static_cast<vtkDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MakeDirectory(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDirectory_DeleteDirectory_111(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDirectory* op = static_cast<vtkDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DeleteDirectory(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDirectory_Rename_112(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1)
{
  char * temp0;
  char * temp1;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkDirectory* op = static_cast<vtkDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Rename(temp0,temp1);
  delete[] temp0;
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkDirectory_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkDirectory::New());
}
