// java wrapper for vtkSelector object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkSelector.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkSelector_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkSelector",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelector_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelector* op = static_cast<vtkSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelector_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelector* op = static_cast<vtkSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelector_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelector* op = static_cast<vtkSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelector_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelector* op = static_cast<vtkSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelector_Initialize_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkSelectionNode * temp0;
  temp0 = static_cast<vtkSelectionNode*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSelector* op = static_cast<vtkSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelector_Finalize_15(JNIEnv* env, jobject obj)
{

  vtkSelector* op = static_cast<vtkSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->Finalize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelector_Execute_16(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkDataObject * temp0;
  vtkDataObject * temp1;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));

  vtkSelector* op = static_cast<vtkSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->Execute(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelector_SetInsidednessArrayName_17(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string   temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkSelector* op = static_cast<vtkSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInsidednessArrayName(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSelector_GetInsidednessArrayName_18(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkSelector* op = static_cast<vtkSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInsidednessArrayName();
  return vtkJavaStringToUTF8(env, temp20);

}
