// java wrapper for vtkButtonSource object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkButtonSource.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkButtonSource_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkButtonSource",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkButtonSource_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkButtonSource_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkButtonSource_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkButtonSource_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkButtonSource_SetCenter_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCenter(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkButtonSource_SetCenter_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCenter(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkButtonSource_GetCenter_16(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCenter();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkButtonSource_SetTextureStyle_17(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextureStyle(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkButtonSource_GetTextureStyleMinValue_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextureStyleMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkButtonSource_GetTextureStyleMaxValue_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextureStyleMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkButtonSource_GetTextureStyle_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextureStyle();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkButtonSource_SetTextureStyleToFitImage_111(JNIEnv* env, jobject obj)
{

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextureStyleToFitImage();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkButtonSource_SetTextureStyleToProportional_112(JNIEnv* env, jobject obj)
{

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextureStyleToProportional();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkButtonSource_SetTextureDimensions_113(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextureDimensions(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkButtonSource_SetTextureDimensions_114(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextureDimensions(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkButtonSource_GetTextureDimensions_115(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextureDimensions();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkButtonSource_SetShoulderTextureCoordinate_116(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShoulderTextureCoordinate(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkButtonSource_SetShoulderTextureCoordinate_117(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShoulderTextureCoordinate(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkButtonSource_GetShoulderTextureCoordinate_118(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShoulderTextureCoordinate();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkButtonSource_SetTwoSided_119(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTwoSided(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkButtonSource_GetTwoSided_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTwoSided();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkButtonSource_TwoSidedOn_121(JNIEnv* env, jobject obj)
{

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->TwoSidedOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkButtonSource_TwoSidedOff_122(JNIEnv* env, jobject obj)
{

  vtkButtonSource* op = static_cast<vtkButtonSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->TwoSidedOff();

}
