// java wrapper for vtkGLTFReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGLTFReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkMultiBlockDataSetAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGLTFReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGLTFReader",dType)) { return me; }
  if ((res= vtkMultiBlockDataSetAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGLTFReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGLTFReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGLTFReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGLTFReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGLTFReader_GetNumberOfTextures_14(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfTextures();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFReader_SetFileName_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGLTFReader_GetFileName_16(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFReader_SetStream_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkResourceStream * temp0;
  temp0 = static_cast<vtkResourceStream*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStream(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGLTFReader_GetStream_18(JNIEnv* env, jobject obj)
{
  vtkResourceStream * temp20;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStream();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFReader_SetGLBStart_19(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGLBStart(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGLTFReader_GetGLBStart_110(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGLBStart();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFReader_SetURILoader_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkURILoader * temp0;
  temp0 = static_cast<vtkURILoader*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetURILoader(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGLTFReader_GetURILoader_112(JNIEnv* env, jobject obj)
{
  vtkURILoader * temp20;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetURILoader();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFReader_SetApplyDeformationsToGeometry_113(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetApplyDeformationsToGeometry(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGLTFReader_GetApplyDeformationsToGeometry_114(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetApplyDeformationsToGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFReader_ApplyDeformationsToGeometryOn_115(JNIEnv* env, jobject obj)
{

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyDeformationsToGeometryOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFReader_ApplyDeformationsToGeometryOff_116(JNIEnv* env, jobject obj)
{

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyDeformationsToGeometryOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGLTFReader_GetNumberOfAnimations_117(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfAnimations();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGLTFReader_GetAnimationName_118(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  std::string   temp20;
  temp0 = id0;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnimationName(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkGLTFReader_GetAnimationDuration_119(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  float   temp20;
  temp0 = id0;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnimationDuration(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFReader_EnableAnimation_120(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAnimation(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFReader_DisableAnimation_121(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableAnimation(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGLTFReader_IsAnimationEnabled_122(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsAnimationEnabled(temp0);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGLTFReader_GetSceneName_123(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  std::string   temp20;
  temp0 = id0;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSceneName(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGLTFReader_GetNumberOfScenes_124(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfScenes();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGLTFReader_GetCurrentScene_125(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCurrentScene();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFReader_SetCurrentScene_126(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCurrentScene(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFReader_SetScene_127(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScene(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGLTFReader_GetFrameRate_128(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrameRate();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFReader_SetFrameRate_129(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFrameRate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFReader_SetOutputPointsPrecision_130(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputPointsPrecision(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGLTFReader_GetOutputPointsPrecision_131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputPointsPrecision();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGLTFReader_GetAllSceneNames_132(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAllSceneNames();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGLTFReader_GetAnimationSelection_133(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkGLTFReader* op = static_cast<vtkGLTFReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnimationSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkGLTFReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkGLTFReader::New());
}
