// java wrapper for vtkSEPReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkSEPReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkSEPReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkSEPReader",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSEPReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSEPReader* op = static_cast<vtkSEPReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSEPReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSEPReader* op = static_cast<vtkSEPReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSEPReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSEPReader* op = static_cast<vtkSEPReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSEPReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSEPReader* op = static_cast<vtkSEPReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSEPReader_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSEPReader* op = static_cast<vtkSEPReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSEPReader_GetFileName_15(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkSEPReader* op = static_cast<vtkSEPReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSEPReader_GetOutputGridDimension_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSEPReader* op = static_cast<vtkSEPReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputGridDimension();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSEPReader_SetOutputGridDimension_17(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSEPReader* op = static_cast<vtkSEPReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputGridDimension(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSEPReader_SetExtentSplitMode_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSEPReader* op = static_cast<vtkSEPReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExtentSplitMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSEPReader_GetExtentSplitMode_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSEPReader* op = static_cast<vtkSEPReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExtentSplitMode();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSEPReader_GetAllDimensions_110(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkSEPReader* op = static_cast<vtkSEPReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAllDimensions();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSEPReader_GetAllRanges_111(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkSEPReader* op = static_cast<vtkSEPReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAllRanges();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSEPReader_SetXDimension_112(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSEPReader* op = static_cast<vtkSEPReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXDimension(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSEPReader_SetYDimension_113(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSEPReader* op = static_cast<vtkSEPReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYDimension(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSEPReader_SetZDimension_114(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSEPReader* op = static_cast<vtkSEPReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZDimension(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSEPReader_SetFixedDimension1_115(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSEPReader* op = static_cast<vtkSEPReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFixedDimension1(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSEPReader_SetFixedDimension2_116(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSEPReader* op = static_cast<vtkSEPReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFixedDimension2(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSEPReader_SetFixedDimensionValue1_117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSEPReader* op = static_cast<vtkSEPReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFixedDimensionValue1(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSEPReader_SetFixedDimensionValue2_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSEPReader* op = static_cast<vtkSEPReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFixedDimensionValue2(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkSEPReader_GetFixedDimRange_119(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkSEPReader* op = static_cast<vtkSEPReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFixedDimRange();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSEPReader_CanReadFile_120(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSEPReader* op = static_cast<vtkSEPReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanReadFile(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkSEPReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkSEPReader::New());
}
