// java wrapper for vtkGLTFImporter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGLTFImporter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImporter_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGLTFImporter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGLTFImporter",dType)) { return me; }
  if ((res= vtkImporter_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGLTFImporter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGLTFImporter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGLTFImporter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGLTFImporter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFImporter_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGLTFImporter_GetFileName_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFImporter_SetStream_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkResourceStream * temp0;
  temp0 = static_cast<vtkResourceStream*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStream(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGLTFImporter_GetStream_17(JNIEnv* env, jobject obj)
{
  vtkResourceStream * temp20;

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStream();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFImporter_SetStreamURILoader_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkURILoader * temp0;
  temp0 = static_cast<vtkURILoader*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStreamURILoader(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGLTFImporter_GetStreamURILoader_19(JNIEnv* env, jobject obj)
{
  vtkURILoader * temp20;

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStreamURILoader();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFImporter_SetStreamIsBinary_110(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStreamIsBinary(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGLTFImporter_GetStreamIsBinary_111(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStreamIsBinary();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFImporter_StreamIsBinaryOn_112(JNIEnv* env, jobject obj)
{

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->StreamIsBinaryOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFImporter_StreamIsBinaryOff_113(JNIEnv* env, jobject obj)
{

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->StreamIsBinaryOff();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGLTFImporter_GetOutputsDescription_114(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputsDescription();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGLTFImporter_UpdateAtTimeValue_115(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  bool   temp20;
  temp0 = id0;

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UpdateAtTimeValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGLTFImporter_GetNumberOfAnimations_116(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfAnimations();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGLTFImporter_GetAnimationName_117(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  std::string   temp20;
  temp0 = id0;

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnimationName(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFImporter_EnableAnimation_118(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAnimation(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFImporter_DisableAnimation_119(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableAnimation(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGLTFImporter_IsAnimationEnabled_120(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsAnimationEnabled(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGLTFImporter_GetNumberOfCameras_121(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCameras();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGLTFImporter_GetCameraName_122(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  std::string   temp20;
  temp0 = id0;

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCameraName(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFImporter_SetCamera_123(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkGLTFImporter* op = static_cast<vtkGLTFImporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCamera(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkGLTFImporter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkGLTFImporter::New());
}
