// java wrapper for vtkDataWriter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDataWriter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkWriter_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDataWriter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDataWriter",dType)) { return me; }
  if ((res= vtkWriter_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataWriter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataWriter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataWriter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataWriter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataWriter_GetFileName_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_SetFileVersion_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileVersion(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataWriter_GetFileVersion_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileVersion();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataWriter_GetFileMajorVersion_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileMajorVersion();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataWriter_GetFileMinorVersion_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileMinorVersion();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_SetWriteToOutputString_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWriteToOutputString(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataWriter_GetWriteToOutputString_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWriteToOutputString();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_WriteToOutputStringOn_112(JNIEnv* env, jobject obj)
{

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->WriteToOutputStringOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_WriteToOutputStringOff_113(JNIEnv* env, jobject obj)
{

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->WriteToOutputStringOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataWriter_GetOutputStringLength_114(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputStringLength();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataWriter_GetOutputString_115(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataWriter_GetOutputStdString_116(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputStdString();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataWriter_RegisterAndGetOutputString_117(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RegisterAndGetOutputString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_SetHeader_118(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHeader(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataWriter_GetHeader_119(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHeader();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_SetWriteArrayMetaData_120(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWriteArrayMetaData(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataWriter_GetWriteArrayMetaData_121(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWriteArrayMetaData();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_WriteArrayMetaDataOn_122(JNIEnv* env, jobject obj)
{

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->WriteArrayMetaDataOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_WriteArrayMetaDataOff_123(JNIEnv* env, jobject obj)
{

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->WriteArrayMetaDataOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_SetFileType_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataWriter_GetFileTypeMinValue_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileTypeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataWriter_GetFileTypeMaxValue_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileTypeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataWriter_GetFileType_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_SetFileTypeToASCII_128(JNIEnv* env, jobject obj)
{

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileTypeToASCII();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_SetFileTypeToBinary_129(JNIEnv* env, jobject obj)
{

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileTypeToBinary();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_SetScalarsName_130(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarsName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataWriter_GetScalarsName_131(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarsName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_SetVectorsName_132(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVectorsName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataWriter_GetVectorsName_133(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVectorsName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_SetTensorsName_134(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTensorsName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataWriter_GetTensorsName_135(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTensorsName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_SetNormalsName_136(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormalsName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataWriter_GetNormalsName_137(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormalsName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_SetTCoordsName_138(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTCoordsName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataWriter_GetTCoordsName_139(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTCoordsName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_SetGlobalIdsName_140(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGlobalIdsName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataWriter_GetGlobalIdsName_141(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalIdsName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_SetPedigreeIdsName_142(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPedigreeIdsName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataWriter_GetPedigreeIdsName_143(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPedigreeIdsName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_SetEdgeFlagsName_144(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeFlagsName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataWriter_GetEdgeFlagsName_145(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeFlagsName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_SetLookupTableName_146(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLookupTableName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataWriter_GetLookupTableName_147(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLookupTableName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataWriter_SetFieldDataName_148(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFieldDataName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataWriter_GetFieldDataName_149(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataWriter* op = static_cast<vtkDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldDataName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkDataWriter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkDataWriter::New());
}
