// java wrapper for vtkMINCImageWriter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkMINCImageWriter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageWriter_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkMINCImageWriter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkMINCImageWriter",dType)) { return me; }
  if ((res= vtkImageWriter_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMINCImageWriter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMINCImageWriter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMINCImageWriter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMINCImageWriter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMINCImageWriter_GetFileExtensions_14(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileExtensions();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMINCImageWriter_GetDescriptiveName_15(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDescriptiveName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMINCImageWriter_SetFileName_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMINCImageWriter_Write_17(JNIEnv* env, jobject obj)
{

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->Write();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMINCImageWriter_SetDirectionCosines_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDirectionCosines(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMINCImageWriter_GetDirectionCosines_19(JNIEnv* env, jobject obj)
{
  vtkMatrix4x4 * temp20;

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDirectionCosines();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMINCImageWriter_SetRescaleSlope_110(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRescaleSlope(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMINCImageWriter_GetRescaleSlope_111(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRescaleSlope();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMINCImageWriter_SetRescaleIntercept_112(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRescaleIntercept(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMINCImageWriter_GetRescaleIntercept_113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRescaleIntercept();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMINCImageWriter_SetImageAttributes_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMINCImageAttributes * temp0;
  temp0 = static_cast<vtkMINCImageAttributes*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetImageAttributes(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMINCImageWriter_GetImageAttributes_115(JNIEnv* env, jobject obj)
{
  vtkMINCImageAttributes * temp20;

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageAttributes();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMINCImageWriter_SetStrictValidation_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStrictValidation(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMINCImageWriter_StrictValidationOn_117(JNIEnv* env, jobject obj)
{

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->StrictValidationOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMINCImageWriter_StrictValidationOff_118(JNIEnv* env, jobject obj)
{

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->StrictValidationOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMINCImageWriter_GetStrictValidation_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStrictValidation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMINCImageWriter_SetHistoryAddition_120(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHistoryAddition(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMINCImageWriter_GetHistoryAddition_121(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMINCImageWriter* op = static_cast<vtkMINCImageWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHistoryAddition();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkMINCImageWriter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkMINCImageWriter::New());
}
