// java wrapper for vtkImageResample object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageResample.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageReslice_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageResample_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageResample",dType)) { return me; }
  if ((res= vtkImageReslice_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageResample_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageResample* op = static_cast<vtkImageResample*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageResample_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageResample* op = static_cast<vtkImageResample*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageResample_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageResample* op = static_cast<vtkImageResample*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageResample_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageResample* op = static_cast<vtkImageResample*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageResample_SetOutputSpacing_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageResample* op = static_cast<vtkImageResample*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputSpacing(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageResample_SetOutputSpacing_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageResample* op = static_cast<vtkImageResample*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputSpacing(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageResample_SetAxisOutputSpacing_16(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkImageResample* op = static_cast<vtkImageResample*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisOutputSpacing(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageResample_SetMagnificationFactors_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageResample* op = static_cast<vtkImageResample*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMagnificationFactors(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageResample_SetMagnificationFactors_18(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageResample* op = static_cast<vtkImageResample*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMagnificationFactors(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageResample_GetMagnificationFactors_19(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageResample* op = static_cast<vtkImageResample*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMagnificationFactors();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageResample_SetAxisMagnificationFactor_110(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkImageResample* op = static_cast<vtkImageResample*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisMagnificationFactor(temp0,temp1);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageResample_GetAxisMagnificationFactor_111(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkInformation * temp1;
  double   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id1));

  vtkImageResample* op = static_cast<vtkImageResample*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisMagnificationFactor(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageResample_SetDimensionality_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageResample* op = static_cast<vtkImageResample*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensionality(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageResample_GetDimensionality_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageResample* op = static_cast<vtkImageResample*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDimensionality();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageResample_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageResample::New());
}
