// java wrapper for vtkStreamGraph object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkStreamGraph.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkGraphAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkStreamGraph_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkStreamGraph",dType)) { return me; }
  if ((res= vtkGraphAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStreamGraph_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStreamGraph* op = static_cast<vtkStreamGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStreamGraph_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStreamGraph* op = static_cast<vtkStreamGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStreamGraph_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStreamGraph* op = static_cast<vtkStreamGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStreamGraph_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStreamGraph* op = static_cast<vtkStreamGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamGraph_SetUseEdgeWindow_14(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkStreamGraph* op = static_cast<vtkStreamGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseEdgeWindow(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkStreamGraph_GetUseEdgeWindow_15(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkStreamGraph* op = static_cast<vtkStreamGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseEdgeWindow();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamGraph_UseEdgeWindowOn_16(JNIEnv* env, jobject obj)
{

  vtkStreamGraph* op = static_cast<vtkStreamGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseEdgeWindowOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamGraph_UseEdgeWindowOff_17(JNIEnv* env, jobject obj)
{

  vtkStreamGraph* op = static_cast<vtkStreamGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseEdgeWindowOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamGraph_SetEdgeWindowArrayName_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStreamGraph* op = static_cast<vtkStreamGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeWindowArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkStreamGraph_GetEdgeWindowArrayName_19(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkStreamGraph* op = static_cast<vtkStreamGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeWindowArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamGraph_SetEdgeWindow_110(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkStreamGraph* op = static_cast<vtkStreamGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeWindow(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkStreamGraph_GetEdgeWindow_111(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkStreamGraph* op = static_cast<vtkStreamGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeWindow();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkStreamGraph_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkStreamGraph::New());
}
