// java wrapper for vtkLineRepresentation object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkLineRepresentation.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkWidgetRepresentation_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkLineRepresentation_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkLineRepresentation",dType)) { return me; }
  if ((res= vtkWidgetRepresentation_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLineRepresentation_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLineRepresentation_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLineRepresentation_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLineRepresentation_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_GetPoint1WorldPosition_14(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPoint1WorldPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLineRepresentation_GetPoint1WorldPosition_15(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint1WorldPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_GetPoint1DisplayPosition_16(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPoint1DisplayPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLineRepresentation_GetPoint1DisplayPosition_17(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint1DisplayPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_SetPoint1WorldPosition_18(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint1WorldPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_SetPoint1DisplayPosition_19(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint1DisplayPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_GetPoint2DisplayPosition_110(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPoint2DisplayPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLineRepresentation_GetPoint2DisplayPosition_111(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint2DisplayPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_GetPoint2WorldPosition_112(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPoint2WorldPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLineRepresentation_GetPoint2WorldPosition_113(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint2WorldPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_SetPoint2WorldPosition_114(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint2WorldPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_SetPoint2DisplayPosition_115(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint2DisplayPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_SetHandleRepresentation_116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPointHandleRepresentation3D * temp0;
  temp0 = static_cast<vtkPointHandleRepresentation3D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHandleRepresentation(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_InstantiateHandleRepresentation_117(JNIEnv* env, jobject obj)
{

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->InstantiateHandleRepresentation();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLineRepresentation_GetPoint1Representation_118(JNIEnv* env, jobject obj)
{
  vtkPointHandleRepresentation3D * temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint1Representation();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLineRepresentation_GetPoint2Representation_119(JNIEnv* env, jobject obj)
{
  vtkPointHandleRepresentation3D * temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint2Representation();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLineRepresentation_GetLineHandleRepresentation_120(JNIEnv* env, jobject obj)
{
  vtkPointHandleRepresentation3D * temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineHandleRepresentation();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLineRepresentation_GetEndPointProperty_121(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEndPointProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLineRepresentation_GetSelectedEndPointProperty_122(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectedEndPointProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLineRepresentation_GetEndPoint2Property_123(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEndPoint2Property();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLineRepresentation_GetSelectedEndPoint2Property_124(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectedEndPoint2Property();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLineRepresentation_GetLineProperty_125(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLineRepresentation_GetSelectedLineProperty_126(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectedLineProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_SetTolerance_127(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTolerance(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLineRepresentation_GetToleranceMinValue_128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetToleranceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLineRepresentation_GetToleranceMaxValue_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetToleranceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLineRepresentation_GetTolerance_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTolerance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_SetResolution_131(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResolution(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLineRepresentation_GetResolution_132(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetResolution();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_GetPolyData_133(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPolyData * temp0;
  temp0 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPolyData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_PlaceWidget_134(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlaceWidget(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_BuildRepresentation_135(JNIEnv* env, jobject obj)
{

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildRepresentation();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLineRepresentation_ComputeInteractionState_136(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeInteractionState(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_StartWidgetInteraction_137(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartWidgetInteraction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_WidgetInteraction_138(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->WidgetInteraction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLineRepresentation_GetBounds_139(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_GetActors_140(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPropCollection * temp0;
  temp0 = static_cast<vtkPropCollection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetActors(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_ReleaseGraphicsResources_141(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLineRepresentation_RenderOpaqueGeometry_142(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLineRepresentation_RenderTranslucentPolygonalGeometry_143(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLineRepresentation_HasTranslucentPolygonalGeometry_144(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_SetInteractionState_145(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractionState(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLineRepresentation_GetInteractionStateMinValue_146(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInteractionStateMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLineRepresentation_GetInteractionStateMaxValue_147(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInteractionStateMaxValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_SetRepresentationState_148(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRepresentationState(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLineRepresentation_GetRepresentationState_149(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRepresentationState();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_SetDirectionalLine_150(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDirectionalLine(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkLineRepresentation_GetDirectionalLine_151(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDirectionalLine();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_DirectionalLineOn_152(JNIEnv* env, jobject obj)
{

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->DirectionalLineOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_DirectionalLineOff_153(JNIEnv* env, jobject obj)
{

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->DirectionalLineOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLineRepresentation_GetMTime_154(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_SetRenderer_155(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRenderer(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_SetDistanceAnnotationVisibility_156(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDistanceAnnotationVisibility(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLineRepresentation_GetDistanceAnnotationVisibility_157(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistanceAnnotationVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_DistanceAnnotationVisibilityOn_158(JNIEnv* env, jobject obj)
{

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->DistanceAnnotationVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_DistanceAnnotationVisibilityOff_159(JNIEnv* env, jobject obj)
{

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->DistanceAnnotationVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_SetDistanceAnnotationFormat_160(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDistanceAnnotationFormat(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLineRepresentation_GetDistanceAnnotationFormat_161(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistanceAnnotationFormat();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_SetDistanceAnnotationScale_162(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDistanceAnnotationScale(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_SetDistanceAnnotationScale_163(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDistanceAnnotationScale(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLineRepresentation_GetDistanceAnnotationScale_164(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistanceAnnotationScale();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLineRepresentation_GetDistance_165(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_SetLineColor_166(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLineColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_SetInteractionColor_167(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractionColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_SetInteractionColor_168(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractionColor(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_SetForegroundColor_169(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForegroundColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLineRepresentation_SetForegroundColor_170(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForegroundColor(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLineRepresentation_GetDistanceAnnotationProperty_171(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistanceAnnotationProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLineRepresentation_GetTextActor_172(JNIEnv* env, jobject obj)
{
  vtkFollower * temp20;

  vtkLineRepresentation* op = static_cast<vtkLineRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextActor();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkLineRepresentation_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkLineRepresentation::New());
}
