// java wrapper for vtkPointPlacer object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPointPlacer.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPointPlacer_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPointPlacer",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointPlacer_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointPlacer* op = static_cast<vtkPointPlacer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointPlacer_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointPlacer* op = static_cast<vtkPointPlacer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointPlacer_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointPlacer* op = static_cast<vtkPointPlacer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointPlacer_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointPlacer* op = static_cast<vtkPointPlacer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointPlacer_ComputeWorldPosition_14(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3)
{
  vtkRenderer * temp0;
  double temp1[2];
  double temp2[3];
  double temp3[9];
  int   temp20;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 9, &temp3[0]);

  vtkPointPlacer* op = static_cast<vtkPointPlacer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeWorldPosition(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->SetDoubleArrayRegion(id3, 0, 9, &temp3[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointPlacer_ComputeWorldPosition_15(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3,jdoubleArray id4)
{
  vtkRenderer * temp0;
  double temp1[2];
  double temp2[3];
  double temp3[3];
  double temp4[9];
  int   temp20;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->GetDoubleArrayRegion(id4, 0, 9, &temp4[0]);

  vtkPointPlacer* op = static_cast<vtkPointPlacer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeWorldPosition(temp0,temp1,temp2,temp3,temp4);
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->SetDoubleArrayRegion(id4, 0, 9, &temp4[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointPlacer_ValidateWorldPosition_16(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPointPlacer* op = static_cast<vtkPointPlacer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ValidateWorldPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointPlacer_ValidateDisplayPosition_17(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1)
{
  vtkRenderer * temp0;
  double temp1[2];
  int   temp20;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkPointPlacer* op = static_cast<vtkPointPlacer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ValidateDisplayPosition(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointPlacer_ValidateWorldPosition_18(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[9];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 9, &temp1[0]);

  vtkPointPlacer* op = static_cast<vtkPointPlacer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ValidateWorldPosition(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 9, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointPlacer_UpdateWorldPosition_19(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1,jdoubleArray id2)
{
  vtkRenderer * temp0;
  double temp1[3];
  double temp2[9];
  int   temp20;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 9, &temp2[0]);

  vtkPointPlacer* op = static_cast<vtkPointPlacer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UpdateWorldPosition(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 9, &temp2[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointPlacer_UpdateNodeWorldPosition_110(JNIEnv* env, jobject obj,jdoubleArray id0,jlong id1)
{
  double temp0[3];
  long long   temp1;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = id1;

  vtkPointPlacer* op = static_cast<vtkPointPlacer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UpdateNodeWorldPosition(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointPlacer_UpdateInternalState_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointPlacer* op = static_cast<vtkPointPlacer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UpdateInternalState();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointPlacer_SetPixelTolerance_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPointPlacer* op = static_cast<vtkPointPlacer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPixelTolerance(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointPlacer_GetPixelToleranceMinValue_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointPlacer* op = static_cast<vtkPointPlacer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPixelToleranceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointPlacer_GetPixelToleranceMaxValue_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointPlacer* op = static_cast<vtkPointPlacer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPixelToleranceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointPlacer_GetPixelTolerance_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointPlacer* op = static_cast<vtkPointPlacer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPixelTolerance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointPlacer_SetWorldTolerance_116(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPointPlacer* op = static_cast<vtkPointPlacer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWorldTolerance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPointPlacer_GetWorldToleranceMinValue_117(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPointPlacer* op = static_cast<vtkPointPlacer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWorldToleranceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPointPlacer_GetWorldToleranceMaxValue_118(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPointPlacer* op = static_cast<vtkPointPlacer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWorldToleranceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPointPlacer_GetWorldTolerance_119(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPointPlacer* op = static_cast<vtkPointPlacer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWorldTolerance();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPointPlacer_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPointPlacer::New());
}
