// java wrapper for vtkAbstractMapper3D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkAbstractMapper3D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAbstractMapper_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkAbstractMapper3D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkAbstractMapper3D",dType)) { return me; }
  if ((res= vtkAbstractMapper_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractMapper3D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractMapper3D* op = static_cast<vtkAbstractMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractMapper3D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractMapper3D* op = static_cast<vtkAbstractMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractMapper3D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractMapper3D* op = static_cast<vtkAbstractMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractMapper3D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractMapper3D* op = static_cast<vtkAbstractMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAbstractMapper3D_GetBounds_14(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAbstractMapper3D* op = static_cast<vtkAbstractMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractMapper3D_GetBounds_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkAbstractMapper3D* op = static_cast<vtkAbstractMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAbstractMapper3D_GetCenter_16(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAbstractMapper3D* op = static_cast<vtkAbstractMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCenter();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractMapper3D_GetCenter_17(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkAbstractMapper3D* op = static_cast<vtkAbstractMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCenter(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAbstractMapper3D_GetLength_18(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAbstractMapper3D* op = static_cast<vtkAbstractMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLength();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractMapper3D_IsARayCastMapper_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAbstractMapper3D* op = static_cast<vtkAbstractMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsARayCastMapper();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractMapper3D_IsARenderIntoImageMapper_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAbstractMapper3D* op = static_cast<vtkAbstractMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsARenderIntoImageMapper();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractMapper3D_GetClippingPlaneInDataCoords_111(JNIEnv* env, jobject obj,jobject id0,jint id1,jdoubleArray id2)
{
  vtkMatrix4x4 * temp0;
  int   temp1;
  double temp2[4];
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  env->GetDoubleArrayRegion(id2, 0, 4, &temp2[0]);

  vtkAbstractMapper3D* op = static_cast<vtkAbstractMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetClippingPlaneInDataCoords(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id2, 0, 4, &temp2[0]);

}
