// java wrapper for vtkPolyDataMapper2D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPolyDataMapper2D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkMapper2D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPolyDataMapper2D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPolyDataMapper2D",dType)) { return me; }
  if ((res= vtkMapper2D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyDataMapper2D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyDataMapper2D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyDataMapper2D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyDataMapper2D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetInputData_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPolyData * temp0;
  temp0 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyDataMapper2D_GetInput_15(JNIEnv* env, jobject obj)
{
  vtkPolyData * temp20;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetLookupTable_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkScalarsToColors * temp0;
  temp0 = static_cast<vtkScalarsToColors*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLookupTable(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyDataMapper2D_GetLookupTable_17(JNIEnv* env, jobject obj)
{
  vtkScalarsToColors * temp20;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLookupTable();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_CreateDefaultLookupTable_18(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->CreateDefaultLookupTable();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetScalarVisibility_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarVisibility(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyDataMapper2D_GetScalarVisibility_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_ScalarVisibilityOn_111(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScalarVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_ScalarVisibilityOff_112(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScalarVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetColorMode_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyDataMapper2D_GetColorMode_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetColorModeToDefault_115(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorModeToDefault();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetColorModeToMapScalars_116(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorModeToMapScalars();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetColorModeToDirectScalars_117(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorModeToDirectScalars();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPolyDataMapper2D_GetColorModeAsString_118(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetUseLookupTableScalarRange_119(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseLookupTableScalarRange(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyDataMapper2D_GetUseLookupTableScalarRange_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseLookupTableScalarRange();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_UseLookupTableScalarRangeOn_121(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseLookupTableScalarRangeOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_UseLookupTableScalarRangeOff_122(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseLookupTableScalarRangeOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetScalarRange_123(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetScalarRange_124(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarRange(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkPolyDataMapper2D_GetScalarRange_125(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetScalarMode_126(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyDataMapper2D_GetScalarMode_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetScalarModeToDefault_128(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarModeToDefault();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetScalarModeToUsePointData_129(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarModeToUsePointData();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetScalarModeToUseCellData_130(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarModeToUseCellData();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetScalarModeToUsePointFieldData_131(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarModeToUsePointFieldData();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetScalarModeToUseCellFieldData_132(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarModeToUseCellFieldData();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_ColorByArrayComponent_133(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ColorByArrayComponent(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_ColorByArrayComponent_134(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ColorByArrayComponent(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPolyDataMapper2D_GetArrayName_135(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetArrayName_136(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyDataMapper2D_GetArrayId_137(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayId();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetArrayId_138(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArrayId(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyDataMapper2D_GetArrayAccessMode_139(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayAccessMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetArrayAccessMode_140(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArrayAccessMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyDataMapper2D_GetArrayComponent_141(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayComponent();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetArrayComponent_142(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArrayComponent(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyDataMapper2D_GetMTime_143(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetTransformCoordinate_144(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCoordinate * temp0;
  temp0 = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransformCoordinate(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyDataMapper2D_GetTransformCoordinate_145(JNIEnv* env, jobject obj)
{
  vtkCoordinate * temp20;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransformCoordinate();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolyDataMapper2D_GetTransformCoordinateUseDouble_146(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransformCoordinateUseDouble();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_SetTransformCoordinateUseDouble_147(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransformCoordinateUseDouble(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_TransformCoordinateUseDoubleOn_148(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformCoordinateUseDoubleOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_TransformCoordinateUseDoubleOff_149(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformCoordinateUseDoubleOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyDataMapper2D_MapScalars_150(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  vtkUnsignedCharArray * temp20;
  temp0 = id0;

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MapScalars(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper2D_ShallowCopy_151(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractMapper * temp0;
  temp0 = static_cast<vtkAbstractMapper*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyDataMapper2D* op = static_cast<vtkPolyDataMapper2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPolyDataMapper2D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPolyDataMapper2D::New());
}
