// java wrapper for vtkTexture object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkTexture.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkTexture_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkTexture",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTexture_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTexture_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTexture_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTexture_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_Render_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_PostRender_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->PostRender(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_ReleaseGraphicsResources_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_Load_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->Load(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTexture_GetInterpolate_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolate();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetInterpolate_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_InterpolateOn_110(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_InterpolateOff_111(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTexture_GetMipmap_112(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMipmap();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetMipmap_113(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMipmap(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_MipmapOn_114(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->MipmapOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_MipmapOff_115(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->MipmapOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetMaximumAnisotropicFiltering_116(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumAnisotropicFiltering(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkTexture_GetMaximumAnisotropicFiltering_117(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumAnisotropicFiltering();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetQuality_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetQuality(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTexture_GetQuality_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetQuality();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetQualityToDefault_120(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetQualityToDefault();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetQualityTo16Bit_121(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetQualityTo16Bit();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetQualityTo32Bit_122(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetQualityTo32Bit();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetColorMode_123(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTexture_GetColorMode_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetColorModeToDefault_125(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorModeToDefault();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetColorModeToMapScalars_126(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorModeToMapScalars();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetColorModeToDirectScalars_127(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorModeToDirectScalars();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTexture_GetInput_128(JNIEnv* env, jobject obj)
{
  vtkImageData * temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetLookupTable_129(JNIEnv* env, jobject obj,jobject id0)
{
  vtkScalarsToColors * temp0;
  temp0 = static_cast<vtkScalarsToColors*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLookupTable(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTexture_GetLookupTable_130(JNIEnv* env, jobject obj)
{
  vtkScalarsToColors * temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLookupTable();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTexture_GetMappedScalars_131(JNIEnv* env, jobject obj)
{
  vtkUnsignedCharArray * temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMappedScalars();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetTransform_132(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTransform * temp0;
  temp0 = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransform(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTexture_GetTransform_133(JNIEnv* env, jobject obj)
{
  vtkTransform * temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTexture_GetBlendingMode_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlendingMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetBlendingMode_135(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlendingMode(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTexture_GetPremultipliedAlpha_136(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPremultipliedAlpha();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetPremultipliedAlpha_137(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPremultipliedAlpha(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_PremultipliedAlphaOn_138(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->PremultipliedAlphaOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_PremultipliedAlphaOff_139(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->PremultipliedAlphaOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTexture_GetRestrictPowerOf2ImageSmaller_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRestrictPowerOf2ImageSmaller();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetRestrictPowerOf2ImageSmaller_141(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRestrictPowerOf2ImageSmaller(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_RestrictPowerOf2ImageSmallerOn_142(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->RestrictPowerOf2ImageSmallerOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_RestrictPowerOf2ImageSmallerOff_143(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->RestrictPowerOf2ImageSmallerOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTexture_IsTranslucent_144(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTranslucent();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTexture_GetTextureUnit_145(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextureUnit();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTexture_GetCubeMap_146(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCubeMap();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_CubeMapOn_147(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->CubeMapOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_CubeMapOff_148(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->CubeMapOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetCubeMap_149(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCubeMap(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTexture_GetUseSRGBColorSpace_150(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseSRGBColorSpace();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetUseSRGBColorSpace_151(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseSRGBColorSpace(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_UseSRGBColorSpaceOn_152(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseSRGBColorSpaceOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_UseSRGBColorSpaceOff_153(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseSRGBColorSpaceOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetBorderColor_154(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2,jfloat id3)
{
  float   temp0;
  float   temp1;
  float   temp2;
  float   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBorderColor(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetBorderColor_155(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[4];
  env->GetFloatArrayRegion(id0, 0, 4, &temp0[0]);

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBorderColor(temp0);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkTexture_GetBorderColor_156(JNIEnv* env, jobject obj)
{
  float * temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBorderColor();
  return vtkJavaMakeJArrayOfFloat(env, temp20, 4);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTexture_GetWrap_157(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWrap();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetWrap_158(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWrap(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTexture_GetWrapMinValue_159(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWrapMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTexture_GetWrapMaxValue_160(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWrapMaxValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetRepeat_161(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRepeat(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTexture_GetRepeat_162(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRepeat();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_RepeatOn_163(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->RepeatOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_RepeatOff_164(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->RepeatOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_SetEdgeClamp_165(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeClamp(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTexture_GetEdgeClamp_166(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeClamp();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_EdgeClampOn_167(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->EdgeClampOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTexture_EdgeClampOff_168(JNIEnv* env, jobject obj)
{

  vtkTexture* op = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, obj));
  op->EdgeClampOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkTexture_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkTexture::New());
}
