// java wrapper for vtkEGLRenderWindow object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkEGLRenderWindow.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkOpenGLRenderWindow_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkEGLRenderWindow_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkEGLRenderWindow",dType)) { return me; }
  if ((res= vtkOpenGLRenderWindow_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkEGLRenderWindow_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkEGLRenderWindow_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkEGLRenderWindow_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkEGLRenderWindow_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_Frame_14(JNIEnv* env, jobject obj)
{

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Frame();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_SetShowWindow_15(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowWindow(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_WindowInitialize_16(JNIEnv* env, jobject obj)
{

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->WindowInitialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_Initialize_17(JNIEnv* env, jobject obj)
{

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_Finalize_18(JNIEnv* env, jobject obj)
{

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Finalize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_SetFullScreen_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFullScreen(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_WindowRemap_110(JNIEnv* env, jobject obj)
{

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->WindowRemap();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_PrefFullScreen_111(JNIEnv* env, jobject obj)
{

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->PrefFullScreen();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_SetSize_112(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_SetSize_113(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSize(temp0);
  env->SetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_SetStereoCapableWindow_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStereoCapableWindow(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_MakeCurrent_115(JNIEnv* env, jobject obj)
{

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->MakeCurrent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_ReleaseCurrent_116(JNIEnv* env, jobject obj)
{

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseCurrent();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkEGLRenderWindow_IsCurrent_117(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsCurrent();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkEGLRenderWindow_IsDirect_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsDirect();
  return temp20;

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkEGLRenderWindow_GetScreenSize_119(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScreenSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkEGLRenderWindow_GetPosition_120(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPosition();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_SetWindowInfo_121(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWindowInfo(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_SetNextWindowInfo_122(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNextWindowInfo(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_SetParentInfo_123(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetParentInfo(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_SetWindowName_124(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWindowName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_SetPosition_125(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_SetPosition_126(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0);
  env->SetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_HideCursor_127(JNIEnv* env, jobject obj)
{

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->HideCursor();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_ShowCursor_128(JNIEnv* env, jobject obj)
{

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShowCursor();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkEGLRenderWindow_Render_129(JNIEnv* env, jobject obj)
{

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkEGLRenderWindow_GetEventPending_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEventPending();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkEGLRenderWindow_GetOwnWindow_131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOwnWindow();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkEGLRenderWindow_GetNumberOfDevices_132(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfDevices();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkEGLRenderWindow_IsPointSpriteBugPresent_133(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsPointSpriteBugPresent();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkEGLRenderWindow_ReportCapabilities_134(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkEGLRenderWindow* op = static_cast<vtkEGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReportCapabilities();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkEGLRenderWindow_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkEGLRenderWindow::New());
}
