// java wrapper for vtkOpenGLVertexArrayObject object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkOpenGLVertexArrayObject.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkOpenGLVertexArrayObject_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkOpenGLVertexArrayObject",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLVertexArrayObject_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLVertexArrayObject* op = static_cast<vtkOpenGLVertexArrayObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLVertexArrayObject_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLVertexArrayObject* op = static_cast<vtkOpenGLVertexArrayObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLVertexArrayObject_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLVertexArrayObject* op = static_cast<vtkOpenGLVertexArrayObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLVertexArrayObject_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLVertexArrayObject* op = static_cast<vtkOpenGLVertexArrayObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLVertexArrayObject_Bind_14(JNIEnv* env, jobject obj)
{

  vtkOpenGLVertexArrayObject* op = static_cast<vtkOpenGLVertexArrayObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->Bind();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLVertexArrayObject_Release_15(JNIEnv* env, jobject obj)
{

  vtkOpenGLVertexArrayObject* op = static_cast<vtkOpenGLVertexArrayObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->Release();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLVertexArrayObject_ReleaseGraphicsResources_16(JNIEnv* env, jobject obj)
{

  vtkOpenGLVertexArrayObject* op = static_cast<vtkOpenGLVertexArrayObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLVertexArrayObject_ShaderProgramChanged_17(JNIEnv* env, jobject obj)
{

  vtkOpenGLVertexArrayObject* op = static_cast<vtkOpenGLVertexArrayObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShaderProgramChanged();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLVertexArrayObject_AddAttributeArray_18(JNIEnv* env, jobject obj,jobject id0,jobject id1, jbyteArray id2, jint len2,jint id3,jboolean id4)
{
  vtkShaderProgram * temp0;
  vtkOpenGLVertexBufferObject * temp1;
  std::string temp2;
  int   temp3;
  bool   temp4;
  bool   temp20;
  temp0 = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkOpenGLVertexBufferObject*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = vtkJavaUTF8ToString(env, id2, len2);
  temp3 = id3;
  temp4 = (id4 != 0) ? true : false;

  vtkOpenGLVertexArrayObject* op = static_cast<vtkOpenGLVertexArrayObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddAttributeArray(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLVertexArrayObject_RemoveAttributeArray_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkOpenGLVertexArrayObject* op = static_cast<vtkOpenGLVertexArrayObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RemoveAttributeArray(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLVertexArrayObject_SetForceEmulation_110(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkOpenGLVertexArrayObject* op = static_cast<vtkOpenGLVertexArrayObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForceEmulation(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkOpenGLVertexArrayObject_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkOpenGLVertexArrayObject::New());
}
