// java wrapper for vtkDataEncoder object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDataEncoder.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDataEncoder_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDataEncoder",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataEncoder_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataEncoder* op = static_cast<vtkDataEncoder*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataEncoder_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataEncoder* op = static_cast<vtkDataEncoder*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataEncoder_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataEncoder* op = static_cast<vtkDataEncoder*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataEncoder_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataEncoder* op = static_cast<vtkDataEncoder*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataEncoder_SetMaxThreads_14(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkDataEncoder* op = static_cast<vtkDataEncoder*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaxThreads(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataEncoder_GetMaxThreads_15(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkDataEncoder* op = static_cast<vtkDataEncoder*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxThreads();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataEncoder_Initialize_16(JNIEnv* env, jobject obj)
{

  vtkDataEncoder* op = static_cast<vtkDataEncoder*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataEncoder_Push_17(JNIEnv* env, jobject obj,jint id0,jobject id1,jint id2,jint id3)
{
   unsigned int   temp0;
  vtkImageData * temp1;
  int   temp2;
  int   temp3;
  temp0 = id0;
  temp1 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;
  temp3 = id3;

  vtkDataEncoder* op = static_cast<vtkDataEncoder*>(vtkJavaGetPointerFromObject(env, obj));
  op->Push(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataEncoder_Flush_18(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkDataEncoder* op = static_cast<vtkDataEncoder*>(vtkJavaGetPointerFromObject(env, obj));
  op->Flush(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataEncoder_EncodeAsBase64Png_19(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkImageData * temp0;
  int   temp1;
  const char * temp20;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkDataEncoder* op = static_cast<vtkDataEncoder*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EncodeAsBase64Png(temp0,temp1);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataEncoder_EncodeAsBase64Jpg_110(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkImageData * temp0;
  int   temp1;
  const char * temp20;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkDataEncoder* op = static_cast<vtkDataEncoder*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EncodeAsBase64Jpg(temp0,temp1);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataEncoder_Finalize_111(JNIEnv* env, jobject obj)
{

  vtkDataEncoder* op = static_cast<vtkDataEncoder*>(vtkJavaGetPointerFromObject(env, obj));
  op->Finalize();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkDataEncoder_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkDataEncoder::New());
}
