/* SessionManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SessionManager.vala, do not modify */

/*-
 * Copyright (c) 2015-2016 elementary LLC.
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */
/*
 * Code based on budgie-desktop:
 * https://github.com/solus-project/budgie-desktop
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define WINGPANEL_SESSION_MANAGER_GNOME_SESSION_MANAGER_IFACE "org.gnome.SessionManager"
#define WINGPANEL_SESSION_MANAGER_GNOME_SESSION_MANAGER_PATH "/org/gnome/SessionManager"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WINGPANEL_SESSION_MANAGER_TYPE_SESSION_MANAGER (wingpanel_session_manager_session_manager_get_type ())
#define WINGPANEL_SESSION_MANAGER_SESSION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WINGPANEL_SESSION_MANAGER_TYPE_SESSION_MANAGER, WingpanelSessionManagerSessionManager))
#define WINGPANEL_SESSION_MANAGER_IS_SESSION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WINGPANEL_SESSION_MANAGER_TYPE_SESSION_MANAGER))
#define WINGPANEL_SESSION_MANAGER_SESSION_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), WINGPANEL_SESSION_MANAGER_TYPE_SESSION_MANAGER, WingpanelSessionManagerSessionManagerIface))

typedef struct _WingpanelSessionManagerSessionManager WingpanelSessionManagerSessionManager;
typedef struct _WingpanelSessionManagerSessionManagerIface WingpanelSessionManagerSessionManagerIface;

#define WINGPANEL_SESSION_MANAGER_TYPE_SESSION_MANAGER_PROXY (wingpanel_session_manager_session_manager_proxy_get_type ())
typedef GDBusProxy WingpanelSessionManagerSessionManagerProxy;
typedef GDBusProxyClass WingpanelSessionManagerSessionManagerProxyClass;
typedef struct _WingpanelSessionManagerSessionManagerRegisterClientReadyData WingpanelSessionManagerSessionManagerRegisterClientReadyData;
#define _g_free0(var) (var = (g_free (var), NULL))

#define WINGPANEL_SESSION_MANAGER_TYPE_SESSION_CLIENT (wingpanel_session_manager_session_client_get_type ())
#define WINGPANEL_SESSION_MANAGER_SESSION_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WINGPANEL_SESSION_MANAGER_TYPE_SESSION_CLIENT, WingpanelSessionManagerSessionClient))
#define WINGPANEL_SESSION_MANAGER_IS_SESSION_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WINGPANEL_SESSION_MANAGER_TYPE_SESSION_CLIENT))
#define WINGPANEL_SESSION_MANAGER_SESSION_CLIENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), WINGPANEL_SESSION_MANAGER_TYPE_SESSION_CLIENT, WingpanelSessionManagerSessionClientIface))

typedef struct _WingpanelSessionManagerSessionClient WingpanelSessionManagerSessionClient;
typedef struct _WingpanelSessionManagerSessionClientIface WingpanelSessionManagerSessionClientIface;

#define WINGPANEL_SESSION_MANAGER_TYPE_SESSION_CLIENT_PROXY (wingpanel_session_manager_session_client_proxy_get_type ())
enum  {
	WINGPANEL_SESSION_MANAGER_SESSION_CLIENT_STOP_SIGNAL,
	WINGPANEL_SESSION_MANAGER_SESSION_CLIENT_QUERY_END_SESSION_SIGNAL,
	WINGPANEL_SESSION_MANAGER_SESSION_CLIENT_END_SESSION_SIGNAL,
	WINGPANEL_SESSION_MANAGER_SESSION_CLIENT_CANCEL_END_SESSION_SIGNAL,
	WINGPANEL_SESSION_MANAGER_SESSION_CLIENT_NUM_SIGNALS
};
static guint wingpanel_session_manager_session_client_signals[WINGPANEL_SESSION_MANAGER_SESSION_CLIENT_NUM_SIGNALS] = {0};
typedef GDBusProxy WingpanelSessionManagerSessionClientProxy;
typedef GDBusProxyClass WingpanelSessionManagerSessionClientProxyClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _WingpanelSessionManagerRegisterWithSessionData WingpanelSessionManagerRegisterWithSessionData;

struct _WingpanelSessionManagerSessionManagerIface {
	GTypeInterface parent_iface;
	void (*register_client) (WingpanelSessionManagerSessionManager* self, const gchar* app_id, const gchar* client_start_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char* (*register_client_finish) (WingpanelSessionManagerSessionManager* self, GAsyncResult* _res_, GError** error);
};

struct _WingpanelSessionManagerSessionManagerRegisterClientReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* app_id;
	gchar* client_start_id;
};

struct _WingpanelSessionManagerSessionClientIface {
	GTypeInterface parent_iface;
	void (*end_session_response) (WingpanelSessionManagerSessionClient* self, gboolean is_ok, const gchar* reason, GError** error);
};

struct _WingpanelSessionManagerRegisterWithSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* app_id;
	WingpanelSessionManagerSessionClient* result;
	WingpanelSessionManagerSessionClient* sclient;
	char* path;
	gchar* start_id;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	WingpanelSessionManagerSessionManager* session;
	WingpanelSessionManagerSessionManager* _tmp4_;
	char* _tmp5_;
	WingpanelSessionManagerSessionManager* _tmp6_;
	const gchar* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	GError* e;
	GError* _tmp10_;
	const gchar* _tmp11_;
	WingpanelSessionManagerSessionClient* _tmp12_;
	const char* _tmp13_;
	WingpanelSessionManagerSessionClient* _tmp14_;
	WingpanelSessionManagerSessionClient* _tmp15_;
	GError* _vala1_e;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GError* _inner_error0_;
};

VALA_EXTERN GType wingpanel_session_manager_session_manager_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint wingpanel_session_manager_session_manager_register_object (void* object,
                                                                 GDBusConnection* connection,
                                                                 const gchar* path,
                                                                 GError** error);
VALA_EXTERN GType wingpanel_session_manager_session_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WingpanelSessionManagerSessionManager, g_object_unref)
VALA_EXTERN void wingpanel_session_manager_session_manager_register_client (WingpanelSessionManagerSessionManager* self,
                                                                const gchar* app_id,
                                                                const gchar* client_start_id,
                                                                GAsyncReadyCallback _callback_,
                                                                gpointer _user_data_);
VALA_EXTERN char* wingpanel_session_manager_session_manager_register_client_finish (WingpanelSessionManagerSessionManager* self,
                                                                        GAsyncResult* _res_,
                                                                        GError** error);
static GType wingpanel_session_manager_session_manager_get_type_once (void);
static void wingpanel_session_manager_session_manager_proxy_g_signal (GDBusProxy* proxy,
                                                               const gchar* sender_name,
                                                               const gchar* signal_name,
                                                               GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void wingpanel_session_manager_session_manager_proxy_register_client_async (WingpanelSessionManagerSessionManager* self,
                                                                            const gchar* app_id,
                                                                            const gchar* client_start_id,
                                                                            GAsyncReadyCallback _callback_,
                                                                            gpointer _user_data_);
static char* wingpanel_session_manager_session_manager_proxy_register_client_finish (WingpanelSessionManagerSessionManager* self,
                                                                              GAsyncResult* _res_,
                                                                              GError** error);
static void wingpanel_session_manager_session_manager_proxy_wingpanel_session_manager_session_manager_interface_init (WingpanelSessionManagerSessionManagerIface* iface);
static void _dbus_wingpanel_session_manager_session_manager_register_client (WingpanelSessionManagerSessionManager* self,
                                                                      GVariant* _parameters_,
                                                                      GDBusMethodInvocation* invocation);
static void _dbus_wingpanel_session_manager_session_manager_register_client_ready (GObject * source_object,
                                                                            GAsyncResult * _res_,
                                                                            gpointer _user_data_);
static void wingpanel_session_manager_session_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                                           const gchar* sender,
                                                                           const gchar* object_path,
                                                                           const gchar* interface_name,
                                                                           const gchar* method_name,
                                                                           GVariant* parameters,
                                                                           GDBusMethodInvocation* invocation,
                                                                           gpointer user_data);
static GVariant* wingpanel_session_manager_session_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                                                 const gchar* sender,
                                                                                 const gchar* object_path,
                                                                                 const gchar* interface_name,
                                                                                 const gchar* property_name,
                                                                                 GError** error,
                                                                                 gpointer user_data);
static gboolean wingpanel_session_manager_session_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                                                const gchar* sender,
                                                                                const gchar* object_path,
                                                                                const gchar* interface_name,
                                                                                const gchar* property_name,
                                                                                GVariant* value,
                                                                                GError** error,
                                                                                gpointer user_data);
static void _wingpanel_session_manager_session_manager_unregister_object (gpointer user_data);
VALA_EXTERN GType wingpanel_session_manager_session_client_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint wingpanel_session_manager_session_client_register_object (void* object,
                                                                GDBusConnection* connection,
                                                                const gchar* path,
                                                                GError** error);
VALA_EXTERN GType wingpanel_session_manager_session_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WingpanelSessionManagerSessionClient, g_object_unref)
VALA_EXTERN void wingpanel_session_manager_session_client_end_session_response (WingpanelSessionManagerSessionClient* self,
                                                                    gboolean is_ok,
                                                                    const gchar* reason,
                                                                    GError** error);
static GType wingpanel_session_manager_session_client_get_type_once (void);
static void wingpanel_session_manager_session_client_proxy_g_signal (GDBusProxy* proxy,
                                                              const gchar* sender_name,
                                                              const gchar* signal_name,
                                                              GVariant* parameters);
static void _dbus_handle_wingpanel_session_manager_session_client_stop (WingpanelSessionManagerSessionClient* self,
                                                                 GVariant* parameters);
static void _dbus_handle_wingpanel_session_manager_session_client_query_end_session (WingpanelSessionManagerSessionClient* self,
                                                                              GVariant* parameters);
static void _dbus_handle_wingpanel_session_manager_session_client_end_session (WingpanelSessionManagerSessionClient* self,
                                                                        GVariant* parameters);
static void _dbus_handle_wingpanel_session_manager_session_client_cancel_end_session (WingpanelSessionManagerSessionClient* self,
                                                                               GVariant* parameters);
static void wingpanel_session_manager_session_client_proxy_end_session_response (WingpanelSessionManagerSessionClient* self,
                                                                          gboolean is_ok,
                                                                          const gchar* reason,
                                                                          GError** error);
static void wingpanel_session_manager_session_client_proxy_wingpanel_session_manager_session_client_interface_init (WingpanelSessionManagerSessionClientIface* iface);
static void _dbus_wingpanel_session_manager_session_client_end_session_response (WingpanelSessionManagerSessionClient* self,
                                                                          GVariant* _parameters_,
                                                                          GDBusMethodInvocation* invocation);
static void wingpanel_session_manager_session_client_dbus_interface_method_call (GDBusConnection* connection,
                                                                          const gchar* sender,
                                                                          const gchar* object_path,
                                                                          const gchar* interface_name,
                                                                          const gchar* method_name,
                                                                          GVariant* parameters,
                                                                          GDBusMethodInvocation* invocation,
                                                                          gpointer user_data);
static GVariant* wingpanel_session_manager_session_client_dbus_interface_get_property (GDBusConnection* connection,
                                                                                const gchar* sender,
                                                                                const gchar* object_path,
                                                                                const gchar* interface_name,
                                                                                const gchar* property_name,
                                                                                GError** error,
                                                                                gpointer user_data);
static gboolean wingpanel_session_manager_session_client_dbus_interface_set_property (GDBusConnection* connection,
                                                                               const gchar* sender,
                                                                               const gchar* object_path,
                                                                               const gchar* interface_name,
                                                                               const gchar* property_name,
                                                                               GVariant* value,
                                                                               GError** error,
                                                                               gpointer user_data);
static void _dbus_wingpanel_session_manager_session_client_stop (GObject* _sender,
                                                          gpointer* _data);
static void _dbus_wingpanel_session_manager_session_client_query_end_session (GObject* _sender,
                                                                       guint flags,
                                                                       gpointer* _data);
static void _dbus_wingpanel_session_manager_session_client_end_session (GObject* _sender,
                                                                 guint flags,
                                                                 gpointer* _data);
static void _dbus_wingpanel_session_manager_session_client_cancel_end_session (GObject* _sender,
                                                                        gpointer* _data);
static void _wingpanel_session_manager_session_client_unregister_object (gpointer user_data);
static void wingpanel_session_manager_register_with_session_data_free (gpointer _data);
VALA_EXTERN void wingpanel_session_manager_register_with_session (const gchar* app_id,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
VALA_EXTERN WingpanelSessionManagerSessionClient* wingpanel_session_manager_register_with_session_finish (GAsyncResult* _res_);
static gboolean wingpanel_session_manager_register_with_session_co (WingpanelSessionManagerRegisterWithSessionData* _data_);
static void wingpanel_session_manager_register_with_session_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);

static const GDBusArgInfo _wingpanel_session_manager_session_manager_dbus_arg_info_register_client_app_id = {-1, "app_id", "s", NULL};
static const GDBusArgInfo _wingpanel_session_manager_session_manager_dbus_arg_info_register_client_client_start_id = {-1, "client_start_id", "s", NULL};
static const GDBusArgInfo _wingpanel_session_manager_session_manager_dbus_arg_info_register_client_result = {-1, "result", "o", NULL};
static const GDBusArgInfo * const _wingpanel_session_manager_session_manager_dbus_arg_info_register_client_in[] = {&_wingpanel_session_manager_session_manager_dbus_arg_info_register_client_app_id, &_wingpanel_session_manager_session_manager_dbus_arg_info_register_client_client_start_id, NULL};
static const GDBusArgInfo * const _wingpanel_session_manager_session_manager_dbus_arg_info_register_client_out[] = {&_wingpanel_session_manager_session_manager_dbus_arg_info_register_client_result, NULL};
static const GDBusMethodInfo _wingpanel_session_manager_session_manager_dbus_method_info_register_client = {-1, "RegisterClient", (GDBusArgInfo **) (&_wingpanel_session_manager_session_manager_dbus_arg_info_register_client_in), (GDBusArgInfo **) (&_wingpanel_session_manager_session_manager_dbus_arg_info_register_client_out), NULL};
static const GDBusMethodInfo * const _wingpanel_session_manager_session_manager_dbus_method_info[] = {&_wingpanel_session_manager_session_manager_dbus_method_info_register_client, NULL};
static const GDBusSignalInfo * const _wingpanel_session_manager_session_manager_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _wingpanel_session_manager_session_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _wingpanel_session_manager_session_manager_dbus_interface_info = {-1, "org.gnome.SessionManager", (GDBusMethodInfo **) (&_wingpanel_session_manager_session_manager_dbus_method_info), (GDBusSignalInfo **) (&_wingpanel_session_manager_session_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_wingpanel_session_manager_session_manager_dbus_property_info), NULL};
static const GDBusInterfaceVTable _wingpanel_session_manager_session_manager_dbus_interface_vtable = {wingpanel_session_manager_session_manager_dbus_interface_method_call, wingpanel_session_manager_session_manager_dbus_interface_get_property, wingpanel_session_manager_session_manager_dbus_interface_set_property};
static const GDBusArgInfo _wingpanel_session_manager_session_client_dbus_arg_info_end_session_response_is_ok = {-1, "is_ok", "b", NULL};
static const GDBusArgInfo _wingpanel_session_manager_session_client_dbus_arg_info_end_session_response_reason = {-1, "reason", "s", NULL};
static const GDBusArgInfo * const _wingpanel_session_manager_session_client_dbus_arg_info_end_session_response_in[] = {&_wingpanel_session_manager_session_client_dbus_arg_info_end_session_response_is_ok, &_wingpanel_session_manager_session_client_dbus_arg_info_end_session_response_reason, NULL};
static const GDBusArgInfo * const _wingpanel_session_manager_session_client_dbus_arg_info_end_session_response_out[] = {NULL};
static const GDBusMethodInfo _wingpanel_session_manager_session_client_dbus_method_info_end_session_response = {-1, "EndSessionResponse", (GDBusArgInfo **) (&_wingpanel_session_manager_session_client_dbus_arg_info_end_session_response_in), (GDBusArgInfo **) (&_wingpanel_session_manager_session_client_dbus_arg_info_end_session_response_out), NULL};
static const GDBusMethodInfo * const _wingpanel_session_manager_session_client_dbus_method_info[] = {&_wingpanel_session_manager_session_client_dbus_method_info_end_session_response, NULL};
static const GDBusArgInfo * const _wingpanel_session_manager_session_client_dbus_arg_info_stop[] = {NULL};
static const GDBusSignalInfo _wingpanel_session_manager_session_client_dbus_signal_info_stop = {-1, "Stop", (GDBusArgInfo **) (&_wingpanel_session_manager_session_client_dbus_arg_info_stop), NULL};
static const GDBusArgInfo _wingpanel_session_manager_session_client_dbus_arg_info_query_end_session_flags = {-1, "flags", "u", NULL};
static const GDBusArgInfo * const _wingpanel_session_manager_session_client_dbus_arg_info_query_end_session[] = {&_wingpanel_session_manager_session_client_dbus_arg_info_query_end_session_flags, NULL};
static const GDBusSignalInfo _wingpanel_session_manager_session_client_dbus_signal_info_query_end_session = {-1, "QueryEndSession", (GDBusArgInfo **) (&_wingpanel_session_manager_session_client_dbus_arg_info_query_end_session), NULL};
static const GDBusArgInfo _wingpanel_session_manager_session_client_dbus_arg_info_end_session_flags = {-1, "flags", "u", NULL};
static const GDBusArgInfo * const _wingpanel_session_manager_session_client_dbus_arg_info_end_session[] = {&_wingpanel_session_manager_session_client_dbus_arg_info_end_session_flags, NULL};
static const GDBusSignalInfo _wingpanel_session_manager_session_client_dbus_signal_info_end_session = {-1, "EndSession", (GDBusArgInfo **) (&_wingpanel_session_manager_session_client_dbus_arg_info_end_session), NULL};
static const GDBusArgInfo * const _wingpanel_session_manager_session_client_dbus_arg_info_cancel_end_session[] = {NULL};
static const GDBusSignalInfo _wingpanel_session_manager_session_client_dbus_signal_info_cancel_end_session = {-1, "CancelEndSession", (GDBusArgInfo **) (&_wingpanel_session_manager_session_client_dbus_arg_info_cancel_end_session), NULL};
static const GDBusSignalInfo * const _wingpanel_session_manager_session_client_dbus_signal_info[] = {&_wingpanel_session_manager_session_client_dbus_signal_info_stop, &_wingpanel_session_manager_session_client_dbus_signal_info_query_end_session, &_wingpanel_session_manager_session_client_dbus_signal_info_end_session, &_wingpanel_session_manager_session_client_dbus_signal_info_cancel_end_session, NULL};
static const GDBusPropertyInfo * const _wingpanel_session_manager_session_client_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _wingpanel_session_manager_session_client_dbus_interface_info = {-1, "org.gnome.SessionManager.ClientPrivate", (GDBusMethodInfo **) (&_wingpanel_session_manager_session_client_dbus_method_info), (GDBusSignalInfo **) (&_wingpanel_session_manager_session_client_dbus_signal_info), (GDBusPropertyInfo **) (&_wingpanel_session_manager_session_client_dbus_property_info), NULL};
static const GDBusInterfaceVTable _wingpanel_session_manager_session_client_dbus_interface_vtable = {wingpanel_session_manager_session_client_dbus_interface_method_call, wingpanel_session_manager_session_client_dbus_interface_get_property, wingpanel_session_manager_session_client_dbus_interface_set_property};

void
wingpanel_session_manager_session_manager_register_client (WingpanelSessionManagerSessionManager* self,
                                                           const gchar* app_id,
                                                           const gchar* client_start_id,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_)
{
	WingpanelSessionManagerSessionManagerIface* _iface_;
	_iface_ = WINGPANEL_SESSION_MANAGER_SESSION_MANAGER_GET_INTERFACE (self);
	if (_iface_->register_client) {
		_iface_->register_client (self, app_id, client_start_id, _callback_, _user_data_);
	}
}

char*
wingpanel_session_manager_session_manager_register_client_finish (WingpanelSessionManagerSessionManager* self,
                                                                  GAsyncResult* _res_,
                                                                  GError** error)
{
	WingpanelSessionManagerSessionManagerIface* _iface_;
	_iface_ = WINGPANEL_SESSION_MANAGER_SESSION_MANAGER_GET_INTERFACE (self);
	if (_iface_->register_client_finish) {
		return _iface_->register_client_finish (self, _res_, error);
	}
	return NULL;
}

static void
wingpanel_session_manager_session_manager_default_init (WingpanelSessionManagerSessionManagerIface * iface,
                                                        gpointer iface_data)
{
}

static GType
wingpanel_session_manager_session_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WingpanelSessionManagerSessionManagerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wingpanel_session_manager_session_manager_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType wingpanel_session_manager_session_manager_type_id;
	wingpanel_session_manager_session_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "WingpanelSessionManagerSessionManager", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (wingpanel_session_manager_session_manager_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (wingpanel_session_manager_session_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) wingpanel_session_manager_session_manager_proxy_get_type);
	g_type_set_qdata (wingpanel_session_manager_session_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SessionManager");
	g_type_set_qdata (wingpanel_session_manager_session_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_wingpanel_session_manager_session_manager_dbus_interface_info));
	g_type_set_qdata (wingpanel_session_manager_session_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) wingpanel_session_manager_session_manager_register_object);
	return wingpanel_session_manager_session_manager_type_id;
}

GType
wingpanel_session_manager_session_manager_get_type (void)
{
	static volatile gsize wingpanel_session_manager_session_manager_type_id__once = 0;
	if (g_once_init_enter (&wingpanel_session_manager_session_manager_type_id__once)) {
		GType wingpanel_session_manager_session_manager_type_id;
		wingpanel_session_manager_session_manager_type_id = wingpanel_session_manager_session_manager_get_type_once ();
		g_once_init_leave (&wingpanel_session_manager_session_manager_type_id__once, wingpanel_session_manager_session_manager_type_id);
	}
	return wingpanel_session_manager_session_manager_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (WingpanelSessionManagerSessionManagerProxy, wingpanel_session_manager_session_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (WINGPANEL_SESSION_MANAGER_TYPE_SESSION_MANAGER, wingpanel_session_manager_session_manager_proxy_wingpanel_session_manager_session_manager_interface_init) )
static void
wingpanel_session_manager_session_manager_proxy_class_init (WingpanelSessionManagerSessionManagerProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = wingpanel_session_manager_session_manager_proxy_g_signal;
}

static void
wingpanel_session_manager_session_manager_proxy_g_signal (GDBusProxy* proxy,
                                                          const gchar* sender_name,
                                                          const gchar* signal_name,
                                                          GVariant* parameters)
{
}

static void
wingpanel_session_manager_session_manager_proxy_init (WingpanelSessionManagerSessionManagerProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_wingpanel_session_manager_session_manager_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
wingpanel_session_manager_session_manager_proxy_register_client_async (WingpanelSessionManagerSessionManager* self,
                                                                       const gchar* app_id,
                                                                       const gchar* client_start_id,
                                                                       GAsyncReadyCallback _callback_,
                                                                       gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager", "RegisterClient");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (app_id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (client_start_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static char*
wingpanel_session_manager_session_manager_proxy_register_client_finish (WingpanelSessionManagerSessionManager* self,
                                                                        GAsyncResult* _res_,
                                                                        GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	char* _result = NULL;
	GVariant* _tmp0_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	g_object_unref (_reply_message);
	return _result;
}

static void
wingpanel_session_manager_session_manager_proxy_wingpanel_session_manager_session_manager_interface_init (WingpanelSessionManagerSessionManagerIface* iface)
{
	iface->register_client = wingpanel_session_manager_session_manager_proxy_register_client_async;
	iface->register_client_finish = wingpanel_session_manager_session_manager_proxy_register_client_finish;
}

static void
_dbus_wingpanel_session_manager_session_manager_register_client (WingpanelSessionManagerSessionManager* self,
                                                                 GVariant* _parameters_,
                                                                 GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	WingpanelSessionManagerSessionManagerRegisterClientReadyData* _ready_data;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (WingpanelSessionManagerSessionManagerRegisterClientReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->app_id = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->client_start_id = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	wingpanel_session_manager_session_manager_register_client (self, _ready_data->app_id, _ready_data->client_start_id, (GAsyncReadyCallback) _dbus_wingpanel_session_manager_session_manager_register_client_ready, _ready_data);
	_error:
	;
}

static void
_dbus_wingpanel_session_manager_session_manager_register_client_ready (GObject * source_object,
                                                                       GAsyncResult * _res_,
                                                                       gpointer _user_data_)
{
	WingpanelSessionManagerSessionManagerRegisterClientReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	char* result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = wingpanel_session_manager_session_manager_register_client_finish ((WingpanelSessionManagerSessionManager*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_object_path (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->app_id);
	_g_free0 (_ready_data->client_start_id);
	g_slice_free (WingpanelSessionManagerSessionManagerRegisterClientReadyData, _ready_data);
}

static void
wingpanel_session_manager_session_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                                      const gchar* sender,
                                                                      const gchar* object_path,
                                                                      const gchar* interface_name,
                                                                      const gchar* method_name,
                                                                      GVariant* parameters,
                                                                      GDBusMethodInvocation* invocation,
                                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "RegisterClient") == 0) {
		_dbus_wingpanel_session_manager_session_manager_register_client (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
wingpanel_session_manager_session_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                                       const gchar* sender,
                                                                       const gchar* object_path,
                                                                       const gchar* interface_name,
                                                                       const gchar* property_name,
                                                                       GError** error,
                                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
wingpanel_session_manager_session_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                                       const gchar* sender,
                                                                       const gchar* object_path,
                                                                       const gchar* interface_name,
                                                                       const gchar* property_name,
                                                                       GVariant* value,
                                                                       GError** error,
                                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
wingpanel_session_manager_session_manager_register_object (gpointer object,
                                                           GDBusConnection* connection,
                                                           const gchar* path,
                                                           GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_wingpanel_session_manager_session_manager_dbus_interface_info), &_wingpanel_session_manager_session_manager_dbus_interface_vtable, data, _wingpanel_session_manager_session_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_wingpanel_session_manager_session_manager_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
wingpanel_session_manager_session_client_end_session_response (WingpanelSessionManagerSessionClient* self,
                                                               gboolean is_ok,
                                                               const gchar* reason,
                                                               GError** error)
{
	WingpanelSessionManagerSessionClientIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = WINGPANEL_SESSION_MANAGER_SESSION_CLIENT_GET_INTERFACE (self);
	if (_iface_->end_session_response) {
		_iface_->end_session_response (self, is_ok, reason, error);
	}
}

static void
wingpanel_session_manager_session_client_default_init (WingpanelSessionManagerSessionClientIface * iface,
                                                       gpointer iface_data)
{
	wingpanel_session_manager_session_client_signals[WINGPANEL_SESSION_MANAGER_SESSION_CLIENT_STOP_SIGNAL] = g_signal_new ("stop", WINGPANEL_SESSION_MANAGER_TYPE_SESSION_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	wingpanel_session_manager_session_client_signals[WINGPANEL_SESSION_MANAGER_SESSION_CLIENT_QUERY_END_SESSION_SIGNAL] = g_signal_new ("query-end-session", WINGPANEL_SESSION_MANAGER_TYPE_SESSION_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	wingpanel_session_manager_session_client_signals[WINGPANEL_SESSION_MANAGER_SESSION_CLIENT_END_SESSION_SIGNAL] = g_signal_new ("end-session", WINGPANEL_SESSION_MANAGER_TYPE_SESSION_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	wingpanel_session_manager_session_client_signals[WINGPANEL_SESSION_MANAGER_SESSION_CLIENT_CANCEL_END_SESSION_SIGNAL] = g_signal_new ("cancel-end-session", WINGPANEL_SESSION_MANAGER_TYPE_SESSION_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static GType
wingpanel_session_manager_session_client_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WingpanelSessionManagerSessionClientIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wingpanel_session_manager_session_client_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType wingpanel_session_manager_session_client_type_id;
	wingpanel_session_manager_session_client_type_id = g_type_register_static (G_TYPE_INTERFACE, "WingpanelSessionManagerSessionClient", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (wingpanel_session_manager_session_client_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (wingpanel_session_manager_session_client_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) wingpanel_session_manager_session_client_proxy_get_type);
	g_type_set_qdata (wingpanel_session_manager_session_client_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SessionManager.ClientPrivate");
	g_type_set_qdata (wingpanel_session_manager_session_client_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_wingpanel_session_manager_session_client_dbus_interface_info));
	g_type_set_qdata (wingpanel_session_manager_session_client_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) wingpanel_session_manager_session_client_register_object);
	return wingpanel_session_manager_session_client_type_id;
}

GType
wingpanel_session_manager_session_client_get_type (void)
{
	static volatile gsize wingpanel_session_manager_session_client_type_id__once = 0;
	if (g_once_init_enter (&wingpanel_session_manager_session_client_type_id__once)) {
		GType wingpanel_session_manager_session_client_type_id;
		wingpanel_session_manager_session_client_type_id = wingpanel_session_manager_session_client_get_type_once ();
		g_once_init_leave (&wingpanel_session_manager_session_client_type_id__once, wingpanel_session_manager_session_client_type_id);
	}
	return wingpanel_session_manager_session_client_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (WingpanelSessionManagerSessionClientProxy, wingpanel_session_manager_session_client_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (WINGPANEL_SESSION_MANAGER_TYPE_SESSION_CLIENT, wingpanel_session_manager_session_client_proxy_wingpanel_session_manager_session_client_interface_init) )
static void
wingpanel_session_manager_session_client_proxy_class_init (WingpanelSessionManagerSessionClientProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = wingpanel_session_manager_session_client_proxy_g_signal;
}

static void
_dbus_handle_wingpanel_session_manager_session_client_stop (WingpanelSessionManagerSessionClient* self,
                                                            GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "stop");
}

static void
_dbus_handle_wingpanel_session_manager_session_client_query_end_session (WingpanelSessionManagerSessionClient* self,
                                                                         GVariant* parameters)
{
	GVariantIter _arguments_iter;
	guint flags = 0U;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	flags = g_variant_get_uint32 (_tmp3_);
	g_variant_unref (_tmp3_);
	g_signal_emit_by_name (self, "query-end-session", flags);
}

static void
_dbus_handle_wingpanel_session_manager_session_client_end_session (WingpanelSessionManagerSessionClient* self,
                                                                   GVariant* parameters)
{
	GVariantIter _arguments_iter;
	guint flags = 0U;
	GVariant* _tmp4_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	flags = g_variant_get_uint32 (_tmp4_);
	g_variant_unref (_tmp4_);
	g_signal_emit_by_name (self, "end-session", flags);
}

static void
_dbus_handle_wingpanel_session_manager_session_client_cancel_end_session (WingpanelSessionManagerSessionClient* self,
                                                                          GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "cancel-end-session");
}

static void
wingpanel_session_manager_session_client_proxy_g_signal (GDBusProxy* proxy,
                                                         const gchar* sender_name,
                                                         const gchar* signal_name,
                                                         GVariant* parameters)
{
	if (strcmp (signal_name, "Stop") == 0) {
		_dbus_handle_wingpanel_session_manager_session_client_stop ((WingpanelSessionManagerSessionClient*) proxy, parameters);
	} else if (strcmp (signal_name, "QueryEndSession") == 0) {
		_dbus_handle_wingpanel_session_manager_session_client_query_end_session ((WingpanelSessionManagerSessionClient*) proxy, parameters);
	} else if (strcmp (signal_name, "EndSession") == 0) {
		_dbus_handle_wingpanel_session_manager_session_client_end_session ((WingpanelSessionManagerSessionClient*) proxy, parameters);
	} else if (strcmp (signal_name, "CancelEndSession") == 0) {
		_dbus_handle_wingpanel_session_manager_session_client_cancel_end_session ((WingpanelSessionManagerSessionClient*) proxy, parameters);
	}
}

static void
wingpanel_session_manager_session_client_proxy_init (WingpanelSessionManagerSessionClientProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_wingpanel_session_manager_session_client_dbus_interface_info));
}

static void
wingpanel_session_manager_session_client_proxy_end_session_response (WingpanelSessionManagerSessionClient* self,
                                                                     gboolean is_ok,
                                                                     const gchar* reason,
                                                                     GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager.ClientPrivate", "EndSessionResponse");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (is_ok));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (reason));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
wingpanel_session_manager_session_client_proxy_wingpanel_session_manager_session_client_interface_init (WingpanelSessionManagerSessionClientIface* iface)
{
	iface->end_session_response = wingpanel_session_manager_session_client_proxy_end_session_response;
}

static void
_dbus_wingpanel_session_manager_session_client_end_session_response (WingpanelSessionManagerSessionClient* self,
                                                                     GVariant* _parameters_,
                                                                     GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gboolean is_ok = FALSE;
	GVariant* _tmp5_;
	gchar* reason = NULL;
	GVariant* _tmp6_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	is_ok = g_variant_get_boolean (_tmp5_);
	g_variant_unref (_tmp5_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	reason = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	wingpanel_session_manager_session_client_end_session_response (self, is_ok, reason, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (reason);
	;
}

static void
wingpanel_session_manager_session_client_dbus_interface_method_call (GDBusConnection* connection,
                                                                     const gchar* sender,
                                                                     const gchar* object_path,
                                                                     const gchar* interface_name,
                                                                     const gchar* method_name,
                                                                     GVariant* parameters,
                                                                     GDBusMethodInvocation* invocation,
                                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "EndSessionResponse") == 0) {
		_dbus_wingpanel_session_manager_session_client_end_session_response (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
wingpanel_session_manager_session_client_dbus_interface_get_property (GDBusConnection* connection,
                                                                      const gchar* sender,
                                                                      const gchar* object_path,
                                                                      const gchar* interface_name,
                                                                      const gchar* property_name,
                                                                      GError** error,
                                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
wingpanel_session_manager_session_client_dbus_interface_set_property (GDBusConnection* connection,
                                                                      const gchar* sender,
                                                                      const gchar* object_path,
                                                                      const gchar* interface_name,
                                                                      const gchar* property_name,
                                                                      GVariant* value,
                                                                      GError** error,
                                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_wingpanel_session_manager_session_client_stop (GObject* _sender,
                                                     gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager.ClientPrivate", "Stop", _arguments, NULL);
}

static void
_dbus_wingpanel_session_manager_session_client_query_end_session (GObject* _sender,
                                                                  guint flags,
                                                                  gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (flags));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager.ClientPrivate", "QueryEndSession", _arguments, NULL);
}

static void
_dbus_wingpanel_session_manager_session_client_end_session (GObject* _sender,
                                                            guint flags,
                                                            gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (flags));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager.ClientPrivate", "EndSession", _arguments, NULL);
}

static void
_dbus_wingpanel_session_manager_session_client_cancel_end_session (GObject* _sender,
                                                                   gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager.ClientPrivate", "CancelEndSession", _arguments, NULL);
}

guint
wingpanel_session_manager_session_client_register_object (gpointer object,
                                                          GDBusConnection* connection,
                                                          const gchar* path,
                                                          GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_wingpanel_session_manager_session_client_dbus_interface_info), &_wingpanel_session_manager_session_client_dbus_interface_vtable, data, _wingpanel_session_manager_session_client_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "stop", (GCallback) _dbus_wingpanel_session_manager_session_client_stop, data);
	g_signal_connect (object, "query-end-session", (GCallback) _dbus_wingpanel_session_manager_session_client_query_end_session, data);
	g_signal_connect (object, "end-session", (GCallback) _dbus_wingpanel_session_manager_session_client_end_session, data);
	g_signal_connect (object, "cancel-end-session", (GCallback) _dbus_wingpanel_session_manager_session_client_cancel_end_session, data);
	return result;
}

static void
_wingpanel_session_manager_session_client_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_wingpanel_session_manager_session_client_stop, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_wingpanel_session_manager_session_client_query_end_session, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_wingpanel_session_manager_session_client_end_session, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_wingpanel_session_manager_session_client_cancel_end_session, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
wingpanel_session_manager_register_with_session_data_free (gpointer _data)
{
	WingpanelSessionManagerRegisterWithSessionData* _data_;
	_data_ = _data;
	_g_free0 (_data_->app_id);
	_g_object_unref0 (_data_->result);
	g_slice_free (WingpanelSessionManagerRegisterWithSessionData, _data_);
}

void
wingpanel_session_manager_register_with_session (const gchar* app_id,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	WingpanelSessionManagerRegisterWithSessionData* _data_;
	gchar* _tmp0_;
	g_return_if_fail (app_id != NULL);
	_data_ = g_slice_new0 (WingpanelSessionManagerRegisterWithSessionData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, wingpanel_session_manager_register_with_session_data_free);
	_tmp0_ = g_strdup (app_id);
	_g_free0 (_data_->app_id);
	_data_->app_id = _tmp0_;
	wingpanel_session_manager_register_with_session_co (_data_);
}

WingpanelSessionManagerSessionClient*
wingpanel_session_manager_register_with_session_finish (GAsyncResult* _res_)
{
	WingpanelSessionManagerSessionClient* result;
	WingpanelSessionManagerRegisterWithSessionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
wingpanel_session_manager_register_with_session_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	WingpanelSessionManagerRegisterWithSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	wingpanel_session_manager_register_with_session_co (_data_);
}

static gboolean
wingpanel_session_manager_register_with_session_co (WingpanelSessionManagerRegisterWithSessionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->sclient = NULL;
	_data_->path = NULL;
	_data_->_tmp0_ = g_getenv ("DESKTOP_AUTOSTART_ID");
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_data_->start_id = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->start_id;
	if (_data_->_tmp2_ != NULL) {
		g_unsetenv ("DESKTOP_AUTOSTART_ID");
	} else {
		_data_->_tmp3_ = g_strdup ("");
		_g_free0 (_data_->start_id);
		_data_->start_id = _data_->_tmp3_;
	}
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (WINGPANEL_SESSION_MANAGER_TYPE_SESSION_MANAGER_PROXY, 0, NULL, wingpanel_session_manager_register_with_session_ready, _data_, "g-flags", 0, "g-name", WINGPANEL_SESSION_MANAGER_GNOME_SESSION_MANAGER_IFACE, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", WINGPANEL_SESSION_MANAGER_GNOME_SESSION_MANAGER_PATH, "g-interface-name", "org.gnome.SessionManager", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = (WingpanelSessionManagerSessionManager*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->session = (WingpanelSessionManagerSessionManager*) _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = _data_->session;
		_data_->_tmp7_ = _data_->start_id;
		_data_->_state_ = 2;
		wingpanel_session_manager_session_manager_register_client (_data_->_tmp6_, _data_->app_id, _data_->_tmp7_, wingpanel_session_manager_register_with_session_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp8_ = wingpanel_session_manager_session_manager_register_client_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp5_ = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->session);
			goto __catch0_g_error;
		}
		_data_->_tmp9_ = _data_->_tmp5_;
		_data_->_tmp5_ = NULL;
		_g_free0 (_data_->path);
		_data_->path = _data_->_tmp9_;
		_g_free0 (_data_->_tmp5_);
		_g_object_unref0 (_data_->session);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp10_ = _data_->e;
		_data_->_tmp11_ = _data_->_tmp10_->message;
		g_warning ("SessionManager.vala:60: Error registering client: %s", _data_->_tmp11_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		_g_free0 (_data_->start_id);
		_g_free0 (_data_->path);
		_g_object_unref0 (_data_->sclient);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->start_id);
		_g_free0 (_data_->path);
		_g_object_unref0 (_data_->sclient);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp13_ = _data_->path;
		_data_->_state_ = 3;
		g_async_initable_new_async (WINGPANEL_SESSION_MANAGER_TYPE_SESSION_CLIENT_PROXY, 0, NULL, wingpanel_session_manager_register_with_session_ready, _data_, "g-flags", 0, "g-name", WINGPANEL_SESSION_MANAGER_GNOME_SESSION_MANAGER_IFACE, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", (const gchar*) _data_->_tmp13_, "g-interface-name", "org.gnome.SessionManager.ClientPrivate", NULL);
		return FALSE;
		_state_3:
		_data_->_tmp14_ = (WingpanelSessionManagerSessionClient*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp12_ = (WingpanelSessionManagerSessionClient*) _data_->_tmp14_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_data_->_tmp15_ = _data_->_tmp12_;
		_data_->_tmp12_ = NULL;
		_g_object_unref0 (_data_->sclient);
		_data_->sclient = _data_->_tmp15_;
		_g_object_unref0 (_data_->_tmp12_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp16_ = _data_->_vala1_e;
		_data_->_tmp17_ = _data_->_tmp16_->message;
		g_warning ("SessionManager.vala:67: Unable to get Private Client proxy: %s", _data_->_tmp17_);
		_data_->result = NULL;
		_g_error_free0 (_data_->_vala1_e);
		_g_free0 (_data_->start_id);
		_g_free0 (_data_->path);
		_g_object_unref0 (_data_->sclient);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->start_id);
		_g_free0 (_data_->path);
		_g_object_unref0 (_data_->sclient);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->sclient;
	_g_free0 (_data_->start_id);
	_g_free0 (_data_->path);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

