/* Indicator.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Indicator.vala, do not modify */

/*
* Copyright 2015-2020 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "sound.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <libnotify/notify.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <canberra.h>
#include <wingpanel.h>
#include <gio/gio.h>
#include <pulse/pulseaudio.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <granite.h>
#include <locale.h>
#include <canberra-gtk.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SOUND_INDICATOR_0_PROPERTY,
	SOUND_INDICATOR_IS_IN_SESSION_PROPERTY,
	SOUND_INDICATOR_NATURAL_SCROLL_TOUCHPAD_PROPERTY,
	SOUND_INDICATOR_NATURAL_SCROLL_MOUSE_PROPERTY,
	SOUND_INDICATOR_VOLUME_STEP_PROPERTY,
	SOUND_INDICATOR_NUM_PROPERTIES
};
static GParamSpec* sound_indicator_properties[SOUND_INDICATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _ca_proplist_destroy0(var) ((var == NULL) ? NULL : (var = (ca_proplist_destroy (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SoundIndicatorPrivate {
	gboolean _is_in_session;
	gboolean _natural_scroll_touchpad;
	gboolean _natural_scroll_mouse;
	gint _volume_step;
	SoundDisplayWidget* display_widget;
	GtkBox* main_box;
	GtkAdjustment* volume_adjustment;
	GtkAdjustment* mic_adjustment;
	SoundWidgetsPlayerList* mpris;
	SoundWidgetsScale* volume_scale;
	SoundWidgetsScale* mic_scale;
	SoundWidgetsDeviceManagerWidget* output_device_manager;
	SoundWidgetsDeviceManagerWidget* input_device_manager;
	GtkSeparator* mic_separator;
	NotifyNotification* notification;
	SoundServicesVolumeControlPulse* volume_control;
	ShellKeyGrabber* key_grabber;
	gulong key_grabber_id;
	GeeHashMultiMap* saved_action_ids;
	gboolean open;
	gboolean mute_blocks_sound;
	guint sound_was_blocked_timeout_id;
	gdouble max_volume;
	ca_context* ca_context;
	gdouble total_x_delta;
	gdouble total_y_delta;
	guint notify_timeout_id;
};

struct _Block1Data {
	int _ref_count_;
	SoundIndicator* self;
	gboolean is_mic;
};

static gint SoundIndicator_private_offset;
static gpointer sound_indicator_parent_class = NULL;
GSettings* sound_indicator_settings = NULL;

static void sound_indicator_ungrab_keybindings (SoundIndicator* self);
static void sound_indicator_setup_grabs (SoundIndicator* self);
static void _vala_array_add1 (Accelerator* * array,
                       gint* length,
                       gint* size,
                       const Accelerator* value);
static void _vala_array_add2 (Accelerator* * array,
                       gint* length,
                       gint* size,
                       const Accelerator* value);
static void _vala_array_add3 (Accelerator* * array,
                       gint* length,
                       gint* size,
                       const Accelerator* value);
static void _vala_Accelerator_array_free (Accelerator * array,
                                   gssize array_length);
static void sound_indicator_on_accelerator_activated (SoundIndicator* self,
                                               guint action,
                                               GHashTable* parameters_dict);
static void _sound_indicator_on_accelerator_activated_shell_key_grabber_accelerator_activated (ShellKeyGrabber* _sender,
                                                                                        guint action,
                                                                                        GHashTable* parameters_dict,
                                                                                        gpointer self);
static void sound_indicator_handle_change (SoundIndicator* self,
                                    gdouble change,
                                    gboolean is_mic);
static void sound_indicator_notify_change (SoundIndicator* self,
                                    gboolean is_mic);
static void sound_indicator_set_max_volume (SoundIndicator* self);
static void sound_indicator_on_volume_change (SoundIndicator* self);
static const gchar* sound_indicator_get_volume_icon (SoundIndicator* self,
                                              gdouble volume);
static void sound_indicator_on_mic_volume_change (SoundIndicator* self);
static void sound_indicator_on_mute_change (SoundIndicator* self);
static void sound_indicator_on_mic_mute_change (SoundIndicator* self);
static void sound_indicator_on_is_playing_change (SoundIndicator* self);
static gboolean ____lambda59_ (SoundIndicator* self);
static gboolean _____lambda59__gsource_func (gpointer self);
static void sound_indicator_on_volume_icon_scroll_event (SoundIndicator* self,
                                                  GdkEventScroll* e);
static gboolean sound_indicator_handle_scroll_event (SoundIndicator* self,
                                              GdkEventScroll* e,
                                              gdouble* dir);
static void sound_indicator_on_mic_icon_scroll_event (SoundIndicator* self,
                                               GdkEventScroll* e);
static void sound_indicator_update_mic_visibility (SoundIndicator* self);
static void sound_indicator_on_volume_switch_change (SoundIndicator* self);
static void sound_indicator_on_mic_switch_change (SoundIndicator* self);
static GtkWidget* sound_indicator_real_get_display_widget (WingpanelIndicator* base);
static GtkWidget* sound_indicator_real_get_widget (WingpanelIndicator* base);
static void _sound_indicator_on_mic_switch_change_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void ___lambda60_ (SoundIndicator* self);
static void ____lambda60__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                 gpointer self);
static gboolean ___lambda61_ (SoundIndicator* self,
                       GdkEventScroll* e);
static gboolean ____lambda61__gtk_widget_scroll_event (GtkWidget* _sender,
                                                GdkEventScroll* event,
                                                gpointer self);
static void ___lambda62_ (SoundIndicator* self);
static void ____lambda62__sound_widgets_player_list_close (SoundWidgetsPlayerList* _sender,
                                                    gpointer self);
static void ___lambda63_ (SoundIndicator* self);
static void sound_indicator_show_settings (SoundIndicator* self);
static void ____lambda63__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void ___lambda64_ (SoundIndicator* self);
static void ____lambda64__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void sound_indicator_play_volume_change_sound (SoundIndicator* self);
static void _sound_indicator_play_volume_change_sound_sound_widgets_scale_slider_dropped (SoundWidgetsScale* _sender,
                                                                                   gpointer self);
static gboolean ___lambda65_ (SoundIndicator* self,
                       GdkEventScroll* e);
static gboolean ____lambda65__gtk_widget_scroll_event (GtkWidget* _sender,
                                                GdkEventScroll* event,
                                                gpointer self);
static void _sound_indicator_on_volume_switch_change_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static void ___lambda66_ (SoundIndicator* self);
static void ____lambda66__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                 gpointer self);
static void sound_indicator_real_opened (WingpanelIndicator* base);
static void sound_indicator_real_closed (WingpanelIndicator* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda58_ (Block1Data* _data1_);
static gboolean sound_indicator_show_notification (SoundIndicator* self,
                                            gboolean is_mic);
static gboolean ___lambda58__gsource_func (gpointer self);
static void sound_indicator_update_tooltip (SoundIndicator* self);
static GObject * sound_indicator_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void _sound_indicator_on_volume_change_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void _sound_indicator_on_mic_volume_change_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void _sound_indicator_on_mute_change_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void _sound_indicator_on_mic_mute_change_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void _sound_indicator_on_is_playing_change_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void _sound_indicator_update_mic_visibility_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
static void _sound_indicator_update_tooltip_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void _sound_indicator_set_max_volume_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void _sound_services_volume_control_pulse_toggle_mute_sound_display_widget_volume_press_event (SoundDisplayWidget* _sender,
                                                                                               gpointer self);
static void _sound_services_volume_control_pulse_toggle_mic_mute_sound_display_widget_mic_press_event (SoundDisplayWidget* _sender,
                                                                                                gpointer self);
static void _sound_indicator_on_volume_icon_scroll_event_sound_display_widget_volume_scroll_event (SoundDisplayWidget* _sender,
                                                                                            GdkEventScroll* e,
                                                                                            gpointer self);
static void _sound_indicator_on_mic_icon_scroll_event_sound_display_widget_mic_scroll_event (SoundDisplayWidget* _sender,
                                                                                      GdkEventScroll* e,
                                                                                      gpointer self);
static void _sound_indicator___lambda67_ (SoundIndicator* self,
                                   GObject* obj,
                                   GAsyncResult* res);
static void __sound_indicator___lambda67__gasync_ready_callback (GObject* source_object,
                                                          GAsyncResult* res,
                                                          gpointer self);
static void _sound_indicator___lambda68_ (SoundIndicator* self,
                                   const gchar* key);
static void __sound_indicator___lambda68__g_settings_changed (GSettings* _sender,
                                                       const gchar* key,
                                                       gpointer self);
static void sound_indicator_finalize (GObject * obj);
static GType sound_indicator_get_type_once (void);
static void _vala_sound_indicator_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_sound_indicator_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
sound_indicator_get_instance_private (SoundIndicator* self)
{
	return G_STRUCT_MEMBER_P (self, SoundIndicator_private_offset);
}

SoundIndicator*
sound_indicator_construct (GType object_type,
                           gboolean is_in_session)
{
	SoundIndicator * self = NULL;
	self = (SoundIndicator*) g_object_new (object_type, "code-name", WINGPANEL_INDICATOR_SOUND, "is-in-session", is_in_session, NULL);
	return self;
}

SoundIndicator*
sound_indicator_new (gboolean is_in_session)
{
	return sound_indicator_construct (SOUND_TYPE_INDICATOR, is_in_session);
}

static void
sound_indicator_ungrab_keybindings (SoundIndicator* self)
{
	ShellKeyGrabber* _tmp0_;
	guint* actions = NULL;
	GeeHashMultiMap* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	gint _tmp4_ = 0;
	gpointer* _tmp5_;
	guint* _tmp6_;
	gint _tmp6__length1;
	gint actions_length1;
	gint _actions_size_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_grabber;
	_vala_return_if_fail (_tmp0_ != NULL, "key_grabber != null");
	_tmp1_ = self->priv->saved_action_ids;
	_tmp2_ = gee_multi_map_get_values ((GeeMultiMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp5_ = gee_collection_to_array (_tmp3_, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	_g_object_unref0 (_tmp3_);
	actions = _tmp6_;
	actions_length1 = _tmp6__length1;
	_actions_size_ = actions_length1;
	{
		ShellKeyGrabber* _tmp7_;
		_tmp7_ = self->priv->key_grabber;
		shell_key_grabber_ungrab_accelerators (_tmp7_, actions, (gint) actions_length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_critical ("Indicator.vala:176: Couldn't ungrab accelerators: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		actions = (g_free (actions), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	actions = (g_free (actions), NULL);
}

static void
_vala_array_add1 (Accelerator* * array,
                  gint* length,
                  gint* size,
                  const Accelerator* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Accelerator, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add2 (Accelerator* * array,
                  gint* length,
                  gint* size,
                  const Accelerator* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Accelerator, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add3 (Accelerator* * array,
                  gint* length,
                  gint* size,
                  const Accelerator* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Accelerator, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_Accelerator_array_free (Accelerator * array,
                              gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			accelerator_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_sound_indicator_on_accelerator_activated_shell_key_grabber_accelerator_activated (ShellKeyGrabber* _sender,
                                                                                   guint action,
                                                                                   GHashTable* parameters_dict,
                                                                                   gpointer self)
{
	sound_indicator_on_accelerator_activated ((SoundIndicator*) self, action, parameters_dict);
}

static void
sound_indicator_setup_grabs (SoundIndicator* self)
{
	ShellKeyGrabber* _tmp0_;
	Accelerator* accelerators = NULL;
	Accelerator* _tmp1_;
	gint accelerators_length1;
	gint _accelerators_size_;
	gchar** volume_up_keybindings = NULL;
	GSettings* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint volume_up_keybindings_length1;
	gint _volume_up_keybindings_size_;
	gchar** volume_down_keybindings = NULL;
	GSettings* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint volume_down_keybindings_length1;
	gint _volume_down_keybindings_size_;
	gchar** volume_mute_keybindings = NULL;
	GSettings* _tmp22_;
	gchar** _tmp23_;
	gchar** _tmp24_;
	gint volume_mute_keybindings_length1;
	gint _volume_mute_keybindings_size_;
	guint* action_ids = NULL;
	gint action_ids_length1 = 0;
	gint _action_ids_size_ = 0;
	ShellKeyGrabber* _tmp55_;
	gulong _tmp56_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_grabber;
	_vala_return_if_fail (_tmp0_ != NULL, "key_grabber != null");
	_tmp1_ = g_new0 (Accelerator, 0);
	accelerators = _tmp1_;
	accelerators_length1 = 0;
	_accelerators_size_ = accelerators_length1;
	_tmp2_ = sound_indicator_settings;
	_tmp4_ = _tmp3_ = g_settings_get_strv (_tmp2_, "volume-up");
	volume_up_keybindings = _tmp4_;
	volume_up_keybindings_length1 = _vala_array_length (_tmp3_);
	_volume_up_keybindings_size_ = volume_up_keybindings_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gchar** _tmp7_;
				gint _tmp7__length1;
				gchar** _tmp8_;
				gint _tmp8__length1;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				Accelerator _tmp11_ = {0};
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = volume_up_keybindings;
				_tmp7__length1 = volume_up_keybindings_length1;
				if (!(i < _tmp7__length1)) {
					break;
				}
				_tmp8_ = volume_up_keybindings;
				_tmp8__length1 = volume_up_keybindings_length1;
				_tmp9_ = _tmp8_[i];
				_tmp10_ = g_strdup (_tmp9_);
				memset (&_tmp11_, 0, sizeof (Accelerator));
				_g_free0 (_tmp11_.name);
				_tmp11_.name = _tmp10_;
				_tmp11_.mode_flags = ACTION_MODE_LOGIN_SCREEN;
				_tmp11_.grab_flags = META_KEY_BINDING_FLAGS_NONE;
				_vala_array_add1 (&accelerators, &accelerators_length1, &_accelerators_size_, &_tmp11_);
			}
		}
	}
	_tmp12_ = sound_indicator_settings;
	_tmp14_ = _tmp13_ = g_settings_get_strv (_tmp12_, "volume-down");
	volume_down_keybindings = _tmp14_;
	volume_down_keybindings_length1 = _vala_array_length (_tmp13_);
	_volume_down_keybindings_size_ = volume_down_keybindings_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				gchar** _tmp17_;
				gint _tmp17__length1;
				gchar** _tmp18_;
				gint _tmp18__length1;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				Accelerator _tmp21_ = {0};
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = volume_down_keybindings;
				_tmp17__length1 = volume_down_keybindings_length1;
				if (!(i < _tmp17__length1)) {
					break;
				}
				_tmp18_ = volume_down_keybindings;
				_tmp18__length1 = volume_down_keybindings_length1;
				_tmp19_ = _tmp18_[i];
				_tmp20_ = g_strdup (_tmp19_);
				memset (&_tmp21_, 0, sizeof (Accelerator));
				_g_free0 (_tmp21_.name);
				_tmp21_.name = _tmp20_;
				_tmp21_.mode_flags = ACTION_MODE_LOGIN_SCREEN;
				_tmp21_.grab_flags = META_KEY_BINDING_FLAGS_NONE;
				_vala_array_add2 (&accelerators, &accelerators_length1, &_accelerators_size_, &_tmp21_);
			}
		}
	}
	_tmp22_ = sound_indicator_settings;
	_tmp24_ = _tmp23_ = g_settings_get_strv (_tmp22_, "volume-mute");
	volume_mute_keybindings = _tmp24_;
	volume_mute_keybindings_length1 = _vala_array_length (_tmp23_);
	_volume_mute_keybindings_size_ = volume_mute_keybindings_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp25_ = FALSE;
			_tmp25_ = TRUE;
			while (TRUE) {
				gchar** _tmp27_;
				gint _tmp27__length1;
				gchar** _tmp28_;
				gint _tmp28__length1;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				Accelerator _tmp31_ = {0};
				if (!_tmp25_) {
					gint _tmp26_;
					_tmp26_ = i;
					i = _tmp26_ + 1;
				}
				_tmp25_ = FALSE;
				_tmp27_ = volume_mute_keybindings;
				_tmp27__length1 = volume_mute_keybindings_length1;
				if (!(i < _tmp27__length1)) {
					break;
				}
				_tmp28_ = volume_mute_keybindings;
				_tmp28__length1 = volume_mute_keybindings_length1;
				_tmp29_ = _tmp28_[i];
				_tmp30_ = g_strdup (_tmp29_);
				memset (&_tmp31_, 0, sizeof (Accelerator));
				_g_free0 (_tmp31_.name);
				_tmp31_.name = _tmp30_;
				_tmp31_.mode_flags = ACTION_MODE_LOGIN_SCREEN;
				_tmp31_.grab_flags = META_KEY_BINDING_FLAGS_IGNORE_AUTOREPEAT;
				_vala_array_add3 (&accelerators, &accelerators_length1, &_accelerators_size_, &_tmp31_);
			}
		}
	}
	{
		guint* _tmp32_ = NULL;
		ShellKeyGrabber* _tmp33_;
		Accelerator* _tmp34_;
		gint _tmp34__length1;
		gint _tmp35_ = 0;
		guint* _tmp36_;
		gint _tmp32__length1;
		gint __tmp32__size_;
		guint* _tmp37_;
		gint _tmp37__length1;
		_tmp33_ = self->priv->key_grabber;
		_tmp34_ = accelerators;
		_tmp34__length1 = accelerators_length1;
		_tmp36_ = shell_key_grabber_grab_accelerators (_tmp33_, _tmp34_, (gint) _tmp34__length1, &_tmp35_, &_inner_error0_);
		_tmp32_ = _tmp36_;
		_tmp32__length1 = _tmp35_;
		__tmp32__size_ = _tmp32__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp37_ = _tmp32_;
		_tmp37__length1 = _tmp32__length1;
		_tmp32_ = NULL;
		_tmp32__length1 = 0;
		action_ids = (g_free (action_ids), NULL);
		action_ids = _tmp37_;
		action_ids_length1 = _tmp37__length1;
		_action_ids_size_ = action_ids_length1;
		_tmp32_ = (g_free (_tmp32_), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp38_;
		const gchar* _tmp39_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp38_ = e;
		_tmp39_ = _tmp38_->message;
		g_critical ("Indicator.vala:214: %s", _tmp39_);
		_g_error_free0 (e);
		action_ids = (g_free (action_ids), NULL);
		volume_mute_keybindings = (_vala_array_free (volume_mute_keybindings, volume_mute_keybindings_length1, (GDestroyNotify) g_free), NULL);
		volume_down_keybindings = (_vala_array_free (volume_down_keybindings, volume_down_keybindings_length1, (GDestroyNotify) g_free), NULL);
		volume_up_keybindings = (_vala_array_free (volume_up_keybindings, volume_up_keybindings_length1, (GDestroyNotify) g_free), NULL);
		accelerators = (_vala_Accelerator_array_free (accelerators, accelerators_length1), NULL);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		action_ids = (g_free (action_ids), NULL);
		volume_mute_keybindings = (_vala_array_free (volume_mute_keybindings, volume_mute_keybindings_length1, (GDestroyNotify) g_free), NULL);
		volume_down_keybindings = (_vala_array_free (volume_down_keybindings, volume_down_keybindings_length1, (GDestroyNotify) g_free), NULL);
		volume_up_keybindings = (_vala_array_free (volume_up_keybindings, volume_up_keybindings_length1, (GDestroyNotify) g_free), NULL);
		accelerators = (_vala_Accelerator_array_free (accelerators, accelerators_length1), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp40_ = FALSE;
			_tmp40_ = TRUE;
			while (TRUE) {
				guint* _tmp42_;
				gint _tmp42__length1;
				gchar** _tmp43_;
				gint _tmp43__length1;
				if (!_tmp40_) {
					gint _tmp41_;
					_tmp41_ = i;
					i = _tmp41_ + 1;
				}
				_tmp40_ = FALSE;
				_tmp42_ = action_ids;
				_tmp42__length1 = action_ids_length1;
				if (!(i < _tmp42__length1)) {
					break;
				}
				_tmp43_ = volume_up_keybindings;
				_tmp43__length1 = volume_up_keybindings_length1;
				if (i < _tmp43__length1) {
					GeeHashMultiMap* _tmp44_;
					guint* _tmp45_;
					gint _tmp45__length1;
					guint _tmp46_;
					_tmp44_ = self->priv->saved_action_ids;
					_tmp45_ = action_ids;
					_tmp45__length1 = action_ids_length1;
					_tmp46_ = _tmp45_[i];
					gee_multi_map_set ((GeeMultiMap*) _tmp44_, "volume-up", (gpointer) ((guintptr) _tmp46_));
				} else {
					gchar** _tmp47_;
					gint _tmp47__length1;
					gchar** _tmp48_;
					gint _tmp48__length1;
					_tmp47_ = volume_up_keybindings;
					_tmp47__length1 = volume_up_keybindings_length1;
					_tmp48_ = volume_down_keybindings;
					_tmp48__length1 = volume_down_keybindings_length1;
					if (i < (_tmp47__length1 + _tmp48__length1)) {
						GeeHashMultiMap* _tmp49_;
						guint* _tmp50_;
						gint _tmp50__length1;
						guint _tmp51_;
						_tmp49_ = self->priv->saved_action_ids;
						_tmp50_ = action_ids;
						_tmp50__length1 = action_ids_length1;
						_tmp51_ = _tmp50_[i];
						gee_multi_map_set ((GeeMultiMap*) _tmp49_, "volume-down", (gpointer) ((guintptr) _tmp51_));
					} else {
						GeeHashMultiMap* _tmp52_;
						guint* _tmp53_;
						gint _tmp53__length1;
						guint _tmp54_;
						_tmp52_ = self->priv->saved_action_ids;
						_tmp53_ = action_ids;
						_tmp53__length1 = action_ids_length1;
						_tmp54_ = _tmp53_[i];
						gee_multi_map_set ((GeeMultiMap*) _tmp52_, "volume-mute", (gpointer) ((guintptr) _tmp54_));
					}
				}
			}
		}
	}
	_tmp55_ = self->priv->key_grabber;
	_tmp56_ = g_signal_connect_object (_tmp55_, "accelerator-activated", (GCallback) _sound_indicator_on_accelerator_activated_shell_key_grabber_accelerator_activated, self, 0);
	self->priv->key_grabber_id = _tmp56_;
	action_ids = (g_free (action_ids), NULL);
	volume_mute_keybindings = (_vala_array_free (volume_mute_keybindings, volume_mute_keybindings_length1, (GDestroyNotify) g_free), NULL);
	volume_down_keybindings = (_vala_array_free (volume_down_keybindings, volume_down_keybindings_length1, (GDestroyNotify) g_free), NULL);
	volume_up_keybindings = (_vala_array_free (volume_up_keybindings, volume_up_keybindings_length1, (GDestroyNotify) g_free), NULL);
	accelerators = (_vala_Accelerator_array_free (accelerators, accelerators_length1), NULL);
}

static void
sound_indicator_on_accelerator_activated (SoundIndicator* self,
                                          guint action,
                                          GHashTable* parameters_dict)
{
	GeeHashMultiMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameters_dict != NULL);
	_tmp0_ = self->priv->saved_action_ids;
	_tmp1_ = gee_multi_map_get ((GeeMultiMap*) _tmp0_, "volume-up");
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_collection_contains (_tmp2_, (gpointer) ((guintptr) action));
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		sound_indicator_handle_change (self, 1.0, FALSE);
	} else {
		GeeHashMultiMap* _tmp4_;
		GeeCollection* _tmp5_;
		GeeCollection* _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = self->priv->saved_action_ids;
		_tmp5_ = gee_multi_map_get ((GeeMultiMap*) _tmp4_, "volume-down");
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_collection_contains (_tmp6_, (gpointer) ((guintptr) action));
		_g_object_unref0 (_tmp6_);
		if (_tmp7_) {
			sound_indicator_handle_change (self, -1.0, FALSE);
		} else {
			GeeHashMultiMap* _tmp8_;
			GeeCollection* _tmp9_;
			GeeCollection* _tmp10_;
			gboolean _tmp11_;
			_tmp8_ = self->priv->saved_action_ids;
			_tmp9_ = gee_multi_map_get ((GeeMultiMap*) _tmp8_, "volume-mute");
			_tmp10_ = _tmp9_;
			_tmp11_ = gee_collection_contains (_tmp10_, (gpointer) ((guintptr) action));
			_g_object_unref0 (_tmp10_);
			if (_tmp11_) {
				SoundServicesVolumeControlPulse* _tmp12_;
				_tmp12_ = self->priv->volume_control;
				sound_services_volume_control_pulse_toggle_mute (_tmp12_);
				sound_indicator_notify_change (self, FALSE);
			}
		}
	}
}

static void
sound_indicator_set_max_volume (SoundIndicator* self)
{
	gdouble max = 0.0;
	GSettings* _tmp0_;
	gdouble cap_volume = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = sound_indicator_settings;
	max = g_settings_get_double (_tmp0_, "max-volume") / 100;
	cap_volume = ((gdouble) pa_sw_volume_from_dB (11.0)) / PA_VOLUME_NORM;
	if (max > cap_volume) {
		max = cap_volume;
	}
	self->priv->max_volume = max;
	sound_indicator_on_volume_change (self);
}

static void
sound_indicator_on_volume_change (SoundIndicator* self)
{
	gdouble volume = 0.0;
	SoundServicesVolumeControlPulse* _tmp0_;
	SoundServicesVolumeControlVolume* _tmp1_;
	SoundServicesVolumeControlVolume* _tmp2_;
	GtkAdjustment* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->volume_control;
	_tmp1_ = sound_services_volume_control_get_volume ((SoundServicesVolumeControl*) _tmp0_);
	_tmp2_ = _tmp1_;
	volume = _tmp2_->volume / self->priv->max_volume;
	_tmp3_ = self->priv->volume_adjustment;
	if (volume != gtk_adjustment_get_value (_tmp3_)) {
		GtkAdjustment* _tmp4_;
		SoundDisplayWidget* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = self->priv->volume_adjustment;
		gtk_adjustment_set_value (_tmp4_, volume);
		_tmp5_ = self->priv->display_widget;
		_tmp6_ = sound_indicator_get_volume_icon (self, volume);
		sound_display_widget_set_icon_name (_tmp5_, _tmp6_);
	}
}

static void
sound_indicator_on_mic_volume_change (SoundIndicator* self)
{
	gdouble volume = 0.0;
	SoundServicesVolumeControlPulse* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	GtkAdjustment* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->volume_control;
	_tmp1_ = sound_services_volume_control_get_mic_volume ((SoundServicesVolumeControl*) _tmp0_);
	_tmp2_ = _tmp1_;
	volume = _tmp2_;
	_tmp3_ = self->priv->mic_adjustment;
	if (volume != gtk_adjustment_get_value (_tmp3_)) {
		GtkAdjustment* _tmp4_;
		_tmp4_ = self->priv->mic_adjustment;
		gtk_adjustment_set_value (_tmp4_, volume);
	}
}

static void
sound_indicator_on_mute_change (SoundIndicator* self)
{
	SoundWidgetsScale* _tmp0_;
	SoundServicesVolumeControlPulse* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gchar* volume_icon = NULL;
	SoundServicesVolumeControlPulse* _tmp4_;
	SoundServicesVolumeControlVolume* _tmp5_;
	SoundServicesVolumeControlVolume* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	SoundDisplayWidget* _tmp9_;
	const gchar* _tmp10_;
	SoundServicesVolumeControlPulse* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->volume_scale;
	_tmp1_ = self->priv->volume_control;
	_tmp2_ = sound_services_volume_control_get_mute ((SoundServicesVolumeControl*) _tmp1_);
	_tmp3_ = _tmp2_;
	sound_widgets_scale_set_active (_tmp0_, !_tmp3_);
	_tmp4_ = self->priv->volume_control;
	_tmp5_ = sound_services_volume_control_get_volume ((SoundServicesVolumeControl*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = sound_indicator_get_volume_icon (self, _tmp6_->volume);
	_tmp8_ = g_strdup (_tmp7_);
	volume_icon = _tmp8_;
	_tmp9_ = self->priv->display_widget;
	_tmp10_ = volume_icon;
	sound_display_widget_set_icon_name (_tmp9_, _tmp10_);
	_tmp11_ = self->priv->volume_control;
	_tmp12_ = sound_services_volume_control_get_mute ((SoundServicesVolumeControl*) _tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_) {
		SoundWidgetsScale* _tmp14_;
		_tmp14_ = self->priv->volume_scale;
		sound_widgets_scale_set_icon (_tmp14_, "audio-volume-muted-symbolic");
	} else {
		SoundWidgetsScale* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = self->priv->volume_scale;
		_tmp16_ = volume_icon;
		sound_widgets_scale_set_icon (_tmp15_, _tmp16_);
	}
	_g_free0 (volume_icon);
}

static void
sound_indicator_on_mic_mute_change (SoundIndicator* self)
{
	SoundWidgetsScale* _tmp0_;
	SoundServicesVolumeControlPulse* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	SoundDisplayWidget* _tmp4_;
	SoundServicesVolumeControlPulse* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	SoundServicesVolumeControlPulse* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mic_scale;
	_tmp1_ = self->priv->volume_control;
	_tmp2_ = sound_services_volume_control_pulse_get_micMute (_tmp1_);
	_tmp3_ = _tmp2_;
	sound_widgets_scale_set_active (_tmp0_, !_tmp3_);
	_tmp4_ = self->priv->display_widget;
	_tmp5_ = self->priv->volume_control;
	_tmp6_ = sound_services_volume_control_pulse_get_micMute (_tmp5_);
	_tmp7_ = _tmp6_;
	sound_display_widget_set_mic_muted (_tmp4_, _tmp7_);
	_tmp8_ = self->priv->volume_control;
	_tmp9_ = sound_services_volume_control_pulse_get_micMute (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		SoundWidgetsScale* _tmp11_;
		_tmp11_ = self->priv->mic_scale;
		sound_widgets_scale_set_icon (_tmp11_, "indicator-microphone-muted-symbolic");
	} else {
		SoundWidgetsScale* _tmp12_;
		_tmp12_ = self->priv->mic_scale;
		sound_widgets_scale_set_icon (_tmp12_, "indicator-microphone-symbolic");
	}
}

static gboolean
____lambda59_ (SoundIndicator* self)
{
	SoundDisplayWidget* _tmp0_;
	SoundServicesVolumeControlPulse* _tmp1_;
	SoundServicesVolumeControlVolume* _tmp2_;
	SoundServicesVolumeControlVolume* _tmp3_;
	const gchar* _tmp4_;
	gboolean result;
	self->priv->mute_blocks_sound = FALSE;
	self->priv->sound_was_blocked_timeout_id = (guint) 0;
	_tmp0_ = self->priv->display_widget;
	_tmp1_ = self->priv->volume_control;
	_tmp2_ = sound_services_volume_control_get_volume ((SoundServicesVolumeControl*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = sound_indicator_get_volume_icon (self, _tmp3_->volume);
	sound_display_widget_set_icon_name (_tmp0_, _tmp4_);
	result = FALSE;
	return result;
}

static gboolean
_____lambda59__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda59_ ((SoundIndicator*) self);
	return result;
}

static void
sound_indicator_on_is_playing_change (SoundIndicator* self)
{
	SoundServicesVolumeControlPulse* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	SoundServicesVolumeControlPulse* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	SoundDisplayWidget* _tmp6_;
	SoundServicesVolumeControlPulse* _tmp7_;
	SoundServicesVolumeControlVolume* _tmp8_;
	SoundServicesVolumeControlVolume* _tmp9_;
	const gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->volume_control;
	_tmp1_ = sound_services_volume_control_get_mute ((SoundServicesVolumeControl*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		self->priv->mute_blocks_sound = FALSE;
		return;
	}
	_tmp3_ = self->priv->volume_control;
	_tmp4_ = sound_services_volume_control_get_is_playing ((SoundServicesVolumeControl*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		self->priv->mute_blocks_sound = TRUE;
	} else {
		if (self->priv->mute_blocks_sound) {
			if (self->priv->sound_was_blocked_timeout_id > ((guint) 0)) {
				g_source_remove (self->priv->sound_was_blocked_timeout_id);
			}
			self->priv->sound_was_blocked_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, _____lambda59__gsource_func, g_object_ref (self), g_object_unref);
		}
	}
	_tmp6_ = self->priv->display_widget;
	_tmp7_ = self->priv->volume_control;
	_tmp8_ = sound_services_volume_control_get_volume ((SoundServicesVolumeControl*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = sound_indicator_get_volume_icon (self, _tmp9_->volume);
	sound_display_widget_set_icon_name (_tmp6_, _tmp10_);
}

static void
sound_indicator_on_volume_icon_scroll_event (SoundIndicator* self,
                                             GdkEventScroll* e)
{
	gdouble dir = 0.0;
	gdouble _tmp0_ = 0.0;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (e != NULL);
	dir = 0.0;
	_tmp1_ = sound_indicator_handle_scroll_event (self, e, &_tmp0_);
	dir = _tmp0_;
	if (_tmp1_) {
		sound_indicator_handle_change (self, dir, FALSE);
	}
}

static void
sound_indicator_on_mic_icon_scroll_event (SoundIndicator* self,
                                          GdkEventScroll* e)
{
	gdouble dir = 0.0;
	gdouble _tmp0_ = 0.0;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (e != NULL);
	dir = 0.0;
	_tmp1_ = sound_indicator_handle_scroll_event (self, e, &_tmp0_);
	dir = _tmp0_;
	if (_tmp1_) {
		sound_indicator_handle_change (self, dir, TRUE);
	}
}

static void
sound_indicator_update_mic_visibility (SoundIndicator* self)
{
	SoundServicesVolumeControlPulse* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->volume_control;
	_tmp1_ = sound_services_volume_control_get_is_listening ((SoundServicesVolumeControl*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		SoundWidgetsScale* _tmp3_;
		SoundWidgetsScale* _tmp4_;
		GtkSeparator* _tmp5_;
		GtkSeparator* _tmp6_;
		SoundWidgetsDeviceManagerWidget* _tmp7_;
		SoundWidgetsDeviceManagerWidget* _tmp8_;
		SoundDisplayWidget* _tmp9_;
		_tmp3_ = self->priv->mic_scale;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp3_, FALSE);
		_tmp4_ = self->priv->mic_scale;
		gtk_widget_show_all ((GtkWidget*) _tmp4_);
		_tmp5_ = self->priv->mic_separator;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp5_, FALSE);
		_tmp6_ = self->priv->mic_separator;
		gtk_widget_show ((GtkWidget*) _tmp6_);
		_tmp7_ = self->priv->input_device_manager;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp7_, FALSE);
		_tmp8_ = self->priv->input_device_manager;
		gtk_widget_show ((GtkWidget*) _tmp8_);
		_tmp9_ = self->priv->display_widget;
		sound_display_widget_set_show_mic (_tmp9_, TRUE);
	} else {
		SoundWidgetsScale* _tmp10_;
		SoundWidgetsScale* _tmp11_;
		GtkSeparator* _tmp12_;
		GtkSeparator* _tmp13_;
		SoundWidgetsDeviceManagerWidget* _tmp14_;
		SoundWidgetsDeviceManagerWidget* _tmp15_;
		SoundDisplayWidget* _tmp16_;
		_tmp10_ = self->priv->mic_scale;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp10_, TRUE);
		_tmp11_ = self->priv->mic_scale;
		gtk_widget_hide ((GtkWidget*) _tmp11_);
		_tmp12_ = self->priv->mic_separator;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp12_, TRUE);
		_tmp13_ = self->priv->mic_separator;
		gtk_widget_hide ((GtkWidget*) _tmp13_);
		_tmp14_ = self->priv->input_device_manager;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp14_, TRUE);
		_tmp15_ = self->priv->input_device_manager;
		gtk_widget_hide ((GtkWidget*) _tmp15_);
		_tmp16_ = self->priv->display_widget;
		sound_display_widget_set_show_mic (_tmp16_, FALSE);
	}
}

static const gchar*
sound_indicator_get_volume_icon (SoundIndicator* self,
                                 gdouble volume)
{
	gboolean _tmp0_ = FALSE;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (volume <= ((gdouble) 0)) {
		_tmp0_ = TRUE;
	} else {
		SoundServicesVolumeControlPulse* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->volume_control;
		_tmp2_ = sound_services_volume_control_get_mute ((SoundServicesVolumeControl*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	}
	if (_tmp0_) {
		const gchar* _tmp4_ = NULL;
		if (self->priv->mute_blocks_sound) {
			_tmp4_ = "audio-volume-muted-blocking-symbolic";
		} else {
			_tmp4_ = "audio-volume-muted-symbolic";
		}
		result = _tmp4_;
		return result;
	} else {
		if (volume <= 0.3) {
			result = "audio-volume-low-symbolic";
			return result;
		} else {
			if (volume <= 0.7) {
				result = "audio-volume-medium-symbolic";
				return result;
			} else {
				result = "audio-volume-high-symbolic";
				return result;
			}
		}
	}
}

static void
sound_indicator_on_volume_switch_change (SoundIndicator* self)
{
	SoundWidgetsScale* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->volume_scale;
	_tmp1_ = sound_widgets_scale_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		SoundServicesVolumeControlPulse* _tmp3_;
		_tmp3_ = self->priv->volume_control;
		sound_services_volume_control_set_mute ((SoundServicesVolumeControl*) _tmp3_, FALSE);
	} else {
		SoundServicesVolumeControlPulse* _tmp4_;
		_tmp4_ = self->priv->volume_control;
		sound_services_volume_control_set_mute ((SoundServicesVolumeControl*) _tmp4_, TRUE);
	}
}

static void
sound_indicator_on_mic_switch_change (SoundIndicator* self)
{
	SoundWidgetsScale* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mic_scale;
	_tmp1_ = sound_widgets_scale_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		SoundServicesVolumeControlPulse* _tmp3_;
		_tmp3_ = self->priv->volume_control;
		sound_services_volume_control_pulse_set_mic_mute (_tmp3_, FALSE);
	} else {
		SoundServicesVolumeControlPulse* _tmp4_;
		_tmp4_ = self->priv->volume_control;
		sound_services_volume_control_pulse_set_mic_mute (_tmp4_, TRUE);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
sound_indicator_real_get_display_widget (WingpanelIndicator* base)
{
	SoundIndicator * self;
	SoundDisplayWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* result;
	self = (SoundIndicator*) base;
	_tmp0_ = self->priv->display_widget;
	_tmp1_ = _g_object_ref0 ((GtkWidget*) _tmp0_);
	result = _tmp1_;
	return result;
}

static void
_sound_indicator_on_mic_switch_change_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	sound_indicator_on_mic_switch_change ((SoundIndicator*) self);
}

static void
___lambda60_ (SoundIndicator* self)
{
	SoundServicesVolumeControlPulse* _tmp0_;
	GtkAdjustment* _tmp1_;
	_tmp0_ = self->priv->volume_control;
	_tmp1_ = self->priv->mic_adjustment;
	sound_services_volume_control_set_mic_volume ((SoundServicesVolumeControl*) _tmp0_, gtk_adjustment_get_value (_tmp1_));
}

static void
____lambda60__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                            gpointer self)
{
	___lambda60_ ((SoundIndicator*) self);
}

static gboolean
___lambda61_ (SoundIndicator* self,
              GdkEventScroll* e)
{
	gdouble dir = 0.0;
	gdouble _tmp0_ = 0.0;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	dir = 0.0;
	_tmp1_ = sound_indicator_handle_scroll_event (self, e, &_tmp0_);
	dir = _tmp0_;
	if (_tmp1_) {
		sound_indicator_handle_change (self, dir, TRUE);
	}
	result = TRUE;
	return result;
}

static gboolean
____lambda61__gtk_widget_scroll_event (GtkWidget* _sender,
                                       GdkEventScroll* event,
                                       gpointer self)
{
	gboolean result;
	result = ___lambda61_ ((SoundIndicator*) self, event);
	return result;
}

static void
___lambda62_ (SoundIndicator* self)
{
	g_signal_emit_by_name ((WingpanelIndicator*) self, "close");
}

static void
____lambda62__sound_widgets_player_list_close (SoundWidgetsPlayerList* _sender,
                                               gpointer self)
{
	___lambda62_ ((SoundIndicator*) self);
}

static void
___lambda63_ (SoundIndicator* self)
{
	sound_indicator_show_settings (self);
}

static void
____lambda63__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	___lambda63_ ((SoundIndicator*) self);
}

static void
___lambda64_ (SoundIndicator* self)
{
	SoundServicesVolumeControlPulse* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->volume_control;
	_tmp1_ = sound_services_volume_control_get_headphone_plugged ((SoundServicesVolumeControl*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		SoundWidgetsPlayerList* _tmp3_;
		_tmp3_ = self->priv->mpris;
		sound_widgets_player_list_pause_all (_tmp3_);
	}
}

static void
____lambda64__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda64_ ((SoundIndicator*) self);
}

static void
_sound_indicator_play_volume_change_sound_sound_widgets_scale_slider_dropped (SoundWidgetsScale* _sender,
                                                                              gpointer self)
{
	sound_indicator_play_volume_change_sound ((SoundIndicator*) self);
}

static gboolean
___lambda65_ (SoundIndicator* self,
              GdkEventScroll* e)
{
	gdouble dir = 0.0;
	gdouble _tmp0_ = 0.0;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	dir = 0.0;
	_tmp1_ = sound_indicator_handle_scroll_event (self, e, &_tmp0_);
	dir = _tmp0_;
	if (_tmp1_) {
		sound_indicator_handle_change (self, dir, FALSE);
	}
	result = TRUE;
	return result;
}

static gboolean
____lambda65__gtk_widget_scroll_event (GtkWidget* _sender,
                                       GdkEventScroll* event,
                                       gpointer self)
{
	gboolean result;
	result = ___lambda65_ ((SoundIndicator*) self, event);
	return result;
}

static void
_sound_indicator_on_volume_switch_change_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	sound_indicator_on_volume_switch_change ((SoundIndicator*) self);
}

static void
___lambda66_ (SoundIndicator* self)
{
	gdouble val = 0.0;
	GtkAdjustment* _tmp0_;
	SoundServicesVolumeControlVolume* vol = NULL;
	SoundServicesVolumeControlVolume* _tmp1_ = NULL;
	SoundServicesVolumeControlPulse* _tmp2_;
	SoundWidgetsScale* _tmp3_;
	GtkAdjustment* _tmp4_;
	const gchar* _tmp5_;
	_tmp0_ = self->priv->volume_adjustment;
	val = gtk_adjustment_get_value (_tmp0_) * self->priv->max_volume;
	_tmp1_ = sound_services_volume_control_volume_new ();
	_tmp1_->volume = CLAMP (val, 0.0, self->priv->max_volume);
	_tmp1_->reason = SOUND_SERVICES_VOLUME_CONTROL_VOLUME_REASONS_USER_KEYPRESS;
	vol = _tmp1_;
	_tmp2_ = self->priv->volume_control;
	sound_services_volume_control_set_volume ((SoundServicesVolumeControl*) _tmp2_, vol);
	_tmp3_ = self->priv->volume_scale;
	_tmp4_ = self->priv->volume_adjustment;
	_tmp5_ = sound_indicator_get_volume_icon (self, gtk_adjustment_get_value (_tmp4_));
	sound_widgets_scale_set_icon (_tmp3_, _tmp5_);
	_g_object_unref0 (vol);
}

static void
____lambda66__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                            gpointer self)
{
	___lambda66_ ((SoundIndicator*) self);
}

static GtkWidget*
sound_indicator_real_get_widget (WingpanelIndicator* base)
{
	SoundIndicator * self;
	GtkBox* _tmp0_;
	GtkBox* _tmp53_;
	GtkWidget* _tmp54_;
	GtkWidget* result;
	self = (SoundIndicator*) base;
	_tmp0_ = self->priv->main_box;
	if (_tmp0_ == NULL) {
		SoundWidgetsPlayerList* _tmp1_;
		SoundWidgetsScale* _tmp2_;
		SoundServicesVolumeControlPulse* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		GtkAdjustment* _tmp6_;
		SoundServicesVolumeControlPulse* _tmp7_;
		SoundServicesVolumeControlVolume* _tmp8_;
		SoundServicesVolumeControlVolume* _tmp9_;
		SoundWidgetsScale* _tmp10_;
		GtkAdjustment* _tmp11_;
		const gchar* _tmp12_;
		SoundWidgetsScale* _tmp13_;
		SoundServicesVolumeControlPulse* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
		GtkSeparator* _tmp17_;
		GtkModelButton* settings_button = NULL;
		gchar* _tmp18_;
		GtkModelButton* _tmp19_ = NULL;
		GtkBox* _tmp20_;
		gboolean _tmp21_;
		GtkBox* _tmp27_;
		SoundWidgetsScale* _tmp28_;
		GtkBox* _tmp29_;
		SoundWidgetsDeviceManagerWidget* _tmp30_;
		gboolean _tmp31_;
		SoundWidgetsScale* _tmp43_;
		GtkAdjustment* _tmp44_;
		SoundWidgetsScale* _tmp45_;
		SoundWidgetsPlayerList* _tmp46_;
		GtkModelButton* _tmp47_;
		SoundServicesVolumeControlPulse* _tmp48_;
		SoundWidgetsScale* _tmp49_;
		SoundWidgetsScale* _tmp50_;
		SoundWidgetsScale* _tmp51_;
		GtkAdjustment* _tmp52_;
		_tmp1_ = sound_widgets_player_list_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->mpris);
		self->priv->mpris = _tmp1_;
		_tmp2_ = self->priv->volume_scale;
		_tmp3_ = self->priv->volume_control;
		_tmp4_ = sound_services_volume_control_get_mute ((SoundServicesVolumeControl*) _tmp3_);
		_tmp5_ = _tmp4_;
		sound_widgets_scale_set_active (_tmp2_, !_tmp5_);
		_tmp6_ = self->priv->volume_adjustment;
		_tmp7_ = self->priv->volume_control;
		_tmp8_ = sound_services_volume_control_get_volume ((SoundServicesVolumeControl*) _tmp7_);
		_tmp9_ = _tmp8_;
		gtk_adjustment_set_value (_tmp6_, _tmp9_->volume);
		_tmp10_ = self->priv->volume_scale;
		_tmp11_ = self->priv->volume_adjustment;
		_tmp12_ = sound_indicator_get_volume_icon (self, gtk_adjustment_get_value (_tmp11_));
		sound_widgets_scale_set_icon (_tmp10_, _tmp12_);
		sound_indicator_set_max_volume (self);
		_tmp13_ = self->priv->mic_scale;
		_tmp14_ = self->priv->volume_control;
		_tmp15_ = sound_services_volume_control_pulse_get_micMute (_tmp14_);
		_tmp16_ = _tmp15_;
		sound_widgets_scale_set_active (_tmp13_, !_tmp16_);
		_tmp17_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		g_object_ref_sink (_tmp17_);
		_g_object_unref0 (self->priv->mic_separator);
		self->priv->mic_separator = _tmp17_;
		sound_indicator_update_mic_visibility (self);
		_tmp18_ = g_strdup (_ ("Sound Settings…"));
		_tmp19_ = (GtkModelButton*) gtk_model_button_new ();
		g_object_set (_tmp19_, "text", _tmp18_, NULL);
		_g_free0 (_tmp18_);
		gtk_widget_set_margin_top ((GtkWidget*) _tmp19_, 3);
		g_object_ref_sink (_tmp19_);
		settings_button = _tmp19_;
		_tmp20_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp20_);
		_g_object_unref0 (self->priv->main_box);
		self->priv->main_box = _tmp20_;
		_tmp21_ = self->priv->_is_in_session;
		if (_tmp21_) {
			GtkBox* _tmp22_;
			SoundWidgetsPlayerList* _tmp23_;
			GtkBox* _tmp24_;
			GtkSeparator* _tmp25_;
			GtkSeparator* _tmp26_;
			_tmp22_ = self->priv->main_box;
			_tmp23_ = self->priv->mpris;
			gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp23_);
			_tmp24_ = self->priv->main_box;
			_tmp25_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
			g_object_ref_sink (_tmp25_);
			_tmp26_ = _tmp25_;
			gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp26_);
			_g_object_unref0 (_tmp26_);
		}
		_tmp27_ = self->priv->main_box;
		_tmp28_ = self->priv->volume_scale;
		gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
		_tmp29_ = self->priv->main_box;
		_tmp30_ = self->priv->output_device_manager;
		gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
		_tmp31_ = self->priv->_is_in_session;
		if (_tmp31_) {
			GtkBox* _tmp32_;
			GtkSeparator* _tmp33_;
			GtkSeparator* _tmp34_;
			GtkBox* _tmp35_;
			SoundWidgetsScale* _tmp36_;
			GtkBox* _tmp37_;
			SoundWidgetsDeviceManagerWidget* _tmp38_;
			GtkBox* _tmp39_;
			GtkSeparator* _tmp40_;
			GtkBox* _tmp41_;
			GtkModelButton* _tmp42_;
			_tmp32_ = self->priv->main_box;
			_tmp33_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
			g_object_ref_sink (_tmp33_);
			_tmp34_ = _tmp33_;
			gtk_container_add ((GtkContainer*) _tmp32_, (GtkWidget*) _tmp34_);
			_g_object_unref0 (_tmp34_);
			_tmp35_ = self->priv->main_box;
			_tmp36_ = self->priv->mic_scale;
			gtk_container_add ((GtkContainer*) _tmp35_, (GtkWidget*) _tmp36_);
			_tmp37_ = self->priv->main_box;
			_tmp38_ = self->priv->input_device_manager;
			gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _tmp38_);
			_tmp39_ = self->priv->main_box;
			_tmp40_ = self->priv->mic_separator;
			gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
			_tmp41_ = self->priv->main_box;
			_tmp42_ = settings_button;
			gtk_container_add ((GtkContainer*) _tmp41_, (GtkWidget*) _tmp42_);
		}
		_tmp43_ = self->priv->mic_scale;
		g_signal_connect_object ((GObject*) _tmp43_, "notify::active", (GCallback) _sound_indicator_on_mic_switch_change_g_object_notify, self, 0);
		_tmp44_ = self->priv->mic_adjustment;
		g_signal_connect_object (_tmp44_, "value-changed", (GCallback) ____lambda60__gtk_adjustment_value_changed, self, 0);
		_tmp45_ = self->priv->mic_scale;
		g_signal_connect_object ((GtkWidget*) _tmp45_, "scroll-event", (GCallback) ____lambda61__gtk_widget_scroll_event, self, G_CONNECT_AFTER);
		_tmp46_ = self->priv->mpris;
		g_signal_connect_object (_tmp46_, "close", (GCallback) ____lambda62__sound_widgets_player_list_close, self, 0);
		_tmp47_ = settings_button;
		g_signal_connect_object ((GtkButton*) _tmp47_, "clicked", (GCallback) ____lambda63__gtk_button_clicked, self, 0);
		_tmp48_ = self->priv->volume_control;
		g_signal_connect_object ((GObject*) _tmp48_, "notify::headphone-plugged", (GCallback) ____lambda64__g_object_notify, self, 0);
		_tmp49_ = self->priv->volume_scale;
		g_signal_connect_object (_tmp49_, "slider-dropped", (GCallback) _sound_indicator_play_volume_change_sound_sound_widgets_scale_slider_dropped, self, 0);
		_tmp50_ = self->priv->volume_scale;
		g_signal_connect_object ((GtkWidget*) _tmp50_, "scroll-event", (GCallback) ____lambda65__gtk_widget_scroll_event, self, G_CONNECT_AFTER);
		_tmp51_ = self->priv->volume_scale;
		g_signal_connect_object ((GObject*) _tmp51_, "notify::active", (GCallback) _sound_indicator_on_volume_switch_change_g_object_notify, self, 0);
		_tmp52_ = self->priv->volume_adjustment;
		g_signal_connect_object (_tmp52_, "value-changed", (GCallback) ____lambda66__gtk_adjustment_value_changed, self, 0);
		_g_object_unref0 (settings_button);
	}
	_tmp53_ = self->priv->main_box;
	_tmp54_ = _g_object_ref0 ((GtkWidget*) _tmp53_);
	result = _tmp54_;
	return result;
}

static gboolean
sound_indicator_handle_scroll_event (SoundIndicator* self,
                                     GdkEventScroll* e,
                                     gdouble* dir)
{
	gdouble _vala_dir = 0.0;
	gboolean natural_scroll = FALSE;
	GdkInputSource event_source = 0;
	GdkDevice* _tmp0_;
	GdkInputSource _tmp1_;
	GdkInputSource _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_vala_dir = 0.0;
	_tmp0_ = gdk_event_get_source_device ((GdkEvent*) e);
	g_object_get (_tmp0_, "input-source", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	event_source = _tmp2_;
	if (event_source == GDK_SOURCE_MOUSE) {
		gboolean _tmp3_;
		_tmp3_ = self->priv->_natural_scroll_mouse;
		natural_scroll = _tmp3_;
	} else {
		if (event_source == GDK_SOURCE_TOUCHPAD) {
			gboolean _tmp4_;
			_tmp4_ = self->priv->_natural_scroll_touchpad;
			natural_scroll = _tmp4_;
		} else {
			natural_scroll = FALSE;
		}
	}
	switch (e->direction) {
		case GDK_SCROLL_SMOOTH:
		{
			gdouble abs_x = 0.0;
			gdouble abs_y = 0.0;
			abs_x = MAX (fabs (e->delta_x), 0.0001);
			abs_y = MAX (fabs (e->delta_y), 0.0001);
			if ((abs_y / abs_x) > 2.0) {
				self->priv->total_y_delta = self->priv->total_y_delta + e->delta_y;
			} else {
				if ((abs_x / abs_y) > 2.0) {
					self->priv->total_x_delta = self->priv->total_x_delta + e->delta_x;
				}
			}
			break;
		}
		case GDK_SCROLL_UP:
		{
			self->priv->total_y_delta = -1.0;
			break;
		}
		case GDK_SCROLL_DOWN:
		{
			self->priv->total_y_delta = 1.0;
			break;
		}
		case GDK_SCROLL_LEFT:
		{
			self->priv->total_x_delta = -1.0;
			break;
		}
		case GDK_SCROLL_RIGHT:
		{
			self->priv->total_x_delta = 1.0;
			break;
		}
		default:
		{
			break;
		}
	}
	if (fabs (self->priv->total_y_delta) > 0.5) {
		gdouble _tmp5_ = 0.0;
		if (natural_scroll) {
			_tmp5_ = self->priv->total_y_delta;
		} else {
			_tmp5_ = -self->priv->total_y_delta;
		}
		_vala_dir = _tmp5_;
	} else {
		if (fabs (self->priv->total_x_delta) > 0.5) {
			gdouble _tmp6_ = 0.0;
			if (natural_scroll) {
				_tmp6_ = -self->priv->total_x_delta;
			} else {
				_tmp6_ = self->priv->total_x_delta;
			}
			_vala_dir = _tmp6_;
		}
	}
	if (fabs (_vala_dir) > 0.0) {
		self->priv->total_y_delta = 0.0;
		self->priv->total_x_delta = 0.0;
		result = TRUE;
		if (dir) {
			*dir = _vala_dir;
		}
		return result;
	}
	result = FALSE;
	if (dir) {
		*dir = _vala_dir;
	}
	return result;
}

static void
sound_indicator_handle_change (SoundIndicator* self,
                               gdouble change,
                               gboolean is_mic)
{
	gdouble v = 0.0;
	gdouble new_v = 0.0;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	if (is_mic) {
		SoundServicesVolumeControlPulse* _tmp0_;
		gdouble _tmp1_;
		gdouble _tmp2_;
		_tmp0_ = self->priv->volume_control;
		_tmp1_ = sound_services_volume_control_get_mic_volume ((SoundServicesVolumeControl*) _tmp0_);
		_tmp2_ = _tmp1_;
		v = _tmp2_;
	} else {
		SoundServicesVolumeControlPulse* _tmp3_;
		SoundServicesVolumeControlVolume* _tmp4_;
		SoundServicesVolumeControlVolume* _tmp5_;
		_tmp3_ = self->priv->volume_control;
		_tmp4_ = sound_services_volume_control_get_volume ((SoundServicesVolumeControl*) _tmp3_);
		_tmp5_ = _tmp4_;
		v = _tmp5_->volume;
	}
	_tmp6_ = self->priv->_volume_step;
	new_v = CLAMP (v + ((((gdouble) _tmp6_) * change) / 100.0), 0.0, self->priv->max_volume);
	if (new_v == v) {
		return;
	}
	if (is_mic) {
		SoundServicesVolumeControlPulse* _tmp7_;
		_tmp7_ = self->priv->volume_control;
		sound_services_volume_control_set_mic_volume ((SoundServicesVolumeControl*) _tmp7_, new_v);
	} else {
		SoundServicesVolumeControlVolume* vol = NULL;
		SoundServicesVolumeControlVolume* _tmp8_;
		SoundServicesVolumeControlVolume* _tmp9_;
		SoundServicesVolumeControlVolume* _tmp10_;
		SoundServicesVolumeControlPulse* _tmp11_;
		SoundServicesVolumeControlVolume* _tmp12_;
		_tmp8_ = sound_services_volume_control_volume_new ();
		vol = _tmp8_;
		_tmp9_ = vol;
		_tmp9_->reason = SOUND_SERVICES_VOLUME_CONTROL_VOLUME_REASONS_USER_KEYPRESS;
		_tmp10_ = vol;
		_tmp10_->volume = new_v;
		_tmp11_ = self->priv->volume_control;
		_tmp12_ = vol;
		sound_services_volume_control_set_volume ((SoundServicesVolumeControl*) _tmp11_, _tmp12_);
		_g_object_unref0 (vol);
	}
	sound_indicator_notify_change (self, is_mic);
}

static void
sound_indicator_real_opened (WingpanelIndicator* base)
{
	SoundIndicator * self;
	SoundWidgetsPlayerList* _tmp0_;
	NotifyNotification* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = (SoundIndicator*) base;
	self->priv->open = TRUE;
	_tmp0_ = self->priv->mpris;
	sound_widgets_player_list_update_default_player (_tmp0_);
	_tmp1_ = self->priv->notification;
	if (_tmp1_ != NULL) {
		{
			NotifyNotification* _tmp2_;
			_tmp2_ = self->priv->notification;
			notify_notification_close (_tmp2_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = e;
			_tmp4_ = _tmp3_->message;
			g_warning ("Indicator.vala:588: Unable to close sound notification: %s", _tmp4_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_object_unref0 (self->priv->notification);
		self->priv->notification = NULL;
	}
}

static void
sound_indicator_real_closed (WingpanelIndicator* base)
{
	SoundIndicator * self;
	self = (SoundIndicator*) base;
	self->priv->open = FALSE;
	_g_object_unref0 (self->priv->notification);
	self->priv->notification = NULL;
}

static void
sound_indicator_show_settings (SoundIndicator* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name ((WingpanelIndicator*) self, "close");
	{
		g_app_info_launch_default_for_uri ("settings://sound", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("Indicator.vala:606: %s\n", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SoundIndicator* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
__lambda58_ (Block1Data* _data1_)
{
	SoundIndicator* self;
	gboolean notification_showing = FALSE;
	gboolean result;
	self = _data1_->self;
	notification_showing = FALSE;
	if (!self->priv->open) {
		notification_showing = sound_indicator_show_notification (self, _data1_->is_mic);
	}
	if (!notification_showing) {
		sound_indicator_play_volume_change_sound (self);
	}
	self->priv->notify_timeout_id = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
___lambda58__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda58_ (self);
	return result;
}

static void
sound_indicator_notify_change (SoundIndicator* self,
                               gboolean is_mic)
{
	Block1Data* _data1_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->is_mic = is_mic;
	if (self->priv->notify_timeout_id > ((guint) 0)) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	self->priv->notify_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 50, ___lambda58__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
sound_indicator_play_volume_change_sound (SoundIndicator* self)
{
	ca_proplist* props = NULL;
	ca_proplist* _tmp0_ = NULL;
	ca_context* _tmp1_;
	g_return_if_fail (self != NULL);
	ca_proplist_create (&_tmp0_);
	_ca_proplist_destroy0 (props);
	props = _tmp0_;
	ca_proplist_sets (props, CA_PROP_CANBERRA_CACHE_CONTROL, "volatile");
	ca_proplist_sets (props, CA_PROP_EVENT_ID, "audio-volume-change");
	_tmp1_ = self->priv->ca_context;
	ca_context_play_full (_tmp1_, (guint32) 0, props, NULL, NULL);
	_ca_proplist_destroy0 (props);
}

static gboolean
sound_indicator_show_notification (SoundIndicator* self,
                                   gboolean is_mic)
{
	NotifyNotification* _tmp0_;
	NotifyNotification* _tmp5_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->notification;
	if (_tmp0_ == NULL) {
		NotifyNotification* _tmp1_;
		NotifyNotification* _tmp2_;
		GVariant* _tmp3_;
		GVariant* _tmp4_;
		_tmp1_ = notify_notification_new ("indicator-sound", "", "");
		_g_object_unref0 (self->priv->notification);
		self->priv->notification = _tmp1_;
		_tmp2_ = self->priv->notification;
		_tmp3_ = g_variant_new_string ("indicator-sound");
		g_variant_ref_sink (_tmp3_);
		_tmp4_ = _tmp3_;
		notify_notification_set_hint (_tmp2_, "x-canonical-private-synchronous", _tmp4_);
		_g_variant_unref0 (_tmp4_);
	}
	_tmp5_ = self->priv->notification;
	if (_tmp5_ != NULL) {
		gchar* icon = NULL;
		NotifyNotification* _tmp18_;
		const gchar* _tmp19_;
		gint32 volume = 0;
		NotifyNotification* _tmp26_;
		GVariant* _tmp27_;
		GVariant* _tmp28_;
		if (is_mic) {
			gboolean _tmp6_ = FALSE;
			SoundServicesVolumeControlPulse* _tmp7_;
			gdouble _tmp8_;
			gdouble _tmp9_;
			_tmp7_ = self->priv->volume_control;
			_tmp8_ = sound_services_volume_control_get_mic_volume ((SoundServicesVolumeControl*) _tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_ <= ((gdouble) 0)) {
				_tmp6_ = TRUE;
			} else {
				SoundServicesVolumeControlPulse* _tmp10_;
				gboolean _tmp11_;
				gboolean _tmp12_;
				_tmp10_ = self->priv->volume_control;
				_tmp11_ = sound_services_volume_control_pulse_get_micMute (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp6_ = _tmp12_;
			}
			if (_tmp6_) {
				gchar* _tmp13_;
				_tmp13_ = g_strdup ("microphone-sensitivity-muted-symbolic");
				_g_free0 (icon);
				icon = _tmp13_;
			} else {
				gchar* _tmp14_;
				_tmp14_ = g_strdup ("audio-input-microphone-symbolic");
				_g_free0 (icon);
				icon = _tmp14_;
			}
		} else {
			GtkAdjustment* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp15_ = self->priv->volume_adjustment;
			_tmp16_ = sound_indicator_get_volume_icon (self, gtk_adjustment_get_value (_tmp15_));
			_tmp17_ = g_strdup (_tmp16_);
			_g_free0 (icon);
			icon = _tmp17_;
		}
		_tmp18_ = self->priv->notification;
		_tmp19_ = icon;
		notify_notification_update (_tmp18_, "indicator-sound", "", _tmp19_);
		if (is_mic) {
			SoundServicesVolumeControlPulse* _tmp20_;
			gdouble _tmp21_;
			gdouble _tmp22_;
			_tmp20_ = self->priv->volume_control;
			_tmp21_ = sound_services_volume_control_get_mic_volume ((SoundServicesVolumeControl*) _tmp20_);
			_tmp22_ = _tmp21_;
			volume = (gint32) round ((_tmp22_ / self->priv->max_volume) * 100.0);
		} else {
			SoundServicesVolumeControlPulse* _tmp23_;
			SoundServicesVolumeControlVolume* _tmp24_;
			SoundServicesVolumeControlVolume* _tmp25_;
			_tmp23_ = self->priv->volume_control;
			_tmp24_ = sound_services_volume_control_get_volume ((SoundServicesVolumeControl*) _tmp23_);
			_tmp25_ = _tmp24_;
			volume = (gint32) round ((_tmp25_->volume / self->priv->max_volume) * 100.0);
		}
		_tmp26_ = self->priv->notification;
		_tmp27_ = g_variant_new_int32 (volume);
		g_variant_ref_sink (_tmp27_);
		_tmp28_ = _tmp27_;
		notify_notification_set_hint (_tmp26_, "value", _tmp28_);
		_g_variant_unref0 (_tmp28_);
		{
			NotifyNotification* _tmp29_;
			_tmp29_ = self->priv->notification;
			notify_notification_show (_tmp29_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp30_;
			const gchar* _tmp31_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp30_ = e;
			_tmp31_ = _tmp30_->message;
			g_warning ("Indicator.vala:676: Unable to show sound notification: %s", _tmp31_);
			_g_object_unref0 (self->priv->notification);
			self->priv->notification = NULL;
			result = FALSE;
			_g_error_free0 (e);
			_g_free0 (icon);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp32_ = FALSE;
			_g_free0 (icon);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp32_;
		}
		_g_free0 (icon);
	} else {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static void
sound_indicator_update_tooltip (SoundIndicator* self)
{
	gdouble _tmp0_ = 0.0;
	SoundServicesVolumeControlPulse* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gchar* description = NULL;
	gchar* _tmp7_;
	const gchar* _tmp8_ = NULL;
	SoundServicesVolumeControlPulse* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gchar* accel_label = NULL;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	SoundDisplayWidget* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->volume_control;
	_tmp2_ = sound_services_volume_control_get_mute ((SoundServicesVolumeControl*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = (gdouble) 0;
	} else {
		SoundServicesVolumeControlPulse* _tmp4_;
		SoundServicesVolumeControlVolume* _tmp5_;
		SoundServicesVolumeControlVolume* _tmp6_;
		_tmp4_ = self->priv->volume_control;
		_tmp5_ = sound_services_volume_control_get_volume ((SoundServicesVolumeControl*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_->volume * 100;
	}
	_tmp7_ = g_strdup_printf (_ ("Volume: %.0f%%"), _tmp0_);
	description = _tmp7_;
	_tmp9_ = self->priv->volume_control;
	_tmp10_ = sound_services_volume_control_get_mute ((SoundServicesVolumeControl*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		_tmp8_ = _ ("Middle-click to unmute");
	} else {
		_tmp8_ = _ ("Middle-click to mute");
	}
	_tmp12_ = g_strdup (_tmp8_);
	accel_label = _tmp12_;
	_tmp13_ = accel_label;
	_tmp14_ = g_strdup_printf (GRANITE_TOOLTIP_SECONDARY_TEXT_MARKUP, _tmp13_);
	_g_free0 (accel_label);
	accel_label = _tmp14_;
	_tmp15_ = self->priv->display_widget;
	_tmp16_ = description;
	_tmp17_ = accel_label;
	_tmp18_ = g_strdup_printf ("%s\n%s", _tmp16_, _tmp17_);
	_tmp19_ = _tmp18_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp15_, _tmp19_);
	_g_free0 (_tmp19_);
	_g_free0 (accel_label);
	_g_free0 (description);
}

gboolean
sound_indicator_get_is_in_session (SoundIndicator* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_in_session;
	return result;
}

static void
sound_indicator_set_is_in_session (SoundIndicator* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_indicator_get_is_in_session (self);
	if (old_value != value) {
		self->priv->_is_in_session = value;
		g_object_notify_by_pspec ((GObject *) self, sound_indicator_properties[SOUND_INDICATOR_IS_IN_SESSION_PROPERTY]);
	}
}

gboolean
sound_indicator_get_natural_scroll_touchpad (SoundIndicator* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_natural_scroll_touchpad;
	return result;
}

void
sound_indicator_set_natural_scroll_touchpad (SoundIndicator* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_indicator_get_natural_scroll_touchpad (self);
	if (old_value != value) {
		self->priv->_natural_scroll_touchpad = value;
		g_object_notify_by_pspec ((GObject *) self, sound_indicator_properties[SOUND_INDICATOR_NATURAL_SCROLL_TOUCHPAD_PROPERTY]);
	}
}

gboolean
sound_indicator_get_natural_scroll_mouse (SoundIndicator* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_natural_scroll_mouse;
	return result;
}

void
sound_indicator_set_natural_scroll_mouse (SoundIndicator* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_indicator_get_natural_scroll_mouse (self);
	if (old_value != value) {
		self->priv->_natural_scroll_mouse = value;
		g_object_notify_by_pspec ((GObject *) self, sound_indicator_properties[SOUND_INDICATOR_NATURAL_SCROLL_MOUSE_PROPERTY]);
	}
}

gint
sound_indicator_get_volume_step (SoundIndicator* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_volume_step;
	return result;
}

void
sound_indicator_set_volume_step (SoundIndicator* self,
                                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_indicator_get_volume_step (self);
	if (old_value != value) {
		self->priv->_volume_step = value;
		g_object_notify_by_pspec ((GObject *) self, sound_indicator_properties[SOUND_INDICATOR_VOLUME_STEP_PROPERTY]);
	}
}

static void
_sound_indicator_on_volume_change_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	sound_indicator_on_volume_change ((SoundIndicator*) self);
}

static void
_sound_indicator_on_mic_volume_change_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	sound_indicator_on_mic_volume_change ((SoundIndicator*) self);
}

static void
_sound_indicator_on_mute_change_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	sound_indicator_on_mute_change ((SoundIndicator*) self);
}

static void
_sound_indicator_on_mic_mute_change_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	sound_indicator_on_mic_mute_change ((SoundIndicator*) self);
}

static void
_sound_indicator_on_is_playing_change_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	sound_indicator_on_is_playing_change ((SoundIndicator*) self);
}

static void
_sound_indicator_update_mic_visibility_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	sound_indicator_update_mic_visibility ((SoundIndicator*) self);
}

static void
_sound_indicator_update_tooltip_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	sound_indicator_update_tooltip ((SoundIndicator*) self);
}

static void
_sound_indicator_set_max_volume_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	sound_indicator_set_max_volume ((SoundIndicator*) self);
}

static void
_sound_services_volume_control_pulse_toggle_mute_sound_display_widget_volume_press_event (SoundDisplayWidget* _sender,
                                                                                          gpointer self)
{
	sound_services_volume_control_pulse_toggle_mute ((SoundServicesVolumeControlPulse*) self);
}

static void
_sound_services_volume_control_pulse_toggle_mic_mute_sound_display_widget_mic_press_event (SoundDisplayWidget* _sender,
                                                                                           gpointer self)
{
	sound_services_volume_control_pulse_toggle_mic_mute ((SoundServicesVolumeControlPulse*) self);
}

static void
_sound_indicator_on_volume_icon_scroll_event_sound_display_widget_volume_scroll_event (SoundDisplayWidget* _sender,
                                                                                       GdkEventScroll* e,
                                                                                       gpointer self)
{
	sound_indicator_on_volume_icon_scroll_event ((SoundIndicator*) self, e);
}

static void
_sound_indicator_on_mic_icon_scroll_event_sound_display_widget_mic_scroll_event (SoundDisplayWidget* _sender,
                                                                                 GdkEventScroll* e,
                                                                                 gpointer self)
{
	sound_indicator_on_mic_icon_scroll_event ((SoundIndicator*) self, e);
}

static void
_sound_indicator___lambda67_ (SoundIndicator* self,
                              GObject* obj,
                              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		ShellKeyGrabber* _tmp0_ = NULL;
		ShellKeyGrabber* _tmp1_;
		ShellKeyGrabber* _tmp2_;
		ShellKeyGrabber* _tmp3_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (ShellKeyGrabber*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (ShellKeyGrabber*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->key_grabber);
		self->priv->key_grabber = _tmp3_;
		sound_indicator_setup_grabs (self);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("Indicator.vala:149: %s", _tmp5_);
		_g_object_unref0 (self->priv->key_grabber);
		self->priv->key_grabber = NULL;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__sound_indicator___lambda67__gasync_ready_callback (GObject* source_object,
                                                     GAsyncResult* res,
                                                     gpointer self)
{
	_sound_indicator___lambda67_ ((SoundIndicator*) self, source_object, res);
	g_object_unref (self);
}

static void
_sound_indicator___lambda68_ (SoundIndicator* self,
                              const gchar* key)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ShellKeyGrabber* _tmp2_;
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "volume-up") != 0) {
		_tmp1_ = g_strcmp0 (key, "volume-down") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = g_strcmp0 (key, "volume-mute") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp2_ = self->priv->key_grabber;
	if (_tmp2_ != NULL) {
		sound_indicator_ungrab_keybindings (self);
		sound_indicator_setup_grabs (self);
	}
}

static void
__sound_indicator___lambda68__g_settings_changed (GSettings* _sender,
                                                  const gchar* key,
                                                  gpointer self)
{
	_sound_indicator___lambda68_ ((SoundIndicator*) self, key);
}

static GObject *
sound_indicator_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SoundIndicator * self;
	GSettings* touchpad_settings = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* mouse_settings = NULL;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* gnome_settings = NULL;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GtkIconTheme* _tmp6_;
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp7_;
	GtkCssProvider* _tmp8_;
	GdkScreen* _tmp9_;
	GtkCssProvider* _tmp10_;
	SoundDisplayWidget* _tmp11_;
	SoundServicesVolumeControlPulse* _tmp12_;
	SoundServicesVolumeControlPulse* _tmp13_;
	SoundServicesVolumeControlPulse* _tmp14_;
	SoundServicesVolumeControlPulse* _tmp15_;
	SoundServicesVolumeControlPulse* _tmp16_;
	SoundServicesVolumeControlPulse* _tmp17_;
	SoundServicesVolumeControlPulse* _tmp18_;
	SoundServicesVolumeControlPulse* _tmp19_;
	SoundServicesVolumeControlPulse* _tmp20_;
	SoundWidgetsDeviceManagerWidget* _tmp21_ = NULL;
	SoundWidgetsDeviceManagerWidget* _tmp22_ = NULL;
	GSettings* _tmp23_;
	gchar* locale = NULL;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	SoundDisplayWidget* _tmp26_;
	SoundServicesVolumeControlPulse* _tmp27_;
	SoundDisplayWidget* _tmp28_;
	SoundServicesVolumeControlPulse* _tmp29_;
	SoundDisplayWidget* _tmp30_;
	SoundServicesVolumeControlPulse* _tmp31_;
	SoundServicesVolumeControlVolume* _tmp32_;
	SoundServicesVolumeControlVolume* _tmp33_;
	const gchar* _tmp34_;
	SoundDisplayWidget* _tmp35_;
	SoundDisplayWidget* _tmp36_;
	GtkAdjustment* _tmp37_;
	GtkAdjustment* _tmp38_;
	GtkAdjustment* _tmp39_;
	SoundWidgetsScale* _tmp40_;
	GtkAdjustment* _tmp41_;
	SoundWidgetsScale* _tmp42_;
	ca_context* _tmp43_;
	ca_context* _tmp44_;
	const gchar* _tmp45_;
	ca_context* _tmp46_;
	GSettings* _tmp47_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (sound_indicator_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TYPE_INDICATOR, SoundIndicator);
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = g_settings_new ("org.gnome.desktop.peripherals.touchpad");
	touchpad_settings = _tmp0_;
	_tmp1_ = touchpad_settings;
	g_settings_bind (_tmp1_, "natural-scroll", (GObject*) self, "natural-scroll-touchpad", G_SETTINGS_BIND_DEFAULT);
	_tmp2_ = g_settings_new ("org.gnome.desktop.peripherals.mouse");
	mouse_settings = _tmp2_;
	_tmp3_ = mouse_settings;
	g_settings_bind (_tmp3_, "natural-scroll", (GObject*) self, "natural-scroll-mouse", G_SETTINGS_BIND_DEFAULT);
	_tmp4_ = g_settings_new ("org.gnome.settings-daemon.plugins.media-keys");
	gnome_settings = _tmp4_;
	_tmp5_ = gnome_settings;
	g_settings_bind (_tmp5_, "volume-step", (GObject*) self, "volume-step", G_SETTINGS_BIND_DEFAULT);
	wingpanel_indicator_set_visible ((WingpanelIndicator*) self, TRUE);
	_tmp6_ = gtk_icon_theme_get_default ();
	gtk_icon_theme_add_resource_path (_tmp6_, "/org/elementary/wingpanel/icons");
	_tmp7_ = gtk_css_provider_new ();
	provider = _tmp7_;
	_tmp8_ = provider;
	gtk_css_provider_load_from_resource (_tmp8_, "io/elementary/wingpanel/sound/indicator.css");
	_tmp9_ = gdk_screen_get_default ();
	_tmp10_ = provider;
	gtk_style_context_add_provider_for_screen (_tmp9_, (GtkStyleProvider*) _tmp10_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp11_ = sound_display_widget_new ();
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->display_widget);
	self->priv->display_widget = _tmp11_;
	_tmp12_ = sound_services_volume_control_pulse_new ();
	_g_object_unref0 (self->priv->volume_control);
	self->priv->volume_control = _tmp12_;
	_tmp13_ = self->priv->volume_control;
	g_signal_connect_object ((GObject*) _tmp13_, "notify::volume", (GCallback) _sound_indicator_on_volume_change_g_object_notify, self, 0);
	_tmp14_ = self->priv->volume_control;
	g_signal_connect_object ((GObject*) _tmp14_, "notify::mic-volume", (GCallback) _sound_indicator_on_mic_volume_change_g_object_notify, self, 0);
	_tmp15_ = self->priv->volume_control;
	g_signal_connect_object ((GObject*) _tmp15_, "notify::mute", (GCallback) _sound_indicator_on_mute_change_g_object_notify, self, 0);
	_tmp16_ = self->priv->volume_control;
	g_signal_connect_object ((GObject*) _tmp16_, "notify::micMute", (GCallback) _sound_indicator_on_mic_mute_change_g_object_notify, self, 0);
	_tmp17_ = self->priv->volume_control;
	g_signal_connect_object ((GObject*) _tmp17_, "notify::is-playing", (GCallback) _sound_indicator_on_is_playing_change_g_object_notify, self, 0);
	_tmp18_ = self->priv->volume_control;
	g_signal_connect_object ((GObject*) _tmp18_, "notify::is-listening", (GCallback) _sound_indicator_update_mic_visibility_g_object_notify, self, 0);
	_tmp19_ = self->priv->volume_control;
	g_signal_connect_object ((GObject*) _tmp19_, "notify::volume", (GCallback) _sound_indicator_update_tooltip_g_object_notify, self, 0);
	_tmp20_ = self->priv->volume_control;
	g_signal_connect_object ((GObject*) _tmp20_, "notify::mute", (GCallback) _sound_indicator_update_tooltip_g_object_notify, self, 0);
	_tmp21_ = sound_widgets_device_manager_widget_new ();
	sound_widgets_device_manager_widget_set_direction (_tmp21_, PA_DIRECTION_OUTPUT);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->output_device_manager);
	self->priv->output_device_manager = _tmp21_;
	_tmp22_ = sound_widgets_device_manager_widget_new ();
	sound_widgets_device_manager_widget_set_direction (_tmp22_, PA_DIRECTION_INPUT);
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->input_device_manager);
	self->priv->input_device_manager = _tmp22_;
	notify_init ("wingpanel-indicator-sound");
	_tmp23_ = sound_indicator_settings;
	g_signal_connect_object ((GObject*) _tmp23_, "notify::max-volume", (GCallback) _sound_indicator_set_max_volume_g_object_notify, self, 0);
	_tmp24_ = setlocale (LC_MESSAGES, NULL);
	_tmp25_ = g_strdup (_tmp24_);
	locale = _tmp25_;
	_tmp26_ = self->priv->display_widget;
	_tmp27_ = self->priv->volume_control;
	g_signal_connect_object (_tmp26_, "volume-press-event", (GCallback) _sound_services_volume_control_pulse_toggle_mute_sound_display_widget_volume_press_event, _tmp27_, 0);
	_tmp28_ = self->priv->display_widget;
	_tmp29_ = self->priv->volume_control;
	g_signal_connect_object (_tmp28_, "mic-press-event", (GCallback) _sound_services_volume_control_pulse_toggle_mic_mute_sound_display_widget_mic_press_event, _tmp29_, 0);
	_tmp30_ = self->priv->display_widget;
	_tmp31_ = self->priv->volume_control;
	_tmp32_ = sound_services_volume_control_get_volume ((SoundServicesVolumeControl*) _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = sound_indicator_get_volume_icon (self, _tmp33_->volume);
	sound_display_widget_set_icon_name (_tmp30_, _tmp34_);
	_tmp35_ = self->priv->display_widget;
	g_signal_connect_object (_tmp35_, "volume-scroll-event", (GCallback) _sound_indicator_on_volume_icon_scroll_event_sound_display_widget_volume_scroll_event, self, G_CONNECT_AFTER);
	_tmp36_ = self->priv->display_widget;
	g_signal_connect_object (_tmp36_, "mic-scroll-event", (GCallback) _sound_indicator_on_mic_icon_scroll_event_sound_display_widget_mic_scroll_event, self, G_CONNECT_AFTER);
	_tmp37_ = gtk_adjustment_new ((gdouble) 0, (gdouble) 0, self->priv->max_volume, 0.01, (gdouble) 0, (gdouble) 0);
	g_object_ref_sink (_tmp37_);
	_g_object_unref0 (self->priv->volume_adjustment);
	self->priv->volume_adjustment = _tmp37_;
	_tmp38_ = gtk_adjustment_new ((gdouble) 0, (gdouble) 0, (gdouble) 1, 0.01, (gdouble) 0, (gdouble) 0);
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->priv->mic_adjustment);
	self->priv->mic_adjustment = _tmp38_;
	_tmp39_ = self->priv->volume_adjustment;
	_tmp40_ = sound_widgets_scale_new (_tmp39_);
	g_object_ref_sink (_tmp40_);
	_g_object_unref0 (self->priv->volume_scale);
	self->priv->volume_scale = _tmp40_;
	_tmp41_ = self->priv->mic_adjustment;
	_tmp42_ = sound_widgets_scale_new (_tmp41_);
	g_object_ref_sink (_tmp42_);
	_g_object_unref0 (self->priv->mic_scale);
	self->priv->mic_scale = _tmp42_;
	_tmp43_ = ca_gtk_context_get ();
	self->priv->ca_context = _tmp43_;
	_tmp44_ = self->priv->ca_context;
	_tmp45_ = locale;
	ca_context_change_props (_tmp44_, CA_PROP_APPLICATION_NAME, "indicator-sound", CA_PROP_APPLICATION_ID, "wingpanel-indicator-sound", CA_PROP_APPLICATION_NAME, "start-here", CA_PROP_APPLICATION_LANGUAGE, _tmp45_, NULL, NULL);
	_tmp46_ = self->priv->ca_context;
	ca_context_open (_tmp46_);
	g_async_initable_new_async (TYPE_SHELL_KEY_GRABBER_PROXY, 0, NULL, __sound_indicator___lambda67__gasync_ready_callback, g_object_ref (self), "g-flags", G_DBUS_PROXY_FLAGS_NONE, "g-name", "org.gnome.Shell", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/Shell", "g-interface-name", "org.gnome.Shell", NULL);
	_tmp47_ = sound_indicator_settings;
	g_signal_connect_object (_tmp47_, "changed", (GCallback) __sound_indicator___lambda68__g_settings_changed, self, 0);
	_g_free0 (locale);
	_g_object_unref0 (provider);
	_g_object_unref0 (gnome_settings);
	_g_object_unref0 (mouse_settings);
	_g_object_unref0 (touchpad_settings);
	return obj;
}

static void
sound_indicator_class_init (SoundIndicatorClass * klass,
                            gpointer klass_data)
{
	GSettings* _tmp0_;
	sound_indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundIndicator_private_offset);
	((WingpanelIndicatorClass *) klass)->get_display_widget = (GtkWidget* (*) (WingpanelIndicator*)) sound_indicator_real_get_display_widget;
	((WingpanelIndicatorClass *) klass)->get_widget = (GtkWidget* (*) (WingpanelIndicator*)) sound_indicator_real_get_widget;
	((WingpanelIndicatorClass *) klass)->opened = (void (*) (WingpanelIndicator*)) sound_indicator_real_opened;
	((WingpanelIndicatorClass *) klass)->closed = (void (*) (WingpanelIndicator*)) sound_indicator_real_closed;
	G_OBJECT_CLASS (klass)->get_property = _vala_sound_indicator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sound_indicator_set_property;
	G_OBJECT_CLASS (klass)->constructor = sound_indicator_constructor;
	G_OBJECT_CLASS (klass)->finalize = sound_indicator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_INDICATOR_IS_IN_SESSION_PROPERTY, sound_indicator_properties[SOUND_INDICATOR_IS_IN_SESSION_PROPERTY] = g_param_spec_boolean ("is-in-session", "is-in-session", "is-in-session", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_INDICATOR_NATURAL_SCROLL_TOUCHPAD_PROPERTY, sound_indicator_properties[SOUND_INDICATOR_NATURAL_SCROLL_TOUCHPAD_PROPERTY] = g_param_spec_boolean ("natural-scroll-touchpad", "natural-scroll-touchpad", "natural-scroll-touchpad", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_INDICATOR_NATURAL_SCROLL_MOUSE_PROPERTY, sound_indicator_properties[SOUND_INDICATOR_NATURAL_SCROLL_MOUSE_PROPERTY] = g_param_spec_boolean ("natural-scroll-mouse", "natural-scroll-mouse", "natural-scroll-mouse", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_INDICATOR_VOLUME_STEP_PROPERTY, sound_indicator_properties[SOUND_INDICATOR_VOLUME_STEP_PROPERTY] = g_param_spec_int ("volume-step", "volume-step", "volume-step", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_settings_new ("io.elementary.desktop.wingpanel.sound");
	_g_object_unref0 (sound_indicator_settings);
	sound_indicator_settings = _tmp0_;
}

static void
sound_indicator_instance_init (SoundIndicator * self,
                               gpointer klass)
{
	GeeHashMultiMap* _tmp0_;
	self->priv = sound_indicator_get_instance_private (self);
	self->priv->key_grabber = NULL;
	self->priv->key_grabber_id = (gulong) 0;
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->saved_action_ids = _tmp0_;
	self->priv->open = FALSE;
	self->priv->mute_blocks_sound = FALSE;
	self->priv->max_volume = 1.0;
	self->priv->ca_context = NULL;
	self->priv->total_x_delta = (gdouble) 0;
	self->priv->total_y_delta = (gdouble) 0;
	self->priv->notify_timeout_id = (guint) 0;
}

static void
sound_indicator_finalize (GObject * obj)
{
	SoundIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TYPE_INDICATOR, SoundIndicator);
	if (self->priv->sound_was_blocked_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->sound_was_blocked_timeout_id);
	}
	if (self->priv->notify_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->notify_timeout_id);
	}
	_g_object_unref0 (self->priv->display_widget);
	_g_object_unref0 (self->priv->main_box);
	_g_object_unref0 (self->priv->volume_adjustment);
	_g_object_unref0 (self->priv->mic_adjustment);
	_g_object_unref0 (self->priv->mpris);
	_g_object_unref0 (self->priv->volume_scale);
	_g_object_unref0 (self->priv->mic_scale);
	_g_object_unref0 (self->priv->output_device_manager);
	_g_object_unref0 (self->priv->input_device_manager);
	_g_object_unref0 (self->priv->mic_separator);
	_g_object_unref0 (self->priv->notification);
	_g_object_unref0 (self->priv->volume_control);
	_g_object_unref0 (self->priv->key_grabber);
	_g_object_unref0 (self->priv->saved_action_ids);
	G_OBJECT_CLASS (sound_indicator_parent_class)->finalize (obj);
}

static GType
sound_indicator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundIndicator), 0, (GInstanceInitFunc) sound_indicator_instance_init, NULL };
	GType sound_indicator_type_id;
	sound_indicator_type_id = g_type_register_static (WINGPANEL_TYPE_INDICATOR, "SoundIndicator", &g_define_type_info, 0);
	SoundIndicator_private_offset = g_type_add_instance_private (sound_indicator_type_id, sizeof (SoundIndicatorPrivate));
	return sound_indicator_type_id;
}

GType
sound_indicator_get_type (void)
{
	static volatile gsize sound_indicator_type_id__once = 0;
	if (g_once_init_enter (&sound_indicator_type_id__once)) {
		GType sound_indicator_type_id;
		sound_indicator_type_id = sound_indicator_get_type_once ();
		g_once_init_leave (&sound_indicator_type_id__once, sound_indicator_type_id);
	}
	return sound_indicator_type_id__once;
}

static void
_vala_sound_indicator_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	SoundIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUND_TYPE_INDICATOR, SoundIndicator);
	switch (property_id) {
		case SOUND_INDICATOR_IS_IN_SESSION_PROPERTY:
		g_value_set_boolean (value, sound_indicator_get_is_in_session (self));
		break;
		case SOUND_INDICATOR_NATURAL_SCROLL_TOUCHPAD_PROPERTY:
		g_value_set_boolean (value, sound_indicator_get_natural_scroll_touchpad (self));
		break;
		case SOUND_INDICATOR_NATURAL_SCROLL_MOUSE_PROPERTY:
		g_value_set_boolean (value, sound_indicator_get_natural_scroll_mouse (self));
		break;
		case SOUND_INDICATOR_VOLUME_STEP_PROPERTY:
		g_value_set_int (value, sound_indicator_get_volume_step (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sound_indicator_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	SoundIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUND_TYPE_INDICATOR, SoundIndicator);
	switch (property_id) {
		case SOUND_INDICATOR_IS_IN_SESSION_PROPERTY:
		sound_indicator_set_is_in_session (self, g_value_get_boolean (value));
		break;
		case SOUND_INDICATOR_NATURAL_SCROLL_TOUCHPAD_PROPERTY:
		sound_indicator_set_natural_scroll_touchpad (self, g_value_get_boolean (value));
		break;
		case SOUND_INDICATOR_NATURAL_SCROLL_MOUSE_PROPERTY:
		sound_indicator_set_natural_scroll_mouse (self, g_value_get_boolean (value));
		break;
		case SOUND_INDICATOR_VOLUME_STEP_PROPERTY:
		sound_indicator_set_volume_step (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

WingpanelIndicator*
get_indicator (GModule* module,
               WingpanelIndicatorManagerServerType server_type)
{
	SoundIndicator* indicator = NULL;
	SoundIndicator* _tmp0_;
	WingpanelIndicator* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Indicator.vala:699: Activating Sound Indicator");
	_tmp0_ = sound_indicator_new (server_type == WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_SESSION);
	indicator = _tmp0_;
	result = (WingpanelIndicator*) indicator;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

