/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSBackgroundFetchManager.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSBackgroundFetchOptions.h"
#include "JSBackgroundFetchRegistration.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSFetchRequest.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsBackgroundFetchManagerPrototypeFunction_fetch);
static JSC_DECLARE_HOST_FUNCTION(jsBackgroundFetchManagerPrototypeFunction_get);
static JSC_DECLARE_HOST_FUNCTION(jsBackgroundFetchManagerPrototypeFunction_getIds);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsBackgroundFetchManagerConstructor);

class JSBackgroundFetchManagerPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSBackgroundFetchManagerPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSBackgroundFetchManagerPrototype* ptr = new (NotNull, JSC::allocateCell<JSBackgroundFetchManagerPrototype>(vm)) JSBackgroundFetchManagerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSBackgroundFetchManagerPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSBackgroundFetchManagerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSBackgroundFetchManagerPrototype, JSBackgroundFetchManagerPrototype::Base);

using JSBackgroundFetchManagerDOMConstructor = JSDOMConstructorNotConstructable<JSBackgroundFetchManager>;

template<> const ClassInfo JSBackgroundFetchManagerDOMConstructor::s_info = { "BackgroundFetchManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBackgroundFetchManagerDOMConstructor) };

template<> JSValue JSBackgroundFetchManagerDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSBackgroundFetchManagerDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "BackgroundFetchManager"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSBackgroundFetchManager::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 4> JSBackgroundFetchManagerPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsBackgroundFetchManagerConstructor, 0 } },
    HashTableValue { "fetch"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBackgroundFetchManagerPrototypeFunction_fetch, 2 } },
    HashTableValue { "get"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBackgroundFetchManagerPrototypeFunction_get, 1 } },
    HashTableValue { "getIds"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBackgroundFetchManagerPrototypeFunction_getIds, 0 } },
};

const ClassInfo JSBackgroundFetchManagerPrototype::s_info = { "BackgroundFetchManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBackgroundFetchManagerPrototype) };

void JSBackgroundFetchManagerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSBackgroundFetchManager::info(), JSBackgroundFetchManagerPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSBackgroundFetchManager::s_info = { "BackgroundFetchManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBackgroundFetchManager) };

JSBackgroundFetchManager::JSBackgroundFetchManager(Structure* structure, JSDOMGlobalObject& globalObject, Ref<BackgroundFetchManager>&& impl)
    : JSDOMWrapper<BackgroundFetchManager>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, BackgroundFetchManager>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSBackgroundFetchManager::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSBackgroundFetchManagerPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSBackgroundFetchManagerPrototype::create(vm, &globalObject, structure);
}

JSObject* JSBackgroundFetchManager::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSBackgroundFetchManager>(vm, globalObject);
}

JSValue JSBackgroundFetchManager::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSBackgroundFetchManagerDOMConstructor, DOMConstructorID::BackgroundFetchManager>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSBackgroundFetchManager::destroy(JSC::JSCell* cell)
{
    JSBackgroundFetchManager* thisObject = static_cast<JSBackgroundFetchManager*>(cell);
    thisObject->JSBackgroundFetchManager::~JSBackgroundFetchManager();
}

JSC_DEFINE_CUSTOM_GETTER(jsBackgroundFetchManagerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSBackgroundFetchManagerPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSBackgroundFetchManager::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsBackgroundFetchManagerPrototypeFunction_fetchBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSBackgroundFetchManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto idConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (idConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto requestsConversionResult = convert<IDLUnion<IDLInterface<FetchRequest>, IDLUSVString, IDLSequence<IDLUnion<IDLInterface<FetchRequest>, IDLUSVString>>>>(*lexicalGlobalObject, argument1.value());
    if (requestsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto optionsConversionResult = convert<IDLDictionary<BackgroundFetchOptions>>(*lexicalGlobalObject, argument2.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<BackgroundFetchRegistration>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.fetch(*context, idConversionResult.releaseReturnValue(), requestsConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsBackgroundFetchManagerPrototypeFunction_fetch, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSBackgroundFetchManager>::call<jsBackgroundFetchManagerPrototypeFunction_fetchBody>(*lexicalGlobalObject, *callFrame, "fetch");
}

static inline JSC::EncodedJSValue jsBackgroundFetchManagerPrototypeFunction_getBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSBackgroundFetchManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto idConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (idConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLNullable<IDLInterface<BackgroundFetchRegistration>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.get(*context, idConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsBackgroundFetchManagerPrototypeFunction_get, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSBackgroundFetchManager>::call<jsBackgroundFetchManagerPrototypeFunction_getBody>(*lexicalGlobalObject, *callFrame, "get");
}

static inline JSC::EncodedJSValue jsBackgroundFetchManagerPrototypeFunction_getIdsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSBackgroundFetchManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLSequence<IDLDOMString>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getIds(*context, WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsBackgroundFetchManagerPrototypeFunction_getIds, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSBackgroundFetchManager>::call<jsBackgroundFetchManagerPrototypeFunction_getIdsBody>(*lexicalGlobalObject, *callFrame, "getIds");
}

JSC::GCClient::IsoSubspace* JSBackgroundFetchManager::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSBackgroundFetchManager, UseCustomHeapCellType::No>(vm, "JSBackgroundFetchManager"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForBackgroundFetchManager.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForBackgroundFetchManager = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForBackgroundFetchManager.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForBackgroundFetchManager = std::forward<decltype(space)>(space); }
    );
}

void JSBackgroundFetchManager::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSBackgroundFetchManager*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSBackgroundFetchManagerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSBackgroundFetchManagerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsBackgroundFetchManager = static_cast<JSBackgroundFetchManager*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsBackgroundFetchManager->protectedWrapped().ptr(), jsBackgroundFetchManager);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7BackgroundFetchManager@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22BackgroundFetchManagerE[]; }
#endif
template<std::same_as<BackgroundFetchManager> T>
static inline void verifyVTable(BackgroundFetchManager* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7BackgroundFetchManager@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore22BackgroundFetchManagerE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // BackgroundFetchManager has subclasses. If BackgroundFetchManager has subclasses that get passed
        // to toJS() we currently require BackgroundFetchManager you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<BackgroundFetchManager>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<BackgroundFetchManager>(impl.ptr());
#endif
    return createWrapper<BackgroundFetchManager>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, BackgroundFetchManager& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

BackgroundFetchManager* JSBackgroundFetchManager::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSBackgroundFetchManager*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
