/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSFontFaceDescriptors.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceDescriptorsConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_src);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_src);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_fontFamily);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_fontFamily);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_font_dash_family);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_font_dash_family);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_fontStyle);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_fontStyle);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_font_dash_style);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_font_dash_style);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_fontWeight);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_fontWeight);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_font_dash_weight);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_font_dash_weight);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_fontStretch);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_fontStretch);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_font_dash_stretch);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_font_dash_stretch);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_fontWidth);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_fontWidth);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_font_dash_width);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_font_dash_width);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_sizeAdjust);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_sizeAdjust);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_size_dash_adjust);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_size_dash_adjust);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_unicodeRange);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_unicodeRange);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_unicode_dash_range);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_unicode_dash_range);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_fontFeatureSettings);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_fontFeatureSettings);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_font_dash_feature_dash_settings);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_font_dash_feature_dash_settings);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_fontDisplay);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_fontDisplay);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_font_dash_display);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_font_dash_display);

class JSCSSFontFaceDescriptorsPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSFontFaceDescriptorsPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSFontFaceDescriptorsPrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSFontFaceDescriptorsPrototype>(vm)) JSCSSFontFaceDescriptorsPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSFontFaceDescriptorsPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSFontFaceDescriptorsPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSFontFaceDescriptorsPrototype, JSCSSFontFaceDescriptorsPrototype::Base);

using JSCSSFontFaceDescriptorsDOMConstructor = JSDOMConstructorNotConstructable<JSCSSFontFaceDescriptors>;

template<> const ClassInfo JSCSSFontFaceDescriptorsDOMConstructor::s_info = { "CSSFontFaceDescriptors"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSFontFaceDescriptorsDOMConstructor) };

template<> JSValue JSCSSFontFaceDescriptorsDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSStyleDeclaration::getConstructor(vm, &globalObject);
}

template<> void JSCSSFontFaceDescriptorsDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSFontFaceDescriptors"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSFontFaceDescriptors::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 20> JSCSSFontFaceDescriptorsPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceDescriptorsConstructor, 0 } },
    HashTableValue { "src"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceDescriptors_src, setJSCSSFontFaceDescriptors_src } },
    HashTableValue { "fontFamily"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceDescriptors_fontFamily, setJSCSSFontFaceDescriptors_fontFamily } },
    HashTableValue { "font-family"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceDescriptors_font_dash_family, setJSCSSFontFaceDescriptors_font_dash_family } },
    HashTableValue { "fontStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceDescriptors_fontStyle, setJSCSSFontFaceDescriptors_fontStyle } },
    HashTableValue { "font-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceDescriptors_font_dash_style, setJSCSSFontFaceDescriptors_font_dash_style } },
    HashTableValue { "fontWeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceDescriptors_fontWeight, setJSCSSFontFaceDescriptors_fontWeight } },
    HashTableValue { "font-weight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceDescriptors_font_dash_weight, setJSCSSFontFaceDescriptors_font_dash_weight } },
    HashTableValue { "fontStretch"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceDescriptors_fontStretch, setJSCSSFontFaceDescriptors_fontStretch } },
    HashTableValue { "font-stretch"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceDescriptors_font_dash_stretch, setJSCSSFontFaceDescriptors_font_dash_stretch } },
    HashTableValue { "fontWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceDescriptors_fontWidth, setJSCSSFontFaceDescriptors_fontWidth } },
    HashTableValue { "font-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceDescriptors_font_dash_width, setJSCSSFontFaceDescriptors_font_dash_width } },
    HashTableValue { "sizeAdjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceDescriptors_sizeAdjust, setJSCSSFontFaceDescriptors_sizeAdjust } },
    HashTableValue { "size-adjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceDescriptors_size_dash_adjust, setJSCSSFontFaceDescriptors_size_dash_adjust } },
    HashTableValue { "unicodeRange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceDescriptors_unicodeRange, setJSCSSFontFaceDescriptors_unicodeRange } },
    HashTableValue { "unicode-range"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceDescriptors_unicode_dash_range, setJSCSSFontFaceDescriptors_unicode_dash_range } },
    HashTableValue { "fontFeatureSettings"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceDescriptors_fontFeatureSettings, setJSCSSFontFaceDescriptors_fontFeatureSettings } },
    HashTableValue { "font-feature-settings"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceDescriptors_font_dash_feature_dash_settings, setJSCSSFontFaceDescriptors_font_dash_feature_dash_settings } },
    HashTableValue { "fontDisplay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceDescriptors_fontDisplay, setJSCSSFontFaceDescriptors_fontDisplay } },
    HashTableValue { "font-display"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceDescriptors_font_dash_display, setJSCSSFontFaceDescriptors_font_dash_display } },
};

const ClassInfo JSCSSFontFaceDescriptorsPrototype::s_info = { "CSSFontFaceDescriptors"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSFontFaceDescriptorsPrototype) };

void JSCSSFontFaceDescriptorsPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSFontFaceDescriptors::info(), JSCSSFontFaceDescriptorsPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSFontFaceDescriptors::s_info = { "CSSFontFaceDescriptors"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSFontFaceDescriptors) };

JSCSSFontFaceDescriptors::JSCSSFontFaceDescriptors(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSFontFaceDescriptors>&& impl)
    : JSCSSStyleDeclaration(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSFontFaceDescriptors> JSCSSFontFaceDescriptors::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSFontFaceDescriptors>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSFontFaceDescriptors::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSFontFaceDescriptorsPrototype::createStructure(vm, &globalObject, JSCSSStyleDeclaration::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSFontFaceDescriptorsPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSFontFaceDescriptors::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSFontFaceDescriptors>(vm, globalObject);
}

JSValue JSCSSFontFaceDescriptors::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSFontFaceDescriptorsDOMConstructor, DOMConstructorID::CSSFontFaceDescriptors>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceDescriptorsConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSFontFaceDescriptorsPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSFontFaceDescriptors::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCSSFontFaceDescriptors_srcGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.src())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_src, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::get<jsCSSFontFaceDescriptors_srcGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSFontFaceDescriptors_srcSetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setSrc(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_src, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::set<setJSCSSFontFaceDescriptors_srcSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSFontFaceDescriptors_fontFamilyGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.fontFamily())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_fontFamily, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::get<jsCSSFontFaceDescriptors_fontFamilyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSFontFaceDescriptors_fontFamilySetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setFontFamily(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_fontFamily, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::set<setJSCSSFontFaceDescriptors_fontFamilySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSFontFaceDescriptors_font_dash_familyGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.fontFamily())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_font_dash_family, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::get<jsCSSFontFaceDescriptors_font_dash_familyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSFontFaceDescriptors_font_dash_familySetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setFontFamily(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_font_dash_family, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::set<setJSCSSFontFaceDescriptors_font_dash_familySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSFontFaceDescriptors_fontStyleGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.fontStyle())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_fontStyle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::get<jsCSSFontFaceDescriptors_fontStyleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSFontFaceDescriptors_fontStyleSetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setFontStyle(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_fontStyle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::set<setJSCSSFontFaceDescriptors_fontStyleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSFontFaceDescriptors_font_dash_styleGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.fontStyle())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_font_dash_style, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::get<jsCSSFontFaceDescriptors_font_dash_styleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSFontFaceDescriptors_font_dash_styleSetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setFontStyle(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_font_dash_style, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::set<setJSCSSFontFaceDescriptors_font_dash_styleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSFontFaceDescriptors_fontWeightGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.fontWeight())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_fontWeight, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::get<jsCSSFontFaceDescriptors_fontWeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSFontFaceDescriptors_fontWeightSetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setFontWeight(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_fontWeight, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::set<setJSCSSFontFaceDescriptors_fontWeightSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSFontFaceDescriptors_font_dash_weightGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.fontWeight())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_font_dash_weight, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::get<jsCSSFontFaceDescriptors_font_dash_weightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSFontFaceDescriptors_font_dash_weightSetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setFontWeight(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_font_dash_weight, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::set<setJSCSSFontFaceDescriptors_font_dash_weightSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSFontFaceDescriptors_fontStretchGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.fontStretch())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_fontStretch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::get<jsCSSFontFaceDescriptors_fontStretchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSFontFaceDescriptors_fontStretchSetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setFontStretch(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_fontStretch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::set<setJSCSSFontFaceDescriptors_fontStretchSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSFontFaceDescriptors_font_dash_stretchGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.fontStretch())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_font_dash_stretch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::get<jsCSSFontFaceDescriptors_font_dash_stretchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSFontFaceDescriptors_font_dash_stretchSetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setFontStretch(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_font_dash_stretch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::set<setJSCSSFontFaceDescriptors_font_dash_stretchSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSFontFaceDescriptors_fontWidthGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.fontWidth())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_fontWidth, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::get<jsCSSFontFaceDescriptors_fontWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSFontFaceDescriptors_fontWidthSetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setFontWidth(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_fontWidth, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::set<setJSCSSFontFaceDescriptors_fontWidthSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSFontFaceDescriptors_font_dash_widthGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.fontWidth())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_font_dash_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::get<jsCSSFontFaceDescriptors_font_dash_widthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSFontFaceDescriptors_font_dash_widthSetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setFontWidth(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_font_dash_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::set<setJSCSSFontFaceDescriptors_font_dash_widthSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSFontFaceDescriptors_sizeAdjustGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.sizeAdjust())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_sizeAdjust, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::get<jsCSSFontFaceDescriptors_sizeAdjustGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSFontFaceDescriptors_sizeAdjustSetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setSizeAdjust(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_sizeAdjust, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::set<setJSCSSFontFaceDescriptors_sizeAdjustSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSFontFaceDescriptors_size_dash_adjustGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.sizeAdjust())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_size_dash_adjust, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::get<jsCSSFontFaceDescriptors_size_dash_adjustGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSFontFaceDescriptors_size_dash_adjustSetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setSizeAdjust(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_size_dash_adjust, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::set<setJSCSSFontFaceDescriptors_size_dash_adjustSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSFontFaceDescriptors_unicodeRangeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.unicodeRange())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_unicodeRange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::get<jsCSSFontFaceDescriptors_unicodeRangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSFontFaceDescriptors_unicodeRangeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setUnicodeRange(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_unicodeRange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::set<setJSCSSFontFaceDescriptors_unicodeRangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSFontFaceDescriptors_unicode_dash_rangeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.unicodeRange())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_unicode_dash_range, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::get<jsCSSFontFaceDescriptors_unicode_dash_rangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSFontFaceDescriptors_unicode_dash_rangeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setUnicodeRange(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_unicode_dash_range, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::set<setJSCSSFontFaceDescriptors_unicode_dash_rangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSFontFaceDescriptors_fontFeatureSettingsGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.fontFeatureSettings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_fontFeatureSettings, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::get<jsCSSFontFaceDescriptors_fontFeatureSettingsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSFontFaceDescriptors_fontFeatureSettingsSetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setFontFeatureSettings(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_fontFeatureSettings, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::set<setJSCSSFontFaceDescriptors_fontFeatureSettingsSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSFontFaceDescriptors_font_dash_feature_dash_settingsGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.fontFeatureSettings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_font_dash_feature_dash_settings, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::get<jsCSSFontFaceDescriptors_font_dash_feature_dash_settingsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSFontFaceDescriptors_font_dash_feature_dash_settingsSetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setFontFeatureSettings(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_font_dash_feature_dash_settings, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::set<setJSCSSFontFaceDescriptors_font_dash_feature_dash_settingsSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSFontFaceDescriptors_fontDisplayGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.fontDisplay())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_fontDisplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::get<jsCSSFontFaceDescriptors_fontDisplayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSFontFaceDescriptors_fontDisplaySetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setFontDisplay(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_fontDisplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::set<setJSCSSFontFaceDescriptors_fontDisplaySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSFontFaceDescriptors_font_dash_displayGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.fontDisplay())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceDescriptors_font_dash_display, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::get<jsCSSFontFaceDescriptors_font_dash_displayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSFontFaceDescriptors_font_dash_displaySetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setFontDisplay(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSFontFaceDescriptors_font_dash_display, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceDescriptors>::set<setJSCSSFontFaceDescriptors_font_dash_displaySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCSSFontFaceDescriptors::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSFontFaceDescriptors, UseCustomHeapCellType::No>(vm, "JSCSSFontFaceDescriptors"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSFontFaceDescriptors.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSFontFaceDescriptors = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSFontFaceDescriptors.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSFontFaceDescriptors = std::forward<decltype(space)>(space); }
    );
}

void JSCSSFontFaceDescriptors::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSFontFaceDescriptors*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CSSFontFaceDescriptors@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22CSSFontFaceDescriptorsE[]; }
#endif
template<std::same_as<CSSFontFaceDescriptors> T>
static inline void verifyVTable(CSSFontFaceDescriptors* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CSSFontFaceDescriptors@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore22CSSFontFaceDescriptorsE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CSSFontFaceDescriptors has subclasses. If CSSFontFaceDescriptors has subclasses that get passed
        // to toJS() we currently require CSSFontFaceDescriptors you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CSSFontFaceDescriptors>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<CSSFontFaceDescriptors>(impl.ptr());
#endif
    return createWrapper<CSSFontFaceDescriptors>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CSSFontFaceDescriptors& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CSSFontFaceDescriptors* JSCSSFontFaceDescriptors::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSFontFaceDescriptors*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
