/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCanvasLineJoin.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(CanvasLineJoin enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("round"),
        MAKE_STATIC_STRING_IMPL("bevel"),
        MAKE_STATIC_STRING_IMPL("miter"),
    };
    static_assert(static_cast<size_t>(CanvasLineJoin::Round) == 0, "CanvasLineJoin::Round is not 0 as expected");
    static_assert(static_cast<size_t>(CanvasLineJoin::Bevel) == 1, "CanvasLineJoin::Bevel is not 1 as expected");
    static_assert(static_cast<size_t>(CanvasLineJoin::Miter) == 2, "CanvasLineJoin::Miter is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, CanvasLineJoin enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<CanvasLineJoin> parseEnumerationFromString<CanvasLineJoin>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, CanvasLineJoin>, 3> mappings {
        std::pair<ComparableASCIILiteral, CanvasLineJoin> { "bevel"_s, CanvasLineJoin::Bevel },
        std::pair<ComparableASCIILiteral, CanvasLineJoin> { "miter"_s, CanvasLineJoin::Miter },
        std::pair<ComparableASCIILiteral, CanvasLineJoin> { "round"_s, CanvasLineJoin::Round },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<CanvasLineJoin> parseEnumeration<CanvasLineJoin>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<CanvasLineJoin>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<CanvasLineJoin>()
{
    return "\"round\", \"bevel\", \"miter\""_s;
}

} // namespace WebCore

