/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCaretPosition.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMRect.h"
#include "JSDOMWrapperCache.h"
#include "JSNode.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsCaretPositionPrototypeFunction_getClientRect);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCaretPositionConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCaretPosition_offsetNode);
static JSC_DECLARE_CUSTOM_GETTER(jsCaretPosition_offset);

class JSCaretPositionPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCaretPositionPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCaretPositionPrototype* ptr = new (NotNull, JSC::allocateCell<JSCaretPositionPrototype>(vm)) JSCaretPositionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCaretPositionPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCaretPositionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCaretPositionPrototype, JSCaretPositionPrototype::Base);

using JSCaretPositionDOMConstructor = JSDOMConstructorNotConstructable<JSCaretPosition>;

template<> const ClassInfo JSCaretPositionDOMConstructor::s_info = { "CaretPosition"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCaretPositionDOMConstructor) };

template<> JSValue JSCaretPositionDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCaretPositionDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CaretPosition"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCaretPosition::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 4> JSCaretPositionPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCaretPositionConstructor, 0 } },
    HashTableValue { "offsetNode"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCaretPosition_offsetNode, 0 } },
    HashTableValue { "offset"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCaretPosition_offset, 0 } },
    HashTableValue { "getClientRect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCaretPositionPrototypeFunction_getClientRect, 0 } },
};

const ClassInfo JSCaretPositionPrototype::s_info = { "CaretPosition"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCaretPositionPrototype) };

void JSCaretPositionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCaretPosition::info(), JSCaretPositionPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCaretPosition::s_info = { "CaretPosition"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCaretPosition) };

JSCaretPosition::JSCaretPosition(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CaretPosition>&& impl)
    : JSDOMWrapper<CaretPosition, SignedPtrTraits<CaretPosition, CaretPositionPtrTag>>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, CaretPosition>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCaretPosition::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCaretPositionPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSCaretPositionPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCaretPosition::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCaretPosition>(vm, globalObject);
}

JSValue JSCaretPosition::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCaretPositionDOMConstructor, DOMConstructorID::CaretPosition>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSCaretPosition::destroy(JSC::JSCell* cell)
{
    JSCaretPosition* thisObject = static_cast<JSCaretPosition*>(cell);
    thisObject->JSCaretPosition::~JSCaretPosition();
}

JSC_DEFINE_CUSTOM_GETTER(jsCaretPositionConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCaretPositionPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCaretPosition::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCaretPosition_offsetNodeGetter(JSGlobalObject& lexicalGlobalObject, JSCaretPosition& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<Node>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.offsetNode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCaretPosition_offsetNode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCaretPosition>::get<jsCaretPosition_offsetNodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCaretPosition_offsetGetter(JSGlobalObject& lexicalGlobalObject, JSCaretPosition& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.offset())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCaretPosition_offset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCaretPosition>::get<jsCaretPosition_offsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsCaretPositionPrototypeFunction_getClientRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCaretPosition>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLNullable<IDLInterface<DOMRect>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getClientRect())));
}

JSC_DEFINE_HOST_FUNCTION(jsCaretPositionPrototypeFunction_getClientRect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCaretPosition>::call<jsCaretPositionPrototypeFunction_getClientRectBody>(*lexicalGlobalObject, *callFrame, "getClientRect");
}

JSC::GCClient::IsoSubspace* JSCaretPosition::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCaretPosition, UseCustomHeapCellType::No>(vm, "JSCaretPosition"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCaretPosition.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCaretPosition = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCaretPosition.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCaretPosition = std::forward<decltype(space)>(space); }
    );
}

void JSCaretPosition::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCaretPosition*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSCaretPositionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSCaretPositionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCaretPosition = static_cast<JSCaretPosition*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsCaretPosition->protectedWrapped().ptr(), jsCaretPosition);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CaretPosition@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13CaretPositionE[]; }
#endif
template<std::same_as<CaretPosition> T>
static inline void verifyVTable(CaretPosition* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CaretPosition@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore13CaretPositionE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CaretPosition has subclasses. If CaretPosition has subclasses that get passed
        // to toJS() we currently require CaretPosition you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CaretPosition>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<CaretPosition>(impl.ptr());
#endif
    return createWrapper<CaretPosition>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CaretPosition& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CaretPosition* JSCaretPosition::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCaretPosition*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
