/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMCSSNamespace.h"

#include "ActiveDOMObject.h"
#include "CSSNumericFactory.h"
#include "DOMCSSNamespace.h"
#include "DOMCSSPaintWorklet.h"
#include "DOMCSSRegisterCustomProperty.h"
#include "Document.h"
#include "DocumentInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSCSSUnitValue.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMCSSCustomPropertyDescriptor.h"
#include "JSDOMConstructorNotCallable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSHighlightRegistry.h"
#include "JSWorklet.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectPrototype.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_supports);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_escape);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_number);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_percent);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cap);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_ch);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_em);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_ex);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_ic);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lh);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_rcap);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_rch);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_rem);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_rex);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_ric);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_rlh);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vw);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vh);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vi);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vb);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vmin);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vmax);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svw);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svh);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svi);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svb);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svmin);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svmax);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvw);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvh);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvi);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvb);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvmin);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvmax);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvw);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvh);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvi);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvb);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvmin);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvmax);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqw);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqh);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqi);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqb);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqmin);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqmax);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cm);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_mm);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_Q);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_in);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_pt);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_pc);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_px);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_deg);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_grad);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_rad);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_turn);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_s);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_ms);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_Hz);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_kHz);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dpi);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dpcm);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dppx);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_fr);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_registerProperty);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDOMCSSNamespaceConstructor_highlights);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMCSSNamespaceConstructor_paintWorklet);

using JSDOMCSSNamespaceDOMConstructor = JSDOMConstructorNotCallable<JSDOMCSSNamespace>;

/* Hash table for constructor */

static const std::array<HashTableValue, 68> JSDOMCSSNamespaceConstructorTableValues {
    HashTableValue { "highlights"_s, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMCSSNamespaceConstructor_highlights, 0 } },
    HashTableValue { "paintWorklet"_s, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMCSSNamespaceConstructor_paintWorklet, 0 } },
    HashTableValue { "supports"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_supports, 1 } },
    HashTableValue { "escape"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_escape, 1 } },
    HashTableValue { "number"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_number, 1 } },
    HashTableValue { "percent"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_percent, 1 } },
    HashTableValue { "cap"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_cap, 1 } },
    HashTableValue { "ch"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_ch, 1 } },
    HashTableValue { "em"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_em, 1 } },
    HashTableValue { "ex"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_ex, 1 } },
    HashTableValue { "ic"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_ic, 1 } },
    HashTableValue { "lh"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_lh, 1 } },
    HashTableValue { "rcap"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_rcap, 1 } },
    HashTableValue { "rch"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_rch, 1 } },
    HashTableValue { "rem"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_rem, 1 } },
    HashTableValue { "rex"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_rex, 1 } },
    HashTableValue { "ric"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_ric, 1 } },
    HashTableValue { "rlh"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_rlh, 1 } },
    HashTableValue { "vw"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_vw, 1 } },
    HashTableValue { "vh"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_vh, 1 } },
    HashTableValue { "vi"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_vi, 1 } },
    HashTableValue { "vb"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_vb, 1 } },
    HashTableValue { "vmin"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_vmin, 1 } },
    HashTableValue { "vmax"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_vmax, 1 } },
    HashTableValue { "svw"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_svw, 1 } },
    HashTableValue { "svh"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_svh, 1 } },
    HashTableValue { "svi"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_svi, 1 } },
    HashTableValue { "svb"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_svb, 1 } },
    HashTableValue { "svmin"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_svmin, 1 } },
    HashTableValue { "svmax"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_svmax, 1 } },
    HashTableValue { "lvw"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_lvw, 1 } },
    HashTableValue { "lvh"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_lvh, 1 } },
    HashTableValue { "lvi"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_lvi, 1 } },
    HashTableValue { "lvb"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_lvb, 1 } },
    HashTableValue { "lvmin"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_lvmin, 1 } },
    HashTableValue { "lvmax"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_lvmax, 1 } },
    HashTableValue { "dvw"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_dvw, 1 } },
    HashTableValue { "dvh"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_dvh, 1 } },
    HashTableValue { "dvi"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_dvi, 1 } },
    HashTableValue { "dvb"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_dvb, 1 } },
    HashTableValue { "dvmin"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_dvmin, 1 } },
    HashTableValue { "dvmax"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_dvmax, 1 } },
    HashTableValue { "cqw"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_cqw, 1 } },
    HashTableValue { "cqh"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_cqh, 1 } },
    HashTableValue { "cqi"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_cqi, 1 } },
    HashTableValue { "cqb"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_cqb, 1 } },
    HashTableValue { "cqmin"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_cqmin, 1 } },
    HashTableValue { "cqmax"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_cqmax, 1 } },
    HashTableValue { "cm"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_cm, 1 } },
    HashTableValue { "mm"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_mm, 1 } },
    HashTableValue { "Q"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_Q, 1 } },
    HashTableValue { "in"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_in, 1 } },
    HashTableValue { "pt"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_pt, 1 } },
    HashTableValue { "pc"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_pc, 1 } },
    HashTableValue { "px"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_px, 1 } },
    HashTableValue { "deg"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_deg, 1 } },
    HashTableValue { "grad"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_grad, 1 } },
    HashTableValue { "rad"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_rad, 1 } },
    HashTableValue { "turn"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_turn, 1 } },
    HashTableValue { "s"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_s, 1 } },
    HashTableValue { "ms"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_ms, 1 } },
    HashTableValue { "Hz"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_Hz, 1 } },
    HashTableValue { "kHz"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_kHz, 1 } },
    HashTableValue { "dpi"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_dpi, 1 } },
    HashTableValue { "dpcm"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_dpcm, 1 } },
    HashTableValue { "dppx"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_dppx, 1 } },
    HashTableValue { "fr"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_fr, 1 } },
    HashTableValue { "registerProperty"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCSSNamespaceConstructorFunction_registerProperty, 1 } },
};

template<> const ClassInfo JSDOMCSSNamespaceDOMConstructor::s_info = { "CSS"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMCSSNamespaceDOMConstructor) };

template<> JSValue JSDOMCSSNamespaceDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.objectPrototype();
}

template<> void JSDOMCSSNamespaceDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
    reifyStaticProperties(vm, JSDOMCSSNamespace::info(), JSDOMCSSNamespaceConstructorTableValues, *this);
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().cssPaintingAPIEnabled) {
        auto propertyName = Identifier::fromString(vm, "paintWorklet"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
}

const ClassInfo JSDOMCSSNamespace::s_info = { "CSS"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMCSSNamespace) };

JSDOMCSSNamespace::JSDOMCSSNamespace(Structure* structure, JSDOMGlobalObject& globalObject)
    : JSDOMObject(structure, globalObject) { }

static_assert(!std::is_base_of<ActiveDOMObject, DOMCSSNamespace>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSValue JSDOMCSSNamespace::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMCSSNamespaceDOMConstructor, DOMConstructorID::DOMCSSNamespace>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDOMCSSNamespace::destroy(JSC::JSCell* cell)
{
    JSDOMCSSNamespace* thisObject = static_cast<JSDOMCSSNamespace*>(cell);
    thisObject->JSDOMCSSNamespace::~JSDOMCSSNamespace();
}

static inline JSValue jsDOMCSSNamespaceConstructor_highlightsGetter(JSGlobalObject& lexicalGlobalObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    RefPtr context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return jsUndefined();
    Ref document = downcast<Document>(*context);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<HighlightRegistry>>(lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject), throwScope, DOMCSSNamespace::highlights(document.get()))));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMCSSNamespaceConstructor_highlights, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMCSSNamespace>::getStatic<jsDOMCSSNamespaceConstructor_highlightsGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMCSSNamespaceConstructor_paintWorkletGetter(JSGlobalObject& lexicalGlobalObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    RefPtr context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return jsUndefined();
    Ref document = downcast<Document>(*context);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<Worklet>>(lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject), throwScope, WebCore::DOMCSSPaintWorklet::ensurePaintWorklet(document.get()))));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMCSSNamespaceConstructor_paintWorklet, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMCSSNamespace>::getStatic<jsDOMCSSNamespaceConstructor_paintWorkletGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_supports1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    RefPtr context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    Ref document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto propertyConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (propertyConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto valueConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, DOMCSSNamespace::supports(document.get(), propertyConversionResult.releaseReturnValue(), valueConversionResult.releaseReturnValue()))));
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_supports2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    RefPtr context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    Ref document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto conditionTextConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (conditionTextConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, DOMCSSNamespace::supports(document.get(), conditionTextConversionResult.releaseReturnValue()))));
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_supportsOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 1) {
        RELEASE_AND_RETURN(throwScope, (jsDOMCSSNamespaceConstructorFunction_supports2Body(lexicalGlobalObject, callFrame)));
    }
    if (argsCount == 2) {
        RELEASE_AND_RETURN(throwScope, (jsDOMCSSNamespaceConstructorFunction_supports1Body(lexicalGlobalObject, callFrame)));
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_supports, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_supportsOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "supports");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_escapeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto identConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (identConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, DOMCSSNamespace::escape(identConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_escape, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_escapeBody>(*lexicalGlobalObject, *callFrame, "escape");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_numberBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::number(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_number, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_numberBody>(*lexicalGlobalObject, *callFrame, "number");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_percentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::percent(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_percent, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_percentBody>(*lexicalGlobalObject, *callFrame, "percent");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_capBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::cap(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cap, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_capBody>(*lexicalGlobalObject, *callFrame, "cap");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_chBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::ch(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_ch, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_chBody>(*lexicalGlobalObject, *callFrame, "ch");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_emBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::em(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_em, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_emBody>(*lexicalGlobalObject, *callFrame, "em");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_exBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::ex(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_ex, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_exBody>(*lexicalGlobalObject, *callFrame, "ex");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_icBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::ic(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_ic, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_icBody>(*lexicalGlobalObject, *callFrame, "ic");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_lhBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::lh(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lh, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_lhBody>(*lexicalGlobalObject, *callFrame, "lh");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_rcapBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::rcap(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_rcap, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_rcapBody>(*lexicalGlobalObject, *callFrame, "rcap");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_rchBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::rch(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_rch, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_rchBody>(*lexicalGlobalObject, *callFrame, "rch");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_remBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::rem(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_rem, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_remBody>(*lexicalGlobalObject, *callFrame, "rem");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_rexBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::rex(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_rex, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_rexBody>(*lexicalGlobalObject, *callFrame, "rex");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_ricBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::ric(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_ric, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_ricBody>(*lexicalGlobalObject, *callFrame, "ric");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_rlhBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::rlh(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_rlh, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_rlhBody>(*lexicalGlobalObject, *callFrame, "rlh");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_vwBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::vw(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vw, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_vwBody>(*lexicalGlobalObject, *callFrame, "vw");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_vhBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::vh(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vh, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_vhBody>(*lexicalGlobalObject, *callFrame, "vh");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_viBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::vi(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vi, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_viBody>(*lexicalGlobalObject, *callFrame, "vi");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_vbBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::vb(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vb, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_vbBody>(*lexicalGlobalObject, *callFrame, "vb");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_vminBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::vmin(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vmin, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_vminBody>(*lexicalGlobalObject, *callFrame, "vmin");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_vmaxBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::vmax(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_vmax, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_vmaxBody>(*lexicalGlobalObject, *callFrame, "vmax");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_svwBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::svw(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svw, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_svwBody>(*lexicalGlobalObject, *callFrame, "svw");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_svhBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::svh(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svh, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_svhBody>(*lexicalGlobalObject, *callFrame, "svh");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_sviBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::svi(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svi, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_sviBody>(*lexicalGlobalObject, *callFrame, "svi");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_svbBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::svb(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svb, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_svbBody>(*lexicalGlobalObject, *callFrame, "svb");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_svminBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::svmin(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svmin, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_svminBody>(*lexicalGlobalObject, *callFrame, "svmin");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_svmaxBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::svmax(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_svmax, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_svmaxBody>(*lexicalGlobalObject, *callFrame, "svmax");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_lvwBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::lvw(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvw, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_lvwBody>(*lexicalGlobalObject, *callFrame, "lvw");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_lvhBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::lvh(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvh, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_lvhBody>(*lexicalGlobalObject, *callFrame, "lvh");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_lviBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::lvi(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvi, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_lviBody>(*lexicalGlobalObject, *callFrame, "lvi");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_lvbBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::lvb(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvb, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_lvbBody>(*lexicalGlobalObject, *callFrame, "lvb");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_lvminBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::lvmin(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvmin, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_lvminBody>(*lexicalGlobalObject, *callFrame, "lvmin");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_lvmaxBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::lvmax(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_lvmax, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_lvmaxBody>(*lexicalGlobalObject, *callFrame, "lvmax");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_dvwBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::dvw(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvw, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_dvwBody>(*lexicalGlobalObject, *callFrame, "dvw");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_dvhBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::dvh(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvh, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_dvhBody>(*lexicalGlobalObject, *callFrame, "dvh");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_dviBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::dvi(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvi, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_dviBody>(*lexicalGlobalObject, *callFrame, "dvi");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_dvbBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::dvb(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvb, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_dvbBody>(*lexicalGlobalObject, *callFrame, "dvb");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_dvminBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::dvmin(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvmin, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_dvminBody>(*lexicalGlobalObject, *callFrame, "dvmin");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_dvmaxBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::dvmax(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dvmax, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_dvmaxBody>(*lexicalGlobalObject, *callFrame, "dvmax");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_cqwBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::cqw(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqw, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_cqwBody>(*lexicalGlobalObject, *callFrame, "cqw");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_cqhBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::cqh(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqh, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_cqhBody>(*lexicalGlobalObject, *callFrame, "cqh");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_cqiBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::cqi(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqi, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_cqiBody>(*lexicalGlobalObject, *callFrame, "cqi");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_cqbBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::cqb(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqb, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_cqbBody>(*lexicalGlobalObject, *callFrame, "cqb");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_cqminBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::cqmin(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqmin, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_cqminBody>(*lexicalGlobalObject, *callFrame, "cqmin");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_cqmaxBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::cqmax(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cqmax, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_cqmaxBody>(*lexicalGlobalObject, *callFrame, "cqmax");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_cmBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::cm(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_cm, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_cmBody>(*lexicalGlobalObject, *callFrame, "cm");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_mmBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::mm(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_mm, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_mmBody>(*lexicalGlobalObject, *callFrame, "mm");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_QBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::q(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_Q, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_QBody>(*lexicalGlobalObject, *callFrame, "Q");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_inBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::in(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_in, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_inBody>(*lexicalGlobalObject, *callFrame, "in");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_ptBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::pt(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_pt, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_ptBody>(*lexicalGlobalObject, *callFrame, "pt");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_pcBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::pc(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_pc, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_pcBody>(*lexicalGlobalObject, *callFrame, "pc");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_pxBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::px(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_px, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_pxBody>(*lexicalGlobalObject, *callFrame, "px");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_degBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::deg(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_deg, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_degBody>(*lexicalGlobalObject, *callFrame, "deg");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_gradBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::grad(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_grad, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_gradBody>(*lexicalGlobalObject, *callFrame, "grad");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_radBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::rad(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_rad, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_radBody>(*lexicalGlobalObject, *callFrame, "rad");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_turnBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::turn(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_turn, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_turnBody>(*lexicalGlobalObject, *callFrame, "turn");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_sBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::s(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_s, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_sBody>(*lexicalGlobalObject, *callFrame, "s");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_msBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::ms(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_ms, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_msBody>(*lexicalGlobalObject, *callFrame, "ms");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_HzBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::hz(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_Hz, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_HzBody>(*lexicalGlobalObject, *callFrame, "Hz");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_kHzBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::kHz(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_kHz, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_kHzBody>(*lexicalGlobalObject, *callFrame, "kHz");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_dpiBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::dpi(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dpi, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_dpiBody>(*lexicalGlobalObject, *callFrame, "dpi");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_dpcmBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::dpcm(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dpcm, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_dpcmBody>(*lexicalGlobalObject, *callFrame, "dpcm");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_dppxBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::dppx(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_dppx, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_dppxBody>(*lexicalGlobalObject, *callFrame, "dppx");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_frBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, WebCore::CSSNumericFactory::fr(valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_fr, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_frBody>(*lexicalGlobalObject, *callFrame, "fr");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunction_registerPropertyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    RefPtr context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    Ref document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto descriptorConversionResult = convert<IDLDictionary<DOMCSSCustomPropertyDescriptor>>(*lexicalGlobalObject, argument0.value());
    if (descriptorConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return WebCore::DOMCSSRegisterCustomProperty::registerProperty(document.get(), descriptorConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCSSNamespaceConstructorFunction_registerProperty, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunction_registerPropertyBody>(*lexicalGlobalObject, *callFrame, "registerProperty");
}

JSC::GCClient::IsoSubspace* JSDOMCSSNamespace::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDOMCSSNamespace, UseCustomHeapCellType::No>(vm, "JSDOMCSSNamespace"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDOMCSSNamespace.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDOMCSSNamespace = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDOMCSSNamespace.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDOMCSSNamespace = std::forward<decltype(space)>(space); }
    );
}


}
