/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSExtendableMessageEvent.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSMessagePort.h"
#include "JSServiceWorker.h"
#include "JSServiceWorkerClient.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<ExtendableMessageEvent::Init>> convertDictionary<ExtendableMessageEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    ExtendableMessageEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bubblesConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bubblesValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (bubblesConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.bubbles = bubblesConversionResult.releaseReturnValue();
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto cancelableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, cancelableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (cancelableConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.cancelable = cancelableConversionResult.releaseReturnValue();
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto composedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, composedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (composedConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.composed = composedConversionResult.releaseReturnValue();
    JSValue dataValue;
    if (isNullOrUndefined)
        dataValue = jsUndefined();
    else {
        dataValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "data"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto dataConversionResult = convertOptionalWithDefault<IDLAny>(lexicalGlobalObject, dataValue, [&]() -> ConversionResult<IDLAny> { return typename Converter<IDLAny>::ReturnType { jsNull() }; });
    if (dataConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.data = dataConversionResult.releaseReturnValue();
    JSValue lastEventIdValue;
    if (isNullOrUndefined)
        lastEventIdValue = jsUndefined();
    else {
        lastEventIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "lastEventId"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto lastEventIdConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, lastEventIdValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (lastEventIdConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.lastEventId = lastEventIdConversionResult.releaseReturnValue();
    JSValue originValue;
    if (isNullOrUndefined)
        originValue = jsUndefined();
    else {
        originValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "origin"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto originConversionResult = convertOptionalWithDefault<IDLUSVString>(lexicalGlobalObject, originValue, [&]() -> ConversionResult<IDLUSVString> { return Converter<IDLUSVString>::ReturnType { emptyString() }; });
    if (originConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.origin = originConversionResult.releaseReturnValue();
    JSValue portsValue;
    if (isNullOrUndefined)
        portsValue = jsUndefined();
    else {
        portsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ports"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto portsConversionResult = convertOptionalWithDefault<IDLSequence<IDLInterface<MessagePort>>>(lexicalGlobalObject, portsValue, [&]() -> ConversionResult<IDLSequence<IDLInterface<MessagePort>>> { return Converter<IDLSequence<IDLInterface<MessagePort>>>::ReturnType { }; });
    if (portsConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.ports = portsConversionResult.releaseReturnValue();
    JSValue sourceValue;
    if (isNullOrUndefined)
        sourceValue = jsUndefined();
    else {
        sourceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "source"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto sourceConversionResult = convertOptionalWithDefault<IDLNullable<IDLUnion<IDLInterface<ServiceWorkerClient>, IDLInterface<ServiceWorker>, IDLInterface<MessagePort>>>>(lexicalGlobalObject, sourceValue, [&]() -> ConversionResult<IDLNullable<IDLUnion<IDLInterface<ServiceWorkerClient>, IDLInterface<ServiceWorker>, IDLInterface<MessagePort>>>> { return typename Converter<IDLNullable<IDLUnion<IDLInterface<ServiceWorkerClient>, IDLInterface<ServiceWorker>, IDLInterface<MessagePort>>>>::ReturnType { std::nullopt }; });
    if (sourceConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.source = sourceConversionResult.releaseReturnValue();
    return result;
}

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsExtendableMessageEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsExtendableMessageEvent_data);
static JSC_DECLARE_CUSTOM_GETTER(jsExtendableMessageEvent_origin);
static JSC_DECLARE_CUSTOM_GETTER(jsExtendableMessageEvent_lastEventId);
static JSC_DECLARE_CUSTOM_GETTER(jsExtendableMessageEvent_source);
static JSC_DECLARE_CUSTOM_GETTER(jsExtendableMessageEvent_ports);

class JSExtendableMessageEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSExtendableMessageEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSExtendableMessageEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSExtendableMessageEventPrototype>(vm)) JSExtendableMessageEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSExtendableMessageEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSExtendableMessageEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSExtendableMessageEventPrototype, JSExtendableMessageEventPrototype::Base);

using JSExtendableMessageEventDOMConstructor = JSDOMConstructor<JSExtendableMessageEvent>;

template<> JSC::EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSExtendableMessageEventDOMConstructor::construct(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    ASSERT(callFrame);
    return constructJSExtendableMessageEvent(lexicalGlobalObject, *callFrame);
}
JSC_ANNOTATE_HOST_FUNCTION(JSExtendableMessageEventDOMConstructorConstruct, JSExtendableMessageEventDOMConstructor::construct);

template<> const ClassInfo JSExtendableMessageEventDOMConstructor::s_info = { "ExtendableMessageEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSExtendableMessageEventDOMConstructor) };

template<> JSValue JSExtendableMessageEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSExtendableEvent::getConstructor(vm, &globalObject);
}

template<> void JSExtendableMessageEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ExtendableMessageEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSExtendableMessageEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 6> JSExtendableMessageEventPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsExtendableMessageEventConstructor, 0 } },
    HashTableValue { "data"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsExtendableMessageEvent_data, 0 } },
    HashTableValue { "origin"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsExtendableMessageEvent_origin, 0 } },
    HashTableValue { "lastEventId"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsExtendableMessageEvent_lastEventId, 0 } },
    HashTableValue { "source"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsExtendableMessageEvent_source, 0 } },
    HashTableValue { "ports"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsExtendableMessageEvent_ports, 0 } },
};

const ClassInfo JSExtendableMessageEventPrototype::s_info = { "ExtendableMessageEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSExtendableMessageEventPrototype) };

void JSExtendableMessageEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSExtendableMessageEvent::info(), JSExtendableMessageEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSExtendableMessageEvent::s_info = { "ExtendableMessageEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSExtendableMessageEvent) };

JSExtendableMessageEvent::JSExtendableMessageEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ExtendableMessageEvent>&& impl)
    : JSExtendableEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<ExtendableMessageEvent> JSExtendableMessageEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, ExtendableMessageEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSExtendableMessageEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSExtendableMessageEventPrototype::createStructure(vm, &globalObject, JSExtendableEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSExtendableMessageEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSExtendableMessageEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSExtendableMessageEvent>(vm, globalObject);
}

JSValue JSExtendableMessageEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSExtendableMessageEventDOMConstructor, DOMConstructorID::ExtendableMessageEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsExtendableMessageEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSExtendableMessageEventPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSExtendableMessageEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsExtendableMessageEvent_dataGetter(JSGlobalObject& lexicalGlobalObject, JSExtendableMessageEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAny>(lexicalGlobalObject, throwScope, impl.data())));
}

JSC_DEFINE_CUSTOM_GETTER(jsExtendableMessageEvent_data, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSExtendableMessageEvent>::get<jsExtendableMessageEvent_dataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsExtendableMessageEvent_originGetter(JSGlobalObject& lexicalGlobalObject, JSExtendableMessageEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.origin())));
}

JSC_DEFINE_CUSTOM_GETTER(jsExtendableMessageEvent_origin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSExtendableMessageEvent>::get<jsExtendableMessageEvent_originGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsExtendableMessageEvent_lastEventIdGetter(JSGlobalObject& lexicalGlobalObject, JSExtendableMessageEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.lastEventId())));
}

JSC_DEFINE_CUSTOM_GETTER(jsExtendableMessageEvent_lastEventId, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSExtendableMessageEvent>::get<jsExtendableMessageEvent_lastEventIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsExtendableMessageEvent_sourceGetter(JSGlobalObject& lexicalGlobalObject, JSExtendableMessageEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUnion<IDLInterface<ServiceWorkerClient>, IDLInterface<ServiceWorker>, IDLInterface<MessagePort>>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.source())));
}

JSC_DEFINE_CUSTOM_GETTER(jsExtendableMessageEvent_source, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSExtendableMessageEvent>::get<jsExtendableMessageEvent_sourceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsExtendableMessageEvent_portsGetter(JSGlobalObject& lexicalGlobalObject, JSExtendableMessageEvent& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return thisObject.ports(lexicalGlobalObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsExtendableMessageEvent_ports, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSExtendableMessageEvent>::get<jsExtendableMessageEvent_portsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSExtendableMessageEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSExtendableMessageEvent, UseCustomHeapCellType::No>(vm, "JSExtendableMessageEvent"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForExtendableMessageEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForExtendableMessageEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForExtendableMessageEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForExtendableMessageEvent = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSExtendableMessageEvent::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSExtendableMessageEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSExtendableMessageEvent);

template<typename Visitor>
void JSExtendableMessageEvent::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSExtendableMessageEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSExtendableMessageEvent::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSExtendableMessageEvent::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSExtendableMessageEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSExtendableMessageEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ExtendableMessageEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22ExtendableMessageEventE[]; }
#endif
template<std::same_as<ExtendableMessageEvent> T>
static inline void verifyVTable(ExtendableMessageEvent* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ExtendableMessageEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore22ExtendableMessageEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ExtendableMessageEvent has subclasses. If ExtendableMessageEvent has subclasses that get passed
        // to toJS() we currently require ExtendableMessageEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ExtendableMessageEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<ExtendableMessageEvent>(impl.ptr());
#endif
    return createWrapper<ExtendableMessageEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ExtendableMessageEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
