/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSInputDeviceInfo.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSMediaTrackCapabilities.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsInputDeviceInfoPrototypeFunction_getCapabilities);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsInputDeviceInfoConstructor);

class JSInputDeviceInfoPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSInputDeviceInfoPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSInputDeviceInfoPrototype* ptr = new (NotNull, JSC::allocateCell<JSInputDeviceInfoPrototype>(vm)) JSInputDeviceInfoPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSInputDeviceInfoPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSInputDeviceInfoPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSInputDeviceInfoPrototype, JSInputDeviceInfoPrototype::Base);

using JSInputDeviceInfoDOMConstructor = JSDOMConstructorNotConstructable<JSInputDeviceInfo>;

template<> const ClassInfo JSInputDeviceInfoDOMConstructor::s_info = { "InputDeviceInfo"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInputDeviceInfoDOMConstructor) };

template<> JSValue JSInputDeviceInfoDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSMediaDeviceInfo::getConstructor(vm, &globalObject);
}

template<> void JSInputDeviceInfoDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "InputDeviceInfo"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSInputDeviceInfo::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSInputDeviceInfoPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsInputDeviceInfoConstructor, 0 } },
    HashTableValue { "getCapabilities"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInputDeviceInfoPrototypeFunction_getCapabilities, 0 } },
};

const ClassInfo JSInputDeviceInfoPrototype::s_info = { "InputDeviceInfo"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInputDeviceInfoPrototype) };

void JSInputDeviceInfoPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSInputDeviceInfo::info(), JSInputDeviceInfoPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSInputDeviceInfo::s_info = { "InputDeviceInfo"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInputDeviceInfo) };

JSInputDeviceInfo::JSInputDeviceInfo(Structure* structure, JSDOMGlobalObject& globalObject, Ref<InputDeviceInfo>&& impl)
    : JSMediaDeviceInfo(structure, globalObject, WTFMove(impl))
{
}

Ref<InputDeviceInfo> JSInputDeviceInfo::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, InputDeviceInfo>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSInputDeviceInfo::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSInputDeviceInfoPrototype::createStructure(vm, &globalObject, JSMediaDeviceInfo::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSInputDeviceInfoPrototype::create(vm, &globalObject, structure);
}

JSObject* JSInputDeviceInfo::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSInputDeviceInfo>(vm, globalObject);
}

JSValue JSInputDeviceInfo::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSInputDeviceInfoDOMConstructor, DOMConstructorID::InputDeviceInfo>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsInputDeviceInfoConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSInputDeviceInfoPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSInputDeviceInfo::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsInputDeviceInfoPrototypeFunction_getCapabilitiesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInputDeviceInfo>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDictionary<MediaTrackCapabilities>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getCapabilities())));
}

JSC_DEFINE_HOST_FUNCTION(jsInputDeviceInfoPrototypeFunction_getCapabilities, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInputDeviceInfo>::call<jsInputDeviceInfoPrototypeFunction_getCapabilitiesBody>(*lexicalGlobalObject, *callFrame, "getCapabilities");
}

JSC::GCClient::IsoSubspace* JSInputDeviceInfo::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSInputDeviceInfo, UseCustomHeapCellType::No>(vm, "JSInputDeviceInfo"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForInputDeviceInfo.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForInputDeviceInfo = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForInputDeviceInfo.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForInputDeviceInfo = std::forward<decltype(space)>(space); }
    );
}

void JSInputDeviceInfo::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSInputDeviceInfo*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7InputDeviceInfo@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15InputDeviceInfoE[]; }
#endif
template<std::same_as<InputDeviceInfo> T>
static inline void verifyVTable(InputDeviceInfo* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7InputDeviceInfo@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore15InputDeviceInfoE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // InputDeviceInfo has subclasses. If InputDeviceInfo has subclasses that get passed
        // to toJS() we currently require InputDeviceInfo you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<InputDeviceInfo>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<InputDeviceInfo>(impl.ptr());
#endif
    return createWrapper<InputDeviceInfo>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, InputDeviceInfo& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(MEDIA_STREAM)
