/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "InspectorFrontendHost.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMWrapper.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class JSInspectorFrontendHost : public JSDOMWrapper<InspectorFrontendHost> {
public:
    using Base = JSDOMWrapper<InspectorFrontendHost>;
    static JSInspectorFrontendHost* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<InspectorFrontendHost>&& impl)
    {
        SUPPRESS_UNCOUNTED_LOCAL auto& vm = globalObject->vm();
        JSInspectorFrontendHost* ptr = new (NotNull, JSC::allocateCell<JSInspectorFrontendHost>(vm)) JSInspectorFrontendHost(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(vm);
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static InspectorFrontendHost* toWrapped(JSC::VM&, JSC::JSValue);
    static void destroy(JSC::JSCell*);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info(), JSC::NonArray);
    }

    template<typename, JSC::SubspaceAccess mode> static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return subspaceForImpl(vm);
    }
    static JSC::GCClient::IsoSubspace* subspaceForImpl(JSC::VM& vm);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
protected:
    JSInspectorFrontendHost(JSC::Structure*, JSDOMGlobalObject&, Ref<InspectorFrontendHost>&&);

    DECLARE_DEFAULT_FINISH_CREATION;
};

class JSInspectorFrontendHostOwner final : public JSC::WeakHandleOwner {
public:
    bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::AbstractSlotVisitor&, ASCIILiteral*) final;
    void finalize(JSC::Handle<JSC::Unknown>, void* context) final;
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, InspectorFrontendHost*)
{
    static NeverDestroyed<JSInspectorFrontendHostOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(InspectorFrontendHost* wrappableObject)
{
    return wrappableObject;
}

JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, InspectorFrontendHost&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, InspectorFrontendHost* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<InspectorFrontendHost>&&);
ALWAYS_INLINE JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, InspectorFrontendHost& impl) { return toJSNewlyCreated(lexicalGlobalObject, globalObject, Ref { impl }); }
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<InspectorFrontendHost>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<InspectorFrontendHost> {
    using WrapperClass = JSInspectorFrontendHost;
    using ToWrappedReturnType = InspectorFrontendHost*;
};
String convertEnumerationToString(InspectorFrontendHost::SaveMode);
template<> JSC::JSString* convertEnumerationToJS(JSC::VM&, InspectorFrontendHost::SaveMode);

template<> std::optional<InspectorFrontendHost::SaveMode> parseEnumerationFromString<InspectorFrontendHost::SaveMode>(const String&);
template<> std::optional<InspectorFrontendHost::SaveMode> parseEnumeration<InspectorFrontendHost::SaveMode>(JSC::JSGlobalObject&, JSC::JSValue);
template<> ASCIILiteral expectedEnumerationValues<InspectorFrontendHost::SaveMode>();

template<> ConversionResult<IDLDictionary<InspectorFrontendHost::SaveData>> convertDictionary<InspectorFrontendHost::SaveData>(JSC::JSGlobalObject&, JSC::JSValue);

template<> ConversionResult<IDLDictionary<InspectorFrontendHost::ContextMenuItem>> convertDictionary<InspectorFrontendHost::ContextMenuItem>(JSC::JSGlobalObject&, JSC::JSValue);

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const InspectorFrontendHost::DebuggableInfo&);


} // namespace WebCore
