/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSOESDrawBuffersIndexed.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_enableiOES);
static JSC_DECLARE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_disableiOES);
static JSC_DECLARE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_blendEquationiOES);
static JSC_DECLARE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_blendEquationSeparateiOES);
static JSC_DECLARE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_blendFunciOES);
static JSC_DECLARE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_blendFuncSeparateiOES);
static JSC_DECLARE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_colorMaskiOES);

class JSOESDrawBuffersIndexedPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOESDrawBuffersIndexedPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOESDrawBuffersIndexedPrototype* ptr = new (NotNull, JSC::allocateCell<JSOESDrawBuffersIndexedPrototype>(vm)) JSOESDrawBuffersIndexedPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESDrawBuffersIndexedPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOESDrawBuffersIndexedPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESDrawBuffersIndexedPrototype, JSOESDrawBuffersIndexedPrototype::Base);

/* Hash table for prototype */

static const std::array<HashTableValue, 7> JSOESDrawBuffersIndexedPrototypeTableValues {
    HashTableValue { "enableiOES"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOESDrawBuffersIndexedPrototypeFunction_enableiOES, 2 } },
    HashTableValue { "disableiOES"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOESDrawBuffersIndexedPrototypeFunction_disableiOES, 2 } },
    HashTableValue { "blendEquationiOES"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOESDrawBuffersIndexedPrototypeFunction_blendEquationiOES, 2 } },
    HashTableValue { "blendEquationSeparateiOES"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOESDrawBuffersIndexedPrototypeFunction_blendEquationSeparateiOES, 3 } },
    HashTableValue { "blendFunciOES"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOESDrawBuffersIndexedPrototypeFunction_blendFunciOES, 3 } },
    HashTableValue { "blendFuncSeparateiOES"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOESDrawBuffersIndexedPrototypeFunction_blendFuncSeparateiOES, 5 } },
    HashTableValue { "colorMaskiOES"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOESDrawBuffersIndexedPrototypeFunction_colorMaskiOES, 5 } },
};

const ClassInfo JSOESDrawBuffersIndexedPrototype::s_info = { "OESDrawBuffersIndexed"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESDrawBuffersIndexedPrototype) };

void JSOESDrawBuffersIndexedPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOESDrawBuffersIndexed::info(), JSOESDrawBuffersIndexedPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSOESDrawBuffersIndexed::s_info = { "OESDrawBuffersIndexed"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESDrawBuffersIndexed) };

JSOESDrawBuffersIndexed::JSOESDrawBuffersIndexed(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OESDrawBuffersIndexed>&& impl)
    : JSDOMWrapper<OESDrawBuffersIndexed>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, OESDrawBuffersIndexed>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSOESDrawBuffersIndexed::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSOESDrawBuffersIndexedPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSOESDrawBuffersIndexedPrototype::create(vm, &globalObject, structure);
}

JSObject* JSOESDrawBuffersIndexed::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOESDrawBuffersIndexed>(vm, globalObject);
}

void JSOESDrawBuffersIndexed::destroy(JSC::JSCell* cell)
{
    JSOESDrawBuffersIndexed* thisObject = static_cast<JSOESDrawBuffersIndexed*>(cell);
    thisObject->JSOESDrawBuffersIndexed::~JSOESDrawBuffersIndexed();
}

static inline JSC::EncodedJSValue jsOESDrawBuffersIndexedPrototypeFunction_enableiOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESDrawBuffersIndexed>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto targetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (targetConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto indexConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (indexConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.enableiOES(targetConversionResult.releaseReturnValue(), indexConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_enableiOES, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOESDrawBuffersIndexed>::call<jsOESDrawBuffersIndexedPrototypeFunction_enableiOESBody>(*lexicalGlobalObject, *callFrame, "enableiOES");
}

static inline JSC::EncodedJSValue jsOESDrawBuffersIndexedPrototypeFunction_disableiOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESDrawBuffersIndexed>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto targetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (targetConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto indexConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (indexConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.disableiOES(targetConversionResult.releaseReturnValue(), indexConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_disableiOES, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOESDrawBuffersIndexed>::call<jsOESDrawBuffersIndexedPrototypeFunction_disableiOESBody>(*lexicalGlobalObject, *callFrame, "disableiOES");
}

static inline JSC::EncodedJSValue jsOESDrawBuffersIndexedPrototypeFunction_blendEquationiOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESDrawBuffersIndexed>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto bufConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (bufConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto modeConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (modeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.blendEquationiOES(bufConversionResult.releaseReturnValue(), modeConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_blendEquationiOES, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOESDrawBuffersIndexed>::call<jsOESDrawBuffersIndexedPrototypeFunction_blendEquationiOESBody>(*lexicalGlobalObject, *callFrame, "blendEquationiOES");
}

static inline JSC::EncodedJSValue jsOESDrawBuffersIndexedPrototypeFunction_blendEquationSeparateiOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESDrawBuffersIndexed>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 3) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto bufConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (bufConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto modeRGBConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (modeRGBConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto modeAlphaConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    if (modeAlphaConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.blendEquationSeparateiOES(bufConversionResult.releaseReturnValue(), modeRGBConversionResult.releaseReturnValue(), modeAlphaConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_blendEquationSeparateiOES, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOESDrawBuffersIndexed>::call<jsOESDrawBuffersIndexedPrototypeFunction_blendEquationSeparateiOESBody>(*lexicalGlobalObject, *callFrame, "blendEquationSeparateiOES");
}

static inline JSC::EncodedJSValue jsOESDrawBuffersIndexedPrototypeFunction_blendFunciOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESDrawBuffersIndexed>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 3) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto bufConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (bufConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto srcConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (srcConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto dstConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    if (dstConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.blendFunciOES(bufConversionResult.releaseReturnValue(), srcConversionResult.releaseReturnValue(), dstConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_blendFunciOES, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOESDrawBuffersIndexed>::call<jsOESDrawBuffersIndexedPrototypeFunction_blendFunciOESBody>(*lexicalGlobalObject, *callFrame, "blendFunciOES");
}

static inline JSC::EncodedJSValue jsOESDrawBuffersIndexedPrototypeFunction_blendFuncSeparateiOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESDrawBuffersIndexed>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 5) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto bufConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (bufConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto srcRGBConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (srcRGBConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto dstRGBConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    if (dstRGBConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto srcAlphaConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument3.value());
    if (srcAlphaConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto dstAlphaConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument4.value());
    if (dstAlphaConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.blendFuncSeparateiOES(bufConversionResult.releaseReturnValue(), srcRGBConversionResult.releaseReturnValue(), dstRGBConversionResult.releaseReturnValue(), srcAlphaConversionResult.releaseReturnValue(), dstAlphaConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_blendFuncSeparateiOES, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOESDrawBuffersIndexed>::call<jsOESDrawBuffersIndexedPrototypeFunction_blendFuncSeparateiOESBody>(*lexicalGlobalObject, *callFrame, "blendFuncSeparateiOES");
}

static inline JSC::EncodedJSValue jsOESDrawBuffersIndexedPrototypeFunction_colorMaskiOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESDrawBuffersIndexed>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 5) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto bufConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (bufConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto rConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument1.value());
    if (rConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto gConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument2.value());
    if (gConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto bConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument3.value());
    if (bConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto aConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument4.value());
    if (aConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.colorMaskiOES(bufConversionResult.releaseReturnValue(), rConversionResult.releaseReturnValue(), gConversionResult.releaseReturnValue(), bConversionResult.releaseReturnValue(), aConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_colorMaskiOES, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOESDrawBuffersIndexed>::call<jsOESDrawBuffersIndexedPrototypeFunction_colorMaskiOESBody>(*lexicalGlobalObject, *callFrame, "colorMaskiOES");
}

JSC::GCClient::IsoSubspace* JSOESDrawBuffersIndexed::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSOESDrawBuffersIndexed, UseCustomHeapCellType::No>(vm, "JSOESDrawBuffersIndexed"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForOESDrawBuffersIndexed.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForOESDrawBuffersIndexed = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForOESDrawBuffersIndexed.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForOESDrawBuffersIndexed = std::forward<decltype(space)>(space); }
    );
}

void JSOESDrawBuffersIndexed::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOESDrawBuffersIndexed*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSOESDrawBuffersIndexedOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsOESDrawBuffersIndexed = jsCast<JSOESDrawBuffersIndexed*>(handle.slot()->asCell());
    auto& owner = jsOESDrawBuffersIndexed->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from jsOESDrawBuffersIndexed"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSOESDrawBuffersIndexedOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOESDrawBuffersIndexed = static_cast<JSOESDrawBuffersIndexed*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsOESDrawBuffersIndexed->protectedWrapped().ptr(), jsOESDrawBuffersIndexed);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OESDrawBuffersIndexed@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21OESDrawBuffersIndexedE[]; }
#endif
template<std::same_as<OESDrawBuffersIndexed> T>
static inline void verifyVTable(OESDrawBuffersIndexed* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7OESDrawBuffersIndexed@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21OESDrawBuffersIndexedE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // OESDrawBuffersIndexed has subclasses. If OESDrawBuffersIndexed has subclasses that get passed
        // to toJS() we currently require OESDrawBuffersIndexed you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OESDrawBuffersIndexed>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<OESDrawBuffersIndexed>(impl.ptr());
#endif
    return createWrapper<OESDrawBuffersIndexed>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OESDrawBuffersIndexed& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OESDrawBuffersIndexed* JSOESDrawBuffersIndexed::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOESDrawBuffersIndexed*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
