/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSOESSampleVariables.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

class JSOESSampleVariablesPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOESSampleVariablesPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOESSampleVariablesPrototype* ptr = new (NotNull, JSC::allocateCell<JSOESSampleVariablesPrototype>(vm)) JSOESSampleVariablesPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESSampleVariablesPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOESSampleVariablesPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESSampleVariablesPrototype, JSOESSampleVariablesPrototype::Base);

/* Hash table for prototype */
const ClassInfo JSOESSampleVariablesPrototype::s_info = { "OESSampleVariables"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESSampleVariablesPrototype) };

void JSOESSampleVariablesPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSOESSampleVariables::s_info = { "OESSampleVariables"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESSampleVariables) };

JSOESSampleVariables::JSOESSampleVariables(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OESSampleVariables>&& impl)
    : JSDOMWrapper<OESSampleVariables>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, OESSampleVariables>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSOESSampleVariables::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSOESSampleVariablesPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSOESSampleVariablesPrototype::create(vm, &globalObject, structure);
}

JSObject* JSOESSampleVariables::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOESSampleVariables>(vm, globalObject);
}

void JSOESSampleVariables::destroy(JSC::JSCell* cell)
{
    JSOESSampleVariables* thisObject = static_cast<JSOESSampleVariables*>(cell);
    thisObject->JSOESSampleVariables::~JSOESSampleVariables();
}

JSC::GCClient::IsoSubspace* JSOESSampleVariables::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSOESSampleVariables, UseCustomHeapCellType::No>(vm, "JSOESSampleVariables"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForOESSampleVariables.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForOESSampleVariables = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForOESSampleVariables.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForOESSampleVariables = std::forward<decltype(space)>(space); }
    );
}

void JSOESSampleVariables::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOESSampleVariables*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSOESSampleVariablesOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsOESSampleVariables = jsCast<JSOESSampleVariables*>(handle.slot()->asCell());
    auto& owner = jsOESSampleVariables->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from jsOESSampleVariables"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSOESSampleVariablesOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOESSampleVariables = static_cast<JSOESSampleVariables*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsOESSampleVariables->protectedWrapped().ptr(), jsOESSampleVariables);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OESSampleVariables@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore18OESSampleVariablesE[]; }
#endif
template<std::same_as<OESSampleVariables> T>
static inline void verifyVTable(OESSampleVariables* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7OESSampleVariables@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore18OESSampleVariablesE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // OESSampleVariables has subclasses. If OESSampleVariables has subclasses that get passed
        // to toJS() we currently require OESSampleVariables you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OESSampleVariables>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<OESSampleVariables>(impl.ptr());
#endif
    return createWrapper<OESSampleVariables>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OESSampleVariables& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OESSampleVariables* JSOESSampleVariables::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOESSampleVariables*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
