/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "JSDOMWrapper.h"
#include "JSPerformanceEntry.h"
#include "PerformanceEventTiming.h"

namespace WebCore {

class JSPerformanceEventTiming : public JSPerformanceEntry {
public:
    using Base = JSPerformanceEntry;
    using DOMWrapped = PerformanceEventTiming;
    static JSPerformanceEventTiming* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<PerformanceEventTiming>&& impl)
    {
        SUPPRESS_UNCOUNTED_LOCAL auto& vm = globalObject->vm();
        JSPerformanceEventTiming* ptr = new (NotNull, JSC::allocateCell<JSPerformanceEventTiming>(vm)) JSPerformanceEventTiming(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(vm);
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info(), JSC::NonArray);
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    template<typename, JSC::SubspaceAccess mode> static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return subspaceForImpl(vm);
    }
    static JSC::GCClient::IsoSubspace* subspaceForImpl(JSC::VM& vm);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    PerformanceEventTiming& wrapped() const
    {
        return static_cast<PerformanceEventTiming&>(Base::wrapped());
    }

    Ref<PerformanceEventTiming> protectedWrapped() const;

protected:
    JSPerformanceEventTiming(JSC::Structure*, JSDOMGlobalObject&, Ref<PerformanceEventTiming>&&);

    DECLARE_DEFAULT_FINISH_CREATION;
};


template<> struct JSDOMWrapperConverterTraits<PerformanceEventTiming> {
    using WrapperClass = JSPerformanceEventTiming;
    using ToWrappedReturnType = PerformanceEventTiming*;
};

} // namespace WebCore
