/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSQLResultSetRowList.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/Vector.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsSQLResultSetRowListPrototypeFunction_item);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSQLResultSetRowListConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSQLResultSetRowList_length);

class JSSQLResultSetRowListPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSQLResultSetRowListPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSQLResultSetRowListPrototype* ptr = new (NotNull, JSC::allocateCell<JSSQLResultSetRowListPrototype>(vm)) JSSQLResultSetRowListPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSQLResultSetRowListPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSQLResultSetRowListPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSQLResultSetRowListPrototype, JSSQLResultSetRowListPrototype::Base);

using JSSQLResultSetRowListDOMConstructor = JSDOMConstructorNotConstructable<JSSQLResultSetRowList>;

template<> const ClassInfo JSSQLResultSetRowListDOMConstructor::s_info = { "SQLResultSetRowList"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSQLResultSetRowListDOMConstructor) };

template<> JSValue JSSQLResultSetRowListDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSQLResultSetRowListDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SQLResultSetRowList"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSQLResultSetRowList::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 3> JSSQLResultSetRowListPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSQLResultSetRowListConstructor, 0 } },
    HashTableValue { "length"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSQLResultSetRowList_length, 0 } },
    HashTableValue { "item"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSQLResultSetRowListPrototypeFunction_item, 1 } },
};

const ClassInfo JSSQLResultSetRowListPrototype::s_info = { "SQLResultSetRowList"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSQLResultSetRowListPrototype) };

void JSSQLResultSetRowListPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSQLResultSetRowList::info(), JSSQLResultSetRowListPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSQLResultSetRowList::s_info = { "SQLResultSetRowList"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSQLResultSetRowList) };

JSSQLResultSetRowList::JSSQLResultSetRowList(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SQLResultSetRowList>&& impl)
    : JSDOMWrapper<SQLResultSetRowList>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, SQLResultSetRowList>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSQLResultSetRowList::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSQLResultSetRowListPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSSQLResultSetRowListPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSQLResultSetRowList::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSQLResultSetRowList>(vm, globalObject);
}

JSValue JSSQLResultSetRowList::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSQLResultSetRowListDOMConstructor, DOMConstructorID::SQLResultSetRowList>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSQLResultSetRowList::destroy(JSC::JSCell* cell)
{
    JSSQLResultSetRowList* thisObject = static_cast<JSSQLResultSetRowList*>(cell);
    thisObject->JSSQLResultSetRowList::~JSSQLResultSetRowList();
}

JSC_DEFINE_CUSTOM_GETTER(jsSQLResultSetRowListConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSQLResultSetRowListPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSQLResultSetRowList::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSQLResultSetRowList_lengthGetter(JSGlobalObject& lexicalGlobalObject, JSSQLResultSetRowList& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.length())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSQLResultSetRowList_length, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSQLResultSetRowList>::get<jsSQLResultSetRowList_lengthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsSQLResultSetRowListPrototypeFunction_itemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSQLResultSetRowList>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto indexConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (indexConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLRecord<IDLDOMString, IDLUnion<IDLNull, IDLDOMString, IDLUnrestrictedDouble>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.item(indexConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSQLResultSetRowListPrototypeFunction_item, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSQLResultSetRowList>::call<jsSQLResultSetRowListPrototypeFunction_itemBody>(*lexicalGlobalObject, *callFrame, "item");
}

JSC::GCClient::IsoSubspace* JSSQLResultSetRowList::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSQLResultSetRowList, UseCustomHeapCellType::No>(vm, "JSSQLResultSetRowList"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSQLResultSetRowList.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSQLResultSetRowList = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSQLResultSetRowList.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSQLResultSetRowList = std::forward<decltype(space)>(space); }
    );
}

void JSSQLResultSetRowList::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSQLResultSetRowList*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSSQLResultSetRowListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSQLResultSetRowListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSQLResultSetRowList = static_cast<JSSQLResultSetRowList*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSQLResultSetRowList->protectedWrapped().ptr(), jsSQLResultSetRowList);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SQLResultSetRowList@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19SQLResultSetRowListE[]; }
#endif
template<std::same_as<SQLResultSetRowList> T>
static inline void verifyVTable(SQLResultSetRowList* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7SQLResultSetRowList@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore19SQLResultSetRowListE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // SQLResultSetRowList has subclasses. If SQLResultSetRowList has subclasses that get passed
        // to toJS() we currently require SQLResultSetRowList you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SQLResultSetRowList>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<SQLResultSetRowList>(impl.ptr());
#endif
    return createWrapper<SQLResultSetRowList>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SQLResultSetRowList& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SQLResultSetRowList* JSSQLResultSetRowList::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSQLResultSetRowList*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
