/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SPEECH_SYNTHESIS)

#include "JSSpeechSynthesisErrorEvent.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSSpeechSynthesisErrorCode.h"
#include "JSSpeechSynthesisErrorEventInit.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSpeechSynthesisErrorEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSpeechSynthesisErrorEvent_error);

class JSSpeechSynthesisErrorEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSpeechSynthesisErrorEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSpeechSynthesisErrorEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSSpeechSynthesisErrorEventPrototype>(vm)) JSSpeechSynthesisErrorEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSpeechSynthesisErrorEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSpeechSynthesisErrorEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSpeechSynthesisErrorEventPrototype, JSSpeechSynthesisErrorEventPrototype::Base);

using JSSpeechSynthesisErrorEventDOMConstructor = JSDOMConstructor<JSSpeechSynthesisErrorEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSSpeechSynthesisErrorEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSSpeechSynthesisErrorEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto eventInitDictConversionResult = convert<IDLDictionary<SpeechSynthesisErrorEventInit>>(*lexicalGlobalObject, argument1.value());
    if (eventInitDictConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = SpeechSynthesisErrorEvent::create(typeConversionResult.releaseReturnValue(), eventInitDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<SpeechSynthesisErrorEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<SpeechSynthesisErrorEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSSpeechSynthesisErrorEventDOMConstructorConstruct, JSSpeechSynthesisErrorEventDOMConstructor::construct);

template<> const ClassInfo JSSpeechSynthesisErrorEventDOMConstructor::s_info = { "SpeechSynthesisErrorEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSpeechSynthesisErrorEventDOMConstructor) };

template<> JSValue JSSpeechSynthesisErrorEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSpeechSynthesisEvent::getConstructor(vm, &globalObject);
}

template<> void JSSpeechSynthesisErrorEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SpeechSynthesisErrorEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSpeechSynthesisErrorEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSSpeechSynthesisErrorEventPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechSynthesisErrorEventConstructor, 0 } },
    HashTableValue { "error"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechSynthesisErrorEvent_error, 0 } },
};

const ClassInfo JSSpeechSynthesisErrorEventPrototype::s_info = { "SpeechSynthesisErrorEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSpeechSynthesisErrorEventPrototype) };

void JSSpeechSynthesisErrorEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSpeechSynthesisErrorEvent::info(), JSSpeechSynthesisErrorEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSpeechSynthesisErrorEvent::s_info = { "SpeechSynthesisErrorEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSpeechSynthesisErrorEvent) };

JSSpeechSynthesisErrorEvent::JSSpeechSynthesisErrorEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SpeechSynthesisErrorEvent>&& impl)
    : JSSpeechSynthesisEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<SpeechSynthesisErrorEvent> JSSpeechSynthesisErrorEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, SpeechSynthesisErrorEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSpeechSynthesisErrorEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSpeechSynthesisErrorEventPrototype::createStructure(vm, &globalObject, JSSpeechSynthesisEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSpeechSynthesisErrorEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSpeechSynthesisErrorEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSpeechSynthesisErrorEvent>(vm, globalObject);
}

JSValue JSSpeechSynthesisErrorEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSpeechSynthesisErrorEventDOMConstructor, DOMConstructorID::SpeechSynthesisErrorEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechSynthesisErrorEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSpeechSynthesisErrorEventPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSpeechSynthesisErrorEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSpeechSynthesisErrorEvent_errorGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechSynthesisErrorEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<SpeechSynthesisErrorCode>>(lexicalGlobalObject, throwScope, impl.error())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechSynthesisErrorEvent_error, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechSynthesisErrorEvent>::get<jsSpeechSynthesisErrorEvent_errorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSpeechSynthesisErrorEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSpeechSynthesisErrorEvent, UseCustomHeapCellType::No>(vm, "JSSpeechSynthesisErrorEvent"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSpeechSynthesisErrorEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSpeechSynthesisErrorEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSpeechSynthesisErrorEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSpeechSynthesisErrorEvent = std::forward<decltype(space)>(space); }
    );
}

void JSSpeechSynthesisErrorEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSpeechSynthesisErrorEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SpeechSynthesisErrorEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore25SpeechSynthesisErrorEventE[]; }
#endif
template<std::same_as<SpeechSynthesisErrorEvent> T>
static inline void verifyVTable(SpeechSynthesisErrorEvent* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7SpeechSynthesisErrorEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore25SpeechSynthesisErrorEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // SpeechSynthesisErrorEvent has subclasses. If SpeechSynthesisErrorEvent has subclasses that get passed
        // to toJS() we currently require SpeechSynthesisErrorEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SpeechSynthesisErrorEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<SpeechSynthesisErrorEvent>(impl.ptr());
#endif
    return createWrapper<SpeechSynthesisErrorEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SpeechSynthesisErrorEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(SPEECH_SYNTHESIS)
