/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSStaticRange.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSNode.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<StaticRange::Init>> convertDictionary<StaticRange::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    StaticRange::Init result;
    JSValue endContainerValue;
    if (isNullOrUndefined)
        endContainerValue = jsUndefined();
    else {
        endContainerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "endContainer"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (endContainerValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "endContainer"_s, "StaticRangeInit"_s, "Node"_s);
        return ConversionResultException { };
    }
    auto endContainerConversionResult = convert<IDLInterface<Node>>(lexicalGlobalObject, endContainerValue);
    if (endContainerConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.endContainer = endContainerConversionResult.releaseReturnValue();
    JSValue endOffsetValue;
    if (isNullOrUndefined)
        endOffsetValue = jsUndefined();
    else {
        endOffsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "endOffset"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (endOffsetValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "endOffset"_s, "StaticRangeInit"_s, "unsigned long"_s);
        return ConversionResultException { };
    }
    auto endOffsetConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, endOffsetValue);
    if (endOffsetConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.endOffset = endOffsetConversionResult.releaseReturnValue();
    JSValue startContainerValue;
    if (isNullOrUndefined)
        startContainerValue = jsUndefined();
    else {
        startContainerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "startContainer"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (startContainerValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "startContainer"_s, "StaticRangeInit"_s, "Node"_s);
        return ConversionResultException { };
    }
    auto startContainerConversionResult = convert<IDLInterface<Node>>(lexicalGlobalObject, startContainerValue);
    if (startContainerConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.startContainer = startContainerConversionResult.releaseReturnValue();
    JSValue startOffsetValue;
    if (isNullOrUndefined)
        startOffsetValue = jsUndefined();
    else {
        startOffsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "startOffset"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (startOffsetValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "startOffset"_s, "StaticRangeInit"_s, "unsigned long"_s);
        return ConversionResultException { };
    }
    auto startOffsetConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, startOffsetValue);
    if (startOffsetConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.startOffset = startOffsetConversionResult.releaseReturnValue();
    return result;
}

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsStaticRangeConstructor);

class JSStaticRangePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSStaticRangePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSStaticRangePrototype* ptr = new (NotNull, JSC::allocateCell<JSStaticRangePrototype>(vm)) JSStaticRangePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSStaticRangePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSStaticRangePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSStaticRangePrototype, JSStaticRangePrototype::Base);

using JSStaticRangeDOMConstructor = JSDOMConstructor<JSStaticRange>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSStaticRangeDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSStaticRangeDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto initConversionResult = convert<IDLDictionary<StaticRange::Init>>(*lexicalGlobalObject, argument0.value());
    if (initConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = StaticRange::create(initConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<StaticRange>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<StaticRange>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSStaticRangeDOMConstructorConstruct, JSStaticRangeDOMConstructor::construct);

template<> const ClassInfo JSStaticRangeDOMConstructor::s_info = { "StaticRange"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStaticRangeDOMConstructor) };

template<> JSValue JSStaticRangeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAbstractRange::getConstructor(vm, &globalObject);
}

template<> void JSStaticRangeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "StaticRange"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSStaticRange::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 1> JSStaticRangePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsStaticRangeConstructor, 0 } },
};

const ClassInfo JSStaticRangePrototype::s_info = { "StaticRange"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStaticRangePrototype) };

void JSStaticRangePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSStaticRange::info(), JSStaticRangePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSStaticRange::s_info = { "StaticRange"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStaticRange) };

JSStaticRange::JSStaticRange(Structure* structure, JSDOMGlobalObject& globalObject, Ref<StaticRange>&& impl)
    : JSAbstractRange(structure, globalObject, WTFMove(impl))
{
}

Ref<StaticRange> JSStaticRange::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, StaticRange>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSStaticRange::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSStaticRangePrototype::createStructure(vm, &globalObject, JSAbstractRange::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSStaticRangePrototype::create(vm, &globalObject, structure);
}

JSObject* JSStaticRange::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSStaticRange>(vm, globalObject);
}

JSValue JSStaticRange::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSStaticRangeDOMConstructor, DOMConstructorID::StaticRange>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsStaticRangeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSStaticRangePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSStaticRange::getConstructor(vm, prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSStaticRange::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSStaticRange, UseCustomHeapCellType::No>(vm, "JSStaticRange"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForStaticRange.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForStaticRange = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForStaticRange.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForStaticRange = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSStaticRange::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSStaticRange*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSStaticRange);

template<typename Visitor>
void JSStaticRange::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSStaticRange*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSStaticRange::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSStaticRange::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSStaticRange::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSStaticRange*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7StaticRange@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11StaticRangeE[]; }
#endif
template<std::same_as<StaticRange> T>
static inline void verifyVTable(StaticRange* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7StaticRange@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore11StaticRangeE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // StaticRange has subclasses. If StaticRange has subclasses that get passed
        // to toJS() we currently require StaticRange you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<StaticRange>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<StaticRange>(impl.ptr());
#endif
    return createWrapper<StaticRange>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, StaticRange& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

StaticRange* JSStaticRange::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSStaticRange*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
