/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.text.TextController;

class GotoLinkNodeAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final LinkController linkController;
    private final NodeModel target;

    public GotoLinkNodeAction(LinkController linkController, String actionName, NodeModel target) {
        this(linkController, target);
    }

    public GotoLinkNodeAction(LinkController linkController, NodeModel target) {
        super("GotoLinkNodeAction");
        this.target = target;
        this.linkController = linkController;
    }

    public void configureText(String actionName, NodeModel target) {
        if (target != null) {
            String adaptedText = TextController.getController().getShortPlainText(target);
            this.putValue("Name", TextUtils.format(actionName, adaptedText));
            StringBuilder path = new StringBuilder();
            this.appendPath(path, target.getParentNode());
            path.append(target);
            this.putValue("ShortDescription", path.toString());
        }
    }

    private void appendPath(StringBuilder path, NodeModel target) {
        if (target != null) {
            this.appendPath(path, target.getParentNode());
            String shortText = TextController.getController().getShortPlainText(target);
            path.append(shortText);
            path.append(" -> ");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.linkController.onDeselect(Controller.getCurrentModeController().getMapController().getSelectedNode());
        Controller.getCurrentModeController().getMapController().select(this.target);
        this.linkController.onSelect(this.target);
    }
}

